/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.filemgr;

import com.jidesoft.swing.FolderChooser;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.explorer.filemgr.XDirChooser;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class XDirChooserJideImpl
implements XDirChooser {
    private boolean fProceed;
    private static final String DEFAULT_APPROVE_BUTTON_TEXT = "Open";
    private final Logger log = XLogger.getLogger(this.getClass());
    private FolderChooser fFolderChooser;

    public XDirChooserJideImpl() {
        this.init();
    }

    private void init() {
        this.fFolderChooser = new FolderChooser();
        this.fFolderChooser.setFileHidingEnabled(true);
    }

    @Override
    public final boolean show() {
        return this.show(Application.getWindowManager().getRootFrame());
    }

    public final boolean show(JFrame jFrame) {
        this.fProceed = false;
        int n = this.fFolderChooser.showOpenDialog(jFrame);
        this.fProceed = n == 0;
        return this.fProceed;
    }

    @Override
    public final File getSelectedDir() {
        if (this.fProceed) {
            Application.getFileManager().registerRecentlyOpenedDir(this.fFolderChooser.getSelectedFile());
            return this.fFolderChooser.getSelectedFile();
        }
        this.log.warn("asked for dir though proceed was false");
        return null;
    }

    @Override
    public final void setCurrentLocation(String string) {
        this.fFolderChooser.setCurrentDirectory(new File(string));
    }

    @Override
    public final void setRootLocation(String string) {
        this.setCurrentLocation(string);
    }

    @Override
    public final void setApproveButtonText(String string) {
        this.fFolderChooser.setApproveButtonText(string);
    }

    @Override
    public final void resetState() {
        File[] fileArray = Application.getFileManager().getRecentDirs();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            arrayList.add(fileArray[i2].getPath());
        }
        this.fFolderChooser.setRecentList(arrayList);
        this.fFolderChooser.setApproveButtonText(DEFAULT_APPROVE_BUTTON_TEXT);
    }
}

