/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.xbench.tui.ToolSelectorTree$Model;
import edu.mit.broad.xbench.tui.ToolSelectorTree$Renderer;
import edu.mit.broad.xbench.tui.ToolSelectorUI;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import xtools.api.Tool;

public class ToolSelectorTree
extends JTree
implements ToolSelectorUI {
    private final Tool[] fTools;
    private final Logger log = XLogger.getLogger(ToolSelectorTree.class);
    private final DefaultTreeModel fModel;
    private final Map fToolNodeMap;

    public ToolSelectorTree(Tool[] toolArray, boolean bl, boolean bl2) {
        this.fTools = toolArray;
        this.log.debug("Making tool tree with tools: " + toolArray.length + " showReportNode: " + bl);
        this.setRootVisible(bl2);
        this.setShowsRootHandles(true);
        DefaultTreeSelectionModel defaultTreeSelectionModel = new DefaultTreeSelectionModel();
        defaultTreeSelectionModel.setSelectionMode(1);
        this.setSelectionModel(defaultTreeSelectionModel);
        this.fToolNodeMap = new HashMap();
        this.fModel = new ToolSelectorTree$Model(this, bl);
        this.setModel(this.fModel);
        this.setCellRenderer(new ToolSelectorTree$Renderer());
    }

    @Override
    public final Tool selectTool(String string) {
        if (string == null) {
            return null;
        }
        for (int i2 = 0; i2 < this.fTools.length; ++i2) {
            if (!this.fTools[i2].getName().equalsIgnoreCase(string)) continue;
            TreePath treePath = this.getPath(this.fTools[i2]);
            this.setSelectionPath(treePath);
            this.expandPath(treePath);
            this.fireTreeExpanded(treePath);
            this.revalidate();
            return this.fTools[i2];
        }
        this.log.debug("Unknown tool name, and could not select it: " + string);
        return null;
    }

    @Override
    public final Component getComponent() {
        return this;
    }

    public final TreePath getPath(Tool tool) {
        Object[] objectArray;
        Object v = this.fToolNodeMap.get(tool);
        if (v == null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.fModel.getRoot();
            objectArray = this.fModel.getPathToRoot(defaultMutableTreeNode);
        } else {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)v;
            objectArray = this.fModel.getPathToRoot(defaultMutableTreeNode);
        }
        return new TreePath(objectArray);
    }

    static final /* synthetic */ Tool[] access$000(ToolSelectorTree toolSelectorTree) {
        return toolSelectorTree.fTools;
    }

    static final /* synthetic */ Map access$100(ToolSelectorTree toolSelectorTree) {
        return toolSelectorTree.fToolNodeMap;
    }
}

