/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import foxtrot.EventPump;
import foxtrot.JREVersion;
import foxtrot.Job;
import foxtrot.Task;
import foxtrot.Worker$1;
import foxtrot.Worker$2;
import foxtrot.WorkerThread;
import foxtrot.pumps.JDK13QueueEventPump;
import foxtrot.pumps.SunJDK140ConditionalEventPump;
import foxtrot.pumps.SunJDK141ConditionalEventPump;
import foxtrot.workers.DefaultWorkerThread;
import java.security.AccessController;
import javax.swing.SwingUtilities;

public class Worker {
    private static EventPump eventPump;
    private static WorkerThread workerThread;
    static final boolean debug = false;
    static Class class$foxtrot$Worker;

    private Worker() {
    }

    public static final Object post(Task task) {
        Worker.initializeWorkerThread();
        Worker.initializeEventPump();
        boolean bl = SwingUtilities.isEventDispatchThread();
        if (!bl && !workerThread.isWorkerThread()) {
            throw new IllegalStateException("Worker.post() can be called only from the AWT Event Dispatch Thread or from another Task");
        }
        if (!workerThread.isAlive()) {
            workerThread.start();
        }
        if (bl) {
            workerThread.postTask(task);
            eventPump.pumpEvents(task);
        } else {
            workerThread.runTask(task);
        }
        try {
            Object object = task.getResultOrThrow();
            Object var4_3 = null;
            task.reset();
            return object;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            task.reset();
            throw throwable;
        }
    }

    public static final Object post(Job job) {
        try {
            return Worker.post((Task)job);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
        catch (Error error) {
            throw error;
        }
    }

    public static final EventPump getEventPump() {
        Worker.initializeEventPump();
        return eventPump;
    }

    public static final void setEventPump(EventPump eventPump) {
        if (eventPump == null) {
            throw new IllegalArgumentException("EventPump cannot be null");
        }
        Worker.eventPump = eventPump;
    }

    public static final WorkerThread getWorkerThread() {
        Worker.initializeWorkerThread();
        return workerThread;
    }

    public static final void setWorkerThread(WorkerThread workerThread) {
        if (workerThread == null) {
            throw new IllegalArgumentException("WorkerThread cannot be null");
        }
        Worker.workerThread = workerThread;
    }

    private static void initializeWorkerThread() {
        if (workerThread != null) {
            return;
        }
        String string = (String)AccessController.doPrivileged(new Worker$1());
        if (string == null) {
            workerThread = new DefaultWorkerThread();
        } else {
            ClassLoader classLoader = (class$foxtrot$Worker == null ? (class$foxtrot$Worker = Worker.class$("foxtrot.Worker")) : class$foxtrot$Worker).getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                workerThread = (WorkerThread)classLoader.loadClass(string).newInstance();
            }
            catch (Throwable throwable) {
                workerThread = new DefaultWorkerThread();
            }
        }
    }

    private static void initializeEventPump() {
        if (eventPump != null) {
            return;
        }
        String string = (String)AccessController.doPrivileged(new Worker$2());
        if (string != null) {
            ClassLoader classLoader = (class$foxtrot$Worker == null ? (class$foxtrot$Worker = Worker.class$("foxtrot.Worker")) : class$foxtrot$Worker).getClassLoader();
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            try {
                eventPump = (EventPump)classLoader.loadClass(string).newInstance();
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (JREVersion.isJRE141()) {
            eventPump = new SunJDK141ConditionalEventPump();
        } else if (JREVersion.isJRE140()) {
            eventPump = new SunJDK140ConditionalEventPump();
        } else if (JREVersion.isJRE13() || JREVersion.isJRE12()) {
            eventPump = new JDK13QueueEventPump();
        } else {
            throw new Error("JDK 1.1 is not supported");
        }
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

