/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.THashMap$1;
import gnu.trove.THashMap$EntryView;
import gnu.trove.THashMap$EqProcedure;
import gnu.trove.THashMap$HashProcedure;
import gnu.trove.THashMap$KeyView;
import gnu.trove.THashMap$ValueView;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectObjectProcedure;
import gnu.trove.TObjectProcedure;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap
extends TObjectHash
implements Map,
Serializable {
    static final long serialVersionUID = 5182945951854128074L;
    protected transient Object[] _values;

    public THashMap() {
    }

    public THashMap(TObjectHashingStrategy tObjectHashingStrategy) {
        super(tObjectHashingStrategy);
    }

    public THashMap(int n) {
        super(n);
    }

    public THashMap(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, tObjectHashingStrategy);
    }

    public THashMap(int n, float f2) {
        super(n, f2);
    }

    public THashMap(int n, float f2, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f2, tObjectHashingStrategy);
    }

    public THashMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public THashMap(Map map, TObjectHashingStrategy tObjectHashingStrategy) {
        this(map.size(), tObjectHashingStrategy);
        this.putAll(map);
    }

    public Object clone() {
        THashMap tHashMap = (THashMap)super.clone();
        tHashMap._values = (Object[])this._values.clone();
        return tHashMap;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new Object[n2];
        return n2;
    }

    public Object put(Object object, Object object2) {
        Object object3 = null;
        Object object4 = null;
        int n = this.insertionIndex(object);
        boolean bl = true;
        if (n < 0) {
            n = -n - 1;
            object3 = this._values[n];
            bl = false;
        }
        object4 = this._set[n];
        this._set[n] = object;
        this._values[n] = object2;
        if (bl) {
            this.postInsertHook(object4 == FREE);
        }
        return object3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new THashMap$EqProcedure(map));
    }

    public int hashCode() {
        THashMap$HashProcedure tHashMap$HashProcedure = new THashMap$HashProcedure(this, null);
        this.forEachEntry(tHashMap$HashProcedure);
        return tHashMap$HashProcedure.getHashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        this.forEachEntry(new THashMap$1(this, stringBuffer));
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean forEachKey(TObjectProcedure tObjectProcedure) {
        return this.forEach(tObjectProcedure);
    }

    public boolean forEachValue(TObjectProcedure tObjectProcedure) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == FREE || objectArray2[n] == REMOVED || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectObjectProcedure tObjectObjectProcedure) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectObjectProcedure tObjectObjectProcedure) {
        boolean bl = false;
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectObjectProcedure.execute(objectArray[n], objectArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TObjectFunction tObjectFunction) {
        Object[] objectArray = this._values;
        Object[] objectArray2 = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray2[n] == FREE || objectArray2[n] == REMOVED) continue;
            objectArray[n] = tObjectFunction.execute(objectArray[n]);
        }
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        this._set = new Object[n];
        Arrays.fill(this._set, FREE);
        this._values = new Object[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (objectArray[n3] == FREE || objectArray[n3] == REMOVED) continue;
            Object object = objectArray[n3];
            int n4 = this.insertionIndex(object);
            if (n4 < 0) {
                this.throwObjectContractViolation(this._set[-n4 - 1], object);
            }
            this._set[n4] = object;
            this._values[n4] = objectArray2[n3];
        }
    }

    public Object get(Object object) {
        int n = this.index(object);
        return n < 0 ? null : this._values[n];
    }

    public void clear() {
        super.clear();
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        int n = objectArray.length;
        while (n-- > 0) {
            objectArray[n] = FREE;
            objectArray2[n] = null;
        }
    }

    public Object remove(Object object) {
        Object object2 = null;
        int n = this.index(object);
        if (n >= 0) {
            object2 = this._values[n];
            this.removeAt(n);
        }
        return object2;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = null;
    }

    public Collection values() {
        return new THashMap$ValueView(this);
    }

    public Set keySet() {
        return new THashMap$KeyView(this);
    }

    public Set entrySet() {
        return new THashMap$EntryView(this);
    }

    public boolean containsValue(Object object) {
        Object[] objectArray = this._set;
        Object[] objectArray2 = this._values;
        if (null == object) {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != objectArray2[n]) continue;
                return true;
            }
        } else {
            int n = objectArray2.length;
            while (n-- > 0) {
                if (objectArray[n] == FREE || objectArray[n] == REMOVED || object != objectArray2[n] && !object.equals(objectArray2[n])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        return this.contains(object);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }
}

