/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntIntHashMap$EqProcedure;
import gnu.trove.TIntIntHashMap$HashProcedure;
import gnu.trove.TIntIntIterator;
import gnu.trove.TIntIntProcedure;
import gnu.trove.TIntProcedure;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntIntHashMap
extends TIntHash
implements Serializable {
    static final long serialVersionUID = 1L;
    protected transient int[] _values;

    public TIntIntHashMap() {
    }

    public TIntIntHashMap(int n) {
        super(n);
    }

    public TIntIntHashMap(int n, float f2) {
        super(n, f2);
    }

    public TIntIntHashMap(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntIntHashMap(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntIntHashMap(int n, float f2, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f2, tIntHashingStrategy);
    }

    public Object clone() {
        TIntIntHashMap tIntIntHashMap = (TIntIntHashMap)super.clone();
        tIntIntHashMap._values = (int[])this._values.clone();
        return tIntIntHashMap;
    }

    public TIntIntIterator iterator() {
        return new TIntIntIterator(this);
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._values = new int[n2];
        return n2;
    }

    public int put(int n, int n2) {
        int n3 = 0;
        int n4 = this.insertionIndex(n);
        boolean bl = true;
        if (n4 < 0) {
            n4 = -n4 - 1;
            n3 = this._values[n4];
            bl = false;
        }
        byte by = this._states[n4];
        this._set[n4] = n;
        this._states[n4] = 1;
        this._values[n4] = n2;
        if (bl) {
            this.postInsertHook(by == 0);
        }
        return n3;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._values = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._values[n5] = nArray2[n3];
            this._states[n5] = 1;
        }
    }

    public int get(int n) {
        int n2 = this.index(n);
        return n2 < 0 ? 0 : this._values[n2];
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            nArray2[n] = 0;
            byArray[n] = 0;
        }
    }

    public int remove(int n) {
        int n2 = 0;
        int n3 = this.index(n);
        if (n3 >= 0) {
            n2 = this._values[n3];
            this.removeAt(n3);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntIntHashMap)) {
            return false;
        }
        TIntIntHashMap tIntIntHashMap = (TIntIntHashMap)object;
        if (tIntIntHashMap.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new TIntIntHashMap$EqProcedure(tIntIntHashMap));
    }

    public int hashCode() {
        TIntIntHashMap$HashProcedure tIntIntHashMap$HashProcedure = new TIntIntHashMap$HashProcedure(this, null);
        this.forEachEntry(tIntIntHashMap$HashProcedure);
        return tIntIntHashMap$HashProcedure.getHashCode();
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._values[n] = 0;
    }

    public int[] getValues() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._values;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public int[] keys() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public boolean containsValue(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n2 = nArray.length;
        while (n2-- > 0) {
            if (byArray[n2] != 1 || n != nArray[n2]) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(int n) {
        return this.contains(n);
    }

    public boolean forEachKey(TIntProcedure tIntProcedure) {
        return this.forEach(tIntProcedure);
    }

    public boolean forEachValue(TIntProcedure tIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntIntProcedure tIntIntProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntIntProcedure.execute(nArray[n], nArray2[n])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntIntProcedure tIntIntProcedure) {
        boolean bl = false;
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int[] nArray2 = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || tIntIntProcedure.execute(nArray[n], nArray2[n])) continue;
            this.removeAt(n);
            bl = true;
        }
        return bl;
    }

    public void transformValues(TIntFunction tIntFunction) {
        byte[] byArray = this._states;
        int[] nArray = this._values;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n] = tIntFunction.execute(nArray[n]);
        }
    }

    public boolean increment(int n) {
        return this.adjustValue(n, 1);
    }

    public boolean adjustValue(int n, int n2) {
        int n3 = this.index(n);
        if (n3 < 0) {
            return false;
        }
        int n4 = n3;
        this._values[n4] = this._values[n4] + n2;
        return true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEachEntry(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            int n3 = objectInputStream.readInt();
            this.put(n2, n3);
        }
    }
}

