/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ReaderWriterLock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.jai.CollectionImageFactory;
import javax.media.jai.JaiI18N;
import javax.media.jai.PartialOrderNode;

class OperationGraph {
    protected Vector RIFoperations = new Vector();
    protected Vector CIFoperations = new Vector();
    protected Vector orderedRIFOperations;
    protected Vector orderedCIFOperations;
    protected boolean isRIFChanged = true;
    protected boolean isCIFChanged = true;
    ReaderWriterLock lock = new ReaderWriterLock();

    public final void addCIF(CollectionImageFactory collectionImageFactory) {
        this.lock.getWriteLock();
        PartialOrderNode partialOrderNode = new PartialOrderNode(collectionImageFactory, collectionImageFactory.getClass().getName());
        this.CIFoperations.addElement(partialOrderNode);
        this.isCIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final void addRIF(RenderedImageFactory renderedImageFactory) {
        this.lock.getWriteLock();
        PartialOrderNode partialOrderNode = new PartialOrderNode(renderedImageFactory, renderedImageFactory.getClass().getName());
        this.RIFoperations.addElement(partialOrderNode);
        this.isRIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final Vector getOrderedOperationList(String string) {
        if (string.equalsIgnoreCase("rif")) {
            this.lock.getReadLock();
            if (!this.isRIFChanged) {
                Vector vector = this.orderedRIFOperations;
                this.lock.releaseReadLock();
                return vector;
            }
            this.lock.releaseReadLock();
            this.lock.getWriteLock();
            if (!this.isRIFChanged) {
                Vector vector = this.orderedRIFOperations;
                this.lock.releaseWriteLock();
                return vector;
            }
            Vector vector = this.RIFoperations;
            this.orderedRIFOperations = this.orderList(vector);
            this.isRIFChanged = false;
            Vector vector2 = this.orderedRIFOperations;
            this.lock.releaseWriteLock();
            return vector2;
        }
        if (string.equalsIgnoreCase("cif")) {
            this.lock.getReadLock();
            if (!this.isCIFChanged) {
                Vector vector = this.orderedCIFOperations;
                this.lock.releaseReadLock();
                return vector;
            }
            this.lock.releaseReadLock();
            this.lock.getWriteLock();
            if (!this.isCIFChanged) {
                Vector vector = this.orderedCIFOperations;
                this.lock.releaseWriteLock();
                return vector;
            }
            Vector vector = this.CIFoperations;
            this.orderedCIFOperations = this.orderList(vector);
            this.isCIFChanged = false;
            Vector vector3 = this.orderedCIFOperations;
            this.lock.releaseWriteLock();
            return vector3;
        }
        throw new Error(String.valueOf(string) + " " + JaiI18N.getString("OperationGraph8"));
    }

    public final PartialOrderNode lookupCIF(CollectionImageFactory collectionImageFactory) {
        this.lock.getReadLock();
        int n = this.CIFoperations.size();
        int n2 = 0;
        while (n2 < n) {
            PartialOrderNode partialOrderNode = (PartialOrderNode)this.CIFoperations.elementAt(n2);
            if ((CollectionImageFactory)partialOrderNode.getData() == collectionImageFactory) {
                PartialOrderNode partialOrderNode2 = partialOrderNode;
                this.lock.releaseReadLock();
                return partialOrderNode2;
            }
            ++n2;
        }
        this.lock.releaseReadLock();
        return null;
    }

    public final PartialOrderNode lookupRIF(RenderedImageFactory renderedImageFactory) {
        this.lock.getReadLock();
        int n = this.RIFoperations.size();
        int n2 = 0;
        while (n2 < n) {
            PartialOrderNode partialOrderNode = (PartialOrderNode)this.RIFoperations.elementAt(n2);
            if ((RenderedImageFactory)partialOrderNode.getData() == renderedImageFactory) {
                PartialOrderNode partialOrderNode2 = partialOrderNode;
                this.lock.releaseReadLock();
                return partialOrderNode2;
            }
            ++n2;
        }
        this.lock.releaseReadLock();
        return null;
    }

    private Vector orderList(Vector vector) {
        PartialOrderNode partialOrderNode;
        Cloneable cloneable;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            cloneable = (PartialOrderNode)vector.elementAt(n2);
            ((PartialOrderNode)cloneable).setCopyInDegree(((PartialOrderNode)cloneable).getInDegree());
            ++n2;
        }
        cloneable = new Vector(n);
        PartialOrderNode partialOrderNode2 = null;
        int n3 = 0;
        while (n3 < n) {
            partialOrderNode = (PartialOrderNode)vector.elementAt(n3);
            if (partialOrderNode.getCopyInDegree() == 0) {
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            if (partialOrderNode2 == null) {
                return null;
            }
            PartialOrderNode partialOrderNode3 = partialOrderNode2;
            ((Vector)cloneable).addElement(partialOrderNode3);
            partialOrderNode2 = partialOrderNode2.getZeroLink();
            Enumeration enumeration = partialOrderNode3.getNeighbors();
            while (enumeration.hasMoreElements()) {
                partialOrderNode = (PartialOrderNode)enumeration.nextElement();
                partialOrderNode.decrementCopyInDegree();
                if (partialOrderNode.getCopyInDegree() != 0) continue;
                partialOrderNode.setZeroLink(partialOrderNode2);
                partialOrderNode2 = partialOrderNode;
            }
            ++n4;
        }
        return cloneable;
    }

    public final synchronized void removeCIF(CollectionImageFactory collectionImageFactory) {
        PartialOrderNode partialOrderNode = this.lookupCIF(collectionImageFactory);
        this.lock.getWriteLock();
        if (partialOrderNode != null) {
            this.CIFoperations.removeElement(partialOrderNode);
        }
        this.isCIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final synchronized void removeRIF(RenderedImageFactory renderedImageFactory) {
        PartialOrderNode partialOrderNode = this.lookupRIF(renderedImageFactory);
        this.lock.getWriteLock();
        if (partialOrderNode != null) {
            this.RIFoperations.removeElement(partialOrderNode);
        }
        this.isRIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final void setCIFPreference(CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        PartialOrderNode partialOrderNode = this.lookupCIF(collectionImageFactory);
        PartialOrderNode partialOrderNode2 = this.lookupCIF(collectionImageFactory2);
        this.lock.getWriteLock();
        partialOrderNode.addEdge(partialOrderNode2);
        this.isCIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final synchronized void setRIFPreference(RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        PartialOrderNode partialOrderNode = this.lookupRIF(renderedImageFactory);
        PartialOrderNode partialOrderNode2 = this.lookupRIF(renderedImageFactory2);
        this.lock.getWriteLock();
        partialOrderNode.addEdge(partialOrderNode2);
        this.isRIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final void unsetCIFPreference(CollectionImageFactory collectionImageFactory, CollectionImageFactory collectionImageFactory2) {
        PartialOrderNode partialOrderNode = this.lookupCIF(collectionImageFactory);
        PartialOrderNode partialOrderNode2 = this.lookupCIF(collectionImageFactory2);
        this.lock.getWriteLock();
        partialOrderNode.removeEdge(partialOrderNode2);
        this.isCIFChanged = true;
        this.lock.releaseWriteLock();
    }

    public final synchronized void unsetRIFPreference(RenderedImageFactory renderedImageFactory, RenderedImageFactory renderedImageFactory2) {
        PartialOrderNode partialOrderNode = this.lookupRIF(renderedImageFactory);
        PartialOrderNode partialOrderNode2 = this.lookupRIF(renderedImageFactory2);
        this.lock.getWriteLock();
        partialOrderNode.removeEdge(partialOrderNode2);
        this.isRIFChanged = true;
        this.lock.releaseWriteLock();
    }
}

