/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.ImageUtil;
import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.DataBufferDouble;
import javax.media.jai.DataBufferFloat;
import javax.media.jai.ImageJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.RenderedImageAdapter;
import javax.media.jai.SnapshotImage;
import javax.media.jai.WritableRenderedImageAdapter;
import sun.awt.image.BytePackedRaster;

public abstract class PlanarImage
implements ImageJAI,
RenderedImage {
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected SampleModel sampleModel = null;
    protected ColorModel colorModel = null;
    protected SnapshotImage snapshot = null;
    private Hashtable properties = null;
    private static final int MIN_ARRAYCOPY_SIZE = 64;
    private WeakReference weakThis;
    private AbstractList sinks = new ArrayList(5);
    private static final ColorModel[][] defaultColorModels = new ColorModel[6][5];
    protected PlanarImage source0 = null;
    protected PlanarImage source1 = null;
    protected Vector sources = null;
    private boolean disposed = false;

    static {
        int n = 0;
        while (n <= 5) {
            if (n != 2) {
                int n2 = 1;
                while (n2 <= 4) {
                    ColorSpace colorSpace = n2 < 3 ? ColorSpace.getInstance(1003) : ColorSpace.getInstance(1000);
                    boolean bl = n2 == 2 || n2 == 4;
                    int n3 = bl ? 3 : 1;
                    PlanarImage.defaultColorModels[n][n2] = RasterFactory.createComponentColorModel(n, colorSpace, bl, false, n3);
                    ++n2;
                }
            }
            ++n;
        }
    }

    public PlanarImage() {
        this.weakThis = new WeakReference<PlanarImage>(this);
    }

    public final int XToTileX(int n) {
        return PlanarImage.XToTileX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public static final int XToTileX(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    public final int YToTileY(int n) {
        return PlanarImage.YToTileY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static final int YToTileY(int n, int n2, int n3) {
        if ((n -= n2) < 0) {
            n += 1 - n3;
        }
        return n / n3;
    }

    protected synchronized void addSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
        }
        this.sinks.add(planarImage.weakThis);
    }

    protected synchronized void addSource(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        if (this.source0 == null) {
            this.source0 = planarImage;
        } else if (this.source1 == null) {
            this.source1 = planarImage;
        } else {
            if (this.sources == null) {
                this.sources = new Vector();
            }
            this.sources.addElement(planarImage);
        }
        planarImage.addSink(this);
    }

    private void cobbleByte(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferByte dataBufferByte2 = (DataBufferByte)raster2.getDataBuffer();
                    byte[] byArray2 = dataBufferByte2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(byArray2, n25, byArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                byArray[n28++] = byArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    private void cobbleDouble(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferDouble dataBufferDouble = (DataBufferDouble)raster.getDataBuffer();
        double[] dArray = dataBufferDouble.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferDouble dataBufferDouble2 = (DataBufferDouble)raster2.getDataBuffer();
                    double[] dArray2 = dataBufferDouble2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(dArray2, n25, dArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                dArray[n28++] = dArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    private void cobbleFloat(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferFloat dataBufferFloat = (DataBufferFloat)raster.getDataBuffer();
        float[] fArray = dataBufferFloat.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferFloat dataBufferFloat2 = (DataBufferFloat)raster2.getDataBuffer();
                    float[] fArray2 = dataBufferFloat2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(fArray2, n25, fArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                fArray[n28++] = fArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    private void cobbleInt(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferInt dataBufferInt = (DataBufferInt)raster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferInt dataBufferInt2 = (DataBufferInt)raster2.getDataBuffer();
                    int[] nArray2 = dataBufferInt2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(nArray2, n25, nArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                nArray[n28++] = nArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    private void cobbleShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferShort dataBufferShort = (DataBufferShort)raster.getDataBuffer();
        short[] sArray = dataBufferShort.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferShort dataBufferShort2 = (DataBufferShort)raster2.getDataBuffer();
                    short[] sArray2 = dataBufferShort2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(sArray2, n25, sArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                sArray[n28++] = sArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    private void cobbleUShort(Rectangle rectangle, Raster raster) {
        ComponentSampleModel componentSampleModel = (ComponentSampleModel)raster.getSampleModel();
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = rectangle.x + rectangle.width - 1;
        int n4 = rectangle.y + rectangle.height - 1;
        int n5 = this.XToTileX(n3);
        int n6 = this.YToTileY(n4);
        DataBufferUShort dataBufferUShort = (DataBufferUShort)raster.getDataBuffer();
        short[] sArray = dataBufferUShort.getData();
        int n7 = componentSampleModel.getPixelStride();
        int n8 = componentSampleModel.getScanlineStride();
        boolean bl = false;
        ComponentSampleModel componentSampleModel2 = null;
        int n9 = 0;
        int n10 = 0;
        this.tileWidth = this.getTileWidth();
        this.tileHeight = this.getTileHeight();
        this.tileGridXOffset = this.getTileGridXOffset();
        this.tileGridYOffset = this.getTileGridYOffset();
        int n11 = n2;
        while (n11 <= n6) {
            int n12 = n;
            while (n12 <= n5) {
                Raster raster2 = this.getTile(n12, n11);
                if (raster2 != null) {
                    int n13;
                    int n14;
                    int n15;
                    if (!bl) {
                        componentSampleModel2 = (ComponentSampleModel)raster2.getSampleModel();
                        n9 = componentSampleModel2.getPixelStride();
                        n10 = componentSampleModel2.getScanlineStride();
                        bl = true;
                    }
                    int n16 = n15 = n11 * this.tileHeight + this.tileGridYOffset;
                    int n17 = n16 + this.tileHeight - 1;
                    if (rectangle.y > n16) {
                        n16 = rectangle.y;
                    }
                    if (n4 < n17) {
                        n17 = n4;
                    }
                    int n18 = n17 - n16 + 1;
                    int n19 = n14 = n12 * this.tileWidth + this.tileGridXOffset;
                    int n20 = n19 + this.tileWidth - 1;
                    if (rectangle.x > n19) {
                        n19 = rectangle.x;
                    }
                    if (n3 < n20) {
                        n20 = n3;
                    }
                    int n21 = n20 - n19 + 1;
                    int n22 = n19 - rectangle.x;
                    int n23 = n16 - rectangle.y;
                    DataBufferUShort dataBufferUShort2 = (DataBufferUShort)raster2.getDataBuffer();
                    short[] sArray2 = dataBufferUShort2.getData();
                    int n24 = n21 * n9;
                    boolean bl2 = n24 >= 64;
                    int n25 = (n16 - n15) * n10 + (n19 - n14) * n9;
                    int n26 = n23 * n8 + n22 * n7;
                    if (bl2) {
                        n13 = 0;
                        while (n13 < n18) {
                            System.arraycopy(sArray2, n25, sArray, n26, n24);
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    } else {
                        n13 = 0;
                        while (n13 < n18) {
                            int n27 = n25;
                            int n28 = n26;
                            int n29 = n28 + n24;
                            while (n28 < n29) {
                                sArray[n28++] = sArray2[n27++];
                            }
                            n25 += n10;
                            n26 += n8;
                            ++n13;
                        }
                    }
                }
                ++n12;
            }
            ++n11;
        }
    }

    public WritableRaster copyData() {
        return this.copyData(null);
    }

    public WritableRaster copyData(WritableRaster writableRaster) {
        Rectangle rectangle;
        if (writableRaster == null) {
            rectangle = this.getBounds();
            writableRaster = RasterFactory.createWritableRaster(this.getSampleModel().createCompatibleSampleModel(rectangle.width, rectangle.height), rectangle.getLocation());
        } else {
            rectangle = writableRaster.getBounds().intersection(this.getBounds());
            if (rectangle.isEmpty()) {
                return writableRaster;
            }
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        SampleModel[] sampleModelArray = new SampleModel[]{this.getSampleModel()};
        int n5 = RasterAccessor.findCompatibleTag(sampleModelArray, writableRaster.getSampleModel());
        RasterFormatTag rasterFormatTag = new RasterFormatTag(this.getSampleModel(), n5);
        RasterFormatTag rasterFormatTag2 = new RasterFormatTag(writableRaster.getSampleModel(), n5);
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                Raster raster = this.getTile(n7, n6);
                Rectangle rectangle2 = rectangle.intersection(raster.getBounds());
                RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle2, rasterFormatTag, this.getColorModel());
                RasterAccessor rasterAccessor2 = new RasterAccessor(writableRaster, rectangle2, rasterFormatTag2, null);
                ImageUtil.copyRaster(rasterAccessor, rasterAccessor2);
                ++n7;
            }
            ++n6;
        }
        return writableRaster;
    }

    public final void copyExtendedData(WritableRaster writableRaster, BorderExtender borderExtender) {
        if (writableRaster == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage15"));
        }
        if (borderExtender == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage16"));
        }
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = writableRaster.getBounds();
        Rectangle rectangle3 = rectangle.intersection(rectangle2);
        WritableRaster writableRaster2 = RasterFactory.createWritableChild(writableRaster, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
        this.copyData(writableRaster2);
        borderExtender.extend(writableRaster, this);
    }

    public static final ColorModel createColorModel(SampleModel sampleModel) {
        if (sampleModel == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage2"));
        }
        int n = sampleModel.getNumBands();
        if (n > 4) {
            return null;
        }
        if (sampleModel instanceof ComponentSampleModel) {
            int n2 = sampleModel.getDataType();
            return defaultColorModels[n2][n];
        }
        if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            int[] nArray = singlePixelPackedSampleModel.getBitMasks();
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = nArray.length;
            if (n7 <= 2) {
                n4 = n5 = nArray[0];
                n3 = n5;
                if (n7 == 2) {
                    n6 = nArray[1];
                }
            } else {
                n3 = nArray[0];
                n4 = nArray[1];
                n5 = nArray[2];
                if (n7 == 4) {
                    n6 = nArray[3];
                }
            }
            int[] nArray2 = singlePixelPackedSampleModel.getSampleSize();
            int n8 = 0;
            int n9 = 0;
            while (n9 < nArray2.length) {
                n8 += nArray2[n9];
                ++n9;
            }
            return new DirectColorModel(n8, n3, n4, n5, n6);
        }
        return null;
    }

    public synchronized PlanarImage createSnapshot() {
        if (this instanceof WritableRenderedImage) {
            if (this.snapshot == null) {
                this.snapshot = new SnapshotImage(this);
            }
            return this.snapshot.createSnapshot();
        }
        return this;
    }

    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        int n = this.getNumSources();
        if (this.source0 != null) {
            this.source0.removeSink(this);
        }
        if (this.source1 != null) {
            this.source1.removeSink(this);
        }
        int n2 = 2;
        while (n2 < n) {
            PlanarImage planarImage = this.getSource(n2);
            planarImage.removeSink(this);
            ++n2;
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public final BufferedImage getAsBufferedImage() {
        return this.getAsBufferedImage(null, null);
    }

    public final BufferedImage getAsBufferedImage(Rectangle rectangle, ColorModel colorModel) {
        rectangle = rectangle == null ? this.getBounds() : rectangle.intersection(this.getBounds());
        SampleModel sampleModel = this.getSampleModel().createCompatibleSampleModel(rectangle.width, rectangle.height);
        Point point = new Point(rectangle.x, rectangle.y);
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, point);
        this.copyData(writableRaster);
        if (rectangle.x != 0 || rectangle.y != 0) {
            writableRaster = RasterFactory.createWritableChild(writableRaster, rectangle.x, rectangle.y, rectangle.width, rectangle.height, 0, 0, null);
        }
        ColorModel colorModel2 = colorModel == null ? this.getColorModel() : colorModel;
        return new BufferedImage(colorModel2, writableRaster, colorModel2.isAlphaPremultiplied(), null);
    }

    public final Rectangle getBounds() {
        return new Rectangle(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight());
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Raster getData() {
        return this.getData(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Raster getData(Rectangle rectangle) {
        WritableRaster writableRaster;
        int n;
        int n2;
        Rectangle rectangle2 = this.getBounds();
        if (rectangle == null) {
            rectangle = rectangle2;
        } else if (!rectangle.intersects(rectangle2)) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage14"));
        }
        int n3 = this.XToTileX(rectangle.x);
        int n4 = this.YToTileY(rectangle.y);
        int n5 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n6 = this.YToTileY(rectangle.y + rectangle.height - 1);
        if (n3 == n5 && n4 == n6) {
            Raster raster = this.getTile(n3, n4);
            return raster.createChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, null);
        }
        SampleModel sampleModel = this.getSampleModel();
        int n7 = sampleModel.getDataType();
        int n8 = sampleModel.getNumBands();
        boolean bl = false;
        ComponentSampleModel componentSampleModel = null;
        int[] nArray = null;
        boolean bl2 = false;
        if (sampleModel instanceof ComponentSampleModel) {
            componentSampleModel = (ComponentSampleModel)sampleModel;
            int n9 = componentSampleModel.getPixelStride();
            n2 = n9 != 1 || n8 <= 1 ? 0 : 1;
            boolean bl3 = bl = n9 > 1 && n8 != n9;
            if (!bl && n2 == 0) {
                nArray = componentSampleModel.getBandOffsets();
                n = 0;
                while (n < n8) {
                    if (nArray[n] >= n8) break;
                    ++n;
                }
                if (n == n8) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            try {
                writableRaster = RasterFactory.createInterleavedRaster(n7, rectangle.width, rectangle.height, rectangle.width * n8, n8, nArray, rectangle.getLocation());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException(JaiI18N.getString("PlanarImage18"));
            }
            switch (n7) {
                case 0: {
                    this.cobbleByte(rectangle, writableRaster);
                    return writableRaster;
                }
                case 2: {
                    this.cobbleShort(rectangle, writableRaster);
                    return writableRaster;
                }
                case 1: {
                    this.cobbleUShort(rectangle, writableRaster);
                    return writableRaster;
                }
                case 3: {
                    this.cobbleInt(rectangle, writableRaster);
                    return writableRaster;
                }
                case 4: {
                    this.cobbleFloat(rectangle, writableRaster);
                    return writableRaster;
                }
                case 5: {
                    this.cobbleDouble(rectangle, writableRaster);
                    return writableRaster;
                }
                default: {
                    return writableRaster;
                }
            }
        }
        SampleModel sampleModel2 = null;
        sampleModel2 = sampleModel2 instanceof BandedSampleModel ? new BandedSampleModel(this.sampleModel.getDataType(), rectangle.width, rectangle.height, n8) : this.sampleModel.createCompatibleSampleModel(rectangle.width, rectangle.height);
        try {
            writableRaster = RasterFactory.createWritableRaster(sampleModel2, rectangle.getLocation());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage18"));
        }
        n2 = n4;
        while (n2 <= n6) {
            n = n3;
            while (n <= n5) {
                Raster raster = this.getTile(n, n2);
                Rectangle rectangle3 = rectangle.intersection(raster.getBounds());
                Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                if (raster instanceof BytePackedRaster) {
                    JDKWorkarounds.setRect(writableRaster, raster2);
                } else if (sampleModel2 instanceof ComponentSampleModel && bl) {
                    switch (sampleModel2.getDataType()) {
                        case 4: {
                            writableRaster.setPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, raster2.getPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, new float[n8 * rectangle3.width * rectangle3.height]));
                            break;
                        }
                        case 5: {
                            writableRaster.setPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, raster2.getPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, new double[n8 * rectangle3.width * rectangle3.height]));
                            break;
                        }
                        default: {
                            writableRaster.setPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, raster2.getPixels(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, new int[n8 * rectangle3.width * rectangle3.height]));
                            break;
                        }
                    }
                } else {
                    writableRaster.setDataElements(0, 0, raster2);
                }
                ++n;
            }
            ++n2;
        }
        return writableRaster;
    }

    public final Raster getExtendedData(Rectangle rectangle, BorderExtender borderExtender) {
        Rectangle rectangle2 = this.getBounds();
        if (rectangle2.contains(rectangle)) {
            return this.getData(rectangle);
        }
        SampleModel sampleModel = this.getSampleModel().createCompatibleSampleModel(rectangle.width, rectangle.height);
        WritableRaster writableRaster = RasterFactory.createWritableRaster(sampleModel, rectangle.getLocation());
        this.copyExtendedData(writableRaster, borderExtender);
        return writableRaster;
    }

    public Graphics getGraphics() {
        throw new IllegalAccessError(JaiI18N.getString("PlanarImage1"));
    }

    public int getHeight() {
        return this.height;
    }

    public final int getMaxTileX() {
        return this.XToTileX(this.getMaxX() - 1);
    }

    public final int getMaxTileY() {
        return this.YToTileY(this.getMaxY() - 1);
    }

    public int getMaxX() {
        return this.minX + this.width;
    }

    public int getMaxY() {
        return this.minY + this.height;
    }

    public final int getMinTileX() {
        return this.XToTileX(this.getMinX());
    }

    public final int getMinTileY() {
        return this.YToTileY(this.getMinY());
    }

    public int getMinX() {
        return this.minX;
    }

    public int getMinY() {
        return this.minY;
    }

    public synchronized int getNumSources() {
        int n = 0;
        if (this.source0 != null) {
            ++n;
        }
        if (this.source1 != null) {
            ++n;
        }
        if (this.sources != null) {
            n += this.sources.size();
        }
        return n;
    }

    public final int getNumXTiles() {
        return this.getMaxTileX() - this.getMinTileX() + 1;
    }

    public final int getNumYTiles() {
        return this.getMaxTileY() - this.getMinTileY() + 1;
    }

    protected synchronized Hashtable getProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public Object getProperty(String string) {
        Hashtable hashtable = this.getProperties();
        Object v = hashtable.get(string);
        return v == null ? Image.UndefinedProperty : v;
    }

    public String[] getPropertyNames() {
        Hashtable hashtable = this.getProperties();
        if (hashtable.size() > 0) {
            String[] stringArray = new String[hashtable.size()];
            int n = 0;
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                stringArray[n++] = (String)enumeration.nextElement();
            }
            return stringArray;
        }
        return null;
    }

    public String[] getPropertyNames(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage10"));
        }
        String[] stringArray = this.getPropertyNames();
        return PlanarImage.getPropertyNames(stringArray, string);
    }

    static final String[] getPropertyNames(String[] stringArray, String string) {
        if (stringArray == null) {
            return null;
        }
        string = string.toLowerCase();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].startsWith(string)) {
                vector.addElement(stringArray[n]);
            }
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray2 = new String[vector.size()];
        int n2 = 0;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            stringArray2[n2++] = (String)iterator.next();
        }
        return stringArray2;
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public synchronized Vector getSinks() {
        Vector vector = new Vector();
        Iterator iterator = this.sinks.iterator();
        while (iterator.hasNext()) {
            Object t = ((WeakReference)iterator.next()).get();
            if (t == null) continue;
            vector.add(t);
        }
        return vector.size() > 0 ? vector : null;
    }

    public synchronized PlanarImage getSource(int n) {
        if (n == 0) {
            if (this.source0 == null) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage4"));
            }
            return this.source0;
        }
        if (n == 1) {
            if (this.source1 == null) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage4"));
            }
            return this.source1;
        }
        if (n >= 2) {
            if (this.sources == null) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage4"));
            }
            return (PlanarImage)this.sources.elementAt(n - 2);
        }
        throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage5"));
    }

    public synchronized Vector getSources() {
        Vector<PlanarImage> vector = new Vector<PlanarImage>();
        if (this.source0 != null) {
            vector.add(this.source0);
        }
        if (this.source1 != null) {
            vector.add(this.source1);
        }
        if (this.sources != null) {
            vector.addAll(this.sources);
        }
        return vector;
    }

    public final void getSplits(IntegerSequence integerSequence, IntegerSequence integerSequence2, Rectangle rectangle) {
        if (integerSequence == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage11"));
        }
        if (integerSequence2 == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage12"));
        }
        if (rectangle == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage13"));
        }
        int n = this.getTileWidth();
        int n2 = this.XToTileX(rectangle.x);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.tileXToX(n2);
        int n5 = n2;
        while (n5 <= n3) {
            integerSequence.insert(n4);
            n4 += n;
            ++n5;
        }
        int n6 = this.getTileHeight();
        int n7 = this.YToTileY(rectangle.y);
        int n8 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n9 = this.tileYToY(n7);
        int n10 = n7;
        while (n10 <= n8) {
            integerSequence2.insert(n9);
            n9 += n6;
            ++n10;
        }
    }

    public abstract Raster getTile(int var1, int var2);

    public int getTileGridXOffset() {
        return this.tileGridXOffset;
    }

    public int getTileGridYOffset() {
        return this.tileGridYOffset;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public final Rectangle getTileRect(int n, int n2) {
        return this.getBounds().intersection(new Rectangle(this.tileXToX(n), this.tileYToY(n2), this.getTileWidth(), this.getTileHeight()));
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public Raster[] getTiles(Point[] pointArray) {
        int n = pointArray.length;
        Raster[] rasterArray = new Raster[n];
        int n2 = 0;
        while (n2 < pointArray.length) {
            Point point = pointArray[n2];
            rasterArray[n2] = this.getTile(point.x, point.y);
            ++n2;
        }
        return rasterArray;
    }

    public int getWidth() {
        return this.width;
    }

    public void prefetchTiles(Point[] pointArray) {
        JAI.getDefaultInstance().getTileScheduler().prefetchTiles(this, pointArray);
    }

    private void print() {
        System.out.println("RenderedImage:");
        System.out.println("Min X Coord = " + this.getMinX());
        System.out.println("Max X Coord = " + this.getMaxX());
        System.out.println("Min Y Coord = " + this.getMinY());
        System.out.println("Max Y Coord = " + this.getMaxY());
        System.out.println("Min Tile X = " + this.getMinTileX());
        System.out.println("Max Tile X = " + this.getMaxTileX());
        System.out.println("Min Tile Y = " + this.getMinTileY());
        System.out.println("Max Tile Y = " + this.getMaxTileY());
        System.out.println("Tile Grid X Offset = " + this.getTileGridXOffset());
        System.out.println("Tile Grid Y Offset = " + this.getTileGridYOffset());
        System.out.println("Tile Width = " + this.getTileWidth());
        System.out.println("Tile Height = " + this.getTileHeight());
        int n = this.getMinTileX();
        int n2 = this.getMaxTileX();
        int n3 = this.getMinTileY();
        int n4 = this.getMaxTileY();
        int n5 = n3;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n2) {
                System.out.println("\nTile (" + n6 + ", " + n5 + "):");
                this.print_tile(n6, n5);
                ++n6;
            }
            ++n5;
        }
    }

    private void printBounds() {
        System.out.println("Bounds: [x=" + this.getMinX() + ", y=" + this.getMinY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "]");
    }

    private void print_tile(int n, int n2) {
        int n3 = n * this.getTileWidth() + this.getTileGridXOffset();
        int n4 = n2 * this.getTileHeight() + this.getTileGridYOffset();
        Rectangle rectangle = this.getBounds();
        Rectangle rectangle2 = new Rectangle(n3, n4, this.getTileWidth(), this.getTileHeight());
        rectangle2 = rectangle2.intersection(rectangle);
        Raster raster = this.getTile(n, n2);
        Rectangle rectangle3 = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
        System.out.println("Tile bounds (actual)   = " + rectangle3);
        System.out.println("Tile bounds (computed) = " + rectangle2);
        n3 = rectangle2.x;
        n4 = rectangle2.y;
        int n5 = rectangle2.x + rectangle2.width - 1;
        int n6 = rectangle2.y + rectangle2.height - 1;
        int n7 = this.getSampleModel().getNumBands();
        int[] nArray = new int[n7];
        int n8 = n4;
        while (n8 <= n6) {
            int n9 = n3;
            while (n9 <= n5) {
                raster.getPixel(n9, n8, nArray);
                if (n7 == 1) {
                    System.out.print("(" + nArray[0] + ") ");
                } else if (n7 == 3) {
                    System.out.print("(" + nArray[0] + "," + nArray[1] + "," + nArray[2] + ") ");
                }
                ++n9;
            }
            System.out.println();
            ++n8;
        }
    }

    protected synchronized boolean removeSink(PlanarImage planarImage) {
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage7"));
        }
        int n = this.sinks.indexOf(planarImage.weakThis);
        if (n == -1) {
            return false;
        }
        int n2 = this.sinks.size() - 1;
        Object e2 = this.sinks.get(n2);
        this.sinks.set(n, e2);
        this.sinks.remove(n2);
        return true;
    }

    protected final synchronized void removeSinks() {
        this.sinks.clear();
    }

    protected synchronized boolean removeSource(PlanarImage planarImage) {
        boolean bl;
        if (planarImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage6"));
        }
        boolean bl2 = this.sources != null;
        PlanarImage planarImage2 = null;
        if (bl2) {
            planarImage2 = (PlanarImage)this.sources.elementAt(0);
        }
        boolean bl3 = bl = planarImage == this.source0;
        if (bl || planarImage == this.source1) {
            if (bl) {
                this.source0 = this.source1;
            }
            this.source1 = planarImage2;
            if (bl2) {
                if (this.sources.size() == 1) {
                    this.sources = null;
                } else {
                    this.sources.removeElementAt(0);
                }
            }
            return true;
        }
        if (bl2) {
            return this.sources.removeElement(planarImage);
        }
        return false;
    }

    protected synchronized void removeSources() {
        this.source1 = null;
        this.source0 = null;
        this.sources = null;
    }

    protected final void setImageParameters(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage3"));
        }
        this.setImageParameters(new ImageLayout(), renderedImage);
    }

    protected final void setImageParameters(ImageLayout imageLayout, RenderedImage renderedImage) {
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        }
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage3"));
        }
        this.minX = imageLayout.getMinX(renderedImage);
        this.minY = imageLayout.getMinY(renderedImage);
        this.width = imageLayout.getWidth(renderedImage);
        this.height = imageLayout.getHeight(renderedImage);
        this.tileWidth = imageLayout.getTileWidth(renderedImage);
        this.tileHeight = imageLayout.getTileHeight(renderedImage);
        this.tileGridXOffset = imageLayout.getTileGridXOffset(renderedImage);
        this.tileGridYOffset = imageLayout.getTileGridYOffset(renderedImage);
        this.sampleModel = imageLayout.getSampleModel(renderedImage).createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        this.colorModel = imageLayout.getColorModel(renderedImage);
    }

    protected synchronized void setProperties(Hashtable hashtable) {
        this.properties = hashtable;
    }

    public void setProperty(String string, Object object) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage9"));
        }
        if (object == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage17"));
        }
        Hashtable hashtable = this.getProperties();
        hashtable.put(string, object);
    }

    void setSource(PlanarImage planarImage, int n) {
        if (n == 0) {
            if (this.source0 == null) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
            }
            this.source0 = planarImage;
        } else if (n == 1) {
            if (this.source1 == null) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("PlanarImage0"));
            }
            this.source1 = planarImage;
        } else {
            this.sources.setElementAt(planarImage, n - 2);
        }
    }

    protected synchronized void setSources(List list) {
        if (list == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage8"));
        }
        this.removeSources();
        if (list == null) {
            return;
        }
        int n = list.size();
        if (n > 0) {
            this.source0 = (PlanarImage)list.get(0);
        }
        if (n > 1) {
            this.source1 = (PlanarImage)list.get(1);
        }
        if (n > 2) {
            this.sources = new Vector();
            int n2 = 2;
            while (n2 < n) {
                this.sources.add(list.get(n2));
                ++n2;
            }
        }
    }

    public final int tileXToX(int n) {
        return PlanarImage.tileXToX(n, this.getTileGridXOffset(), this.getTileWidth());
    }

    public static final int tileXToX(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public final int tileYToY(int n) {
        return PlanarImage.tileYToY(n, this.getTileGridYOffset(), this.getTileHeight());
    }

    public static final int tileYToY(int n, int n2, int n3) {
        return n * n3 + n2;
    }

    public static final PlanarImage wrapRenderedImage(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("PlanarImage3"));
        }
        if (renderedImage instanceof PlanarImage) {
            return (PlanarImage)renderedImage;
        }
        if (renderedImage instanceof WritableRenderedImage) {
            WritableRenderedImage writableRenderedImage = (WritableRenderedImage)renderedImage;
            return new WritableRenderedImageAdapter(writableRenderedImage);
        }
        return new RenderedImageAdapter(renderedImage);
    }
}

