/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.JDKWorkarounds;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.image.BandedSampleModel;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Vector;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import javax.media.jai.RasterFactory;
import javax.media.jai.TiledImageGraphics;

public class TiledImage
extends PlanarImage
implements WritableRenderedImage {
    protected int tilesX;
    protected int tilesY;
    protected int minTileX;
    protected int minTileY;
    protected WritableRaster[][] tiles;
    protected int[][] writers;
    protected Vector tileObservers = null;
    protected PlanarImage src = null;
    private Rectangle imageBounds = null;
    private TiledImage parent = null;
    private SampleModel ancestorSampleModel = null;
    private int[] bandList = null;
    private int[] numWritableTiles = null;
    private ROI srcROI = null;
    private Rectangle overlapBounds = null;

    public TiledImage(int n, int n2, int n3, int n4, int n5, int n6, SampleModel sampleModel, ColorModel colorModel) {
        this(null, n, n2, n3, n4, n5, n6, sampleModel, colorModel);
    }

    public TiledImage(Point point, SampleModel sampleModel, int n, int n2) {
        this(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight(), point.x, point.y, sampleModel.createCompatibleSampleModel(n, n2), PlanarImage.createColorModel(sampleModel));
    }

    public TiledImage(SampleModel sampleModel, int n, int n2) {
        this(0, 0, sampleModel.getWidth(), sampleModel.getHeight(), 0, 0, sampleModel.createCompatibleSampleModel(n, n2), PlanarImage.createColorModel(sampleModel));
    }

    private TiledImage(TiledImage tiledImage, int n, int n2, int n3, int n4, int n5, int n6, SampleModel sampleModel, ColorModel colorModel) {
        this.minX = n;
        this.minY = n2;
        this.width = n3;
        this.height = n4;
        this.imageBounds = new Rectangle(n, n2, n3, n4);
        this.tileWidth = sampleModel.getWidth();
        this.tileHeight = sampleModel.getHeight();
        this.tileGridXOffset = n5;
        this.tileGridYOffset = n6;
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
        this.initTileGrid(tiledImage);
        if (tiledImage == null) {
            this.tiles = new WritableRaster[this.tilesX][this.tilesY];
            this.writers = new int[this.tilesX][this.tilesY];
            this.tileObservers = new Vector();
            this.numWritableTiles = new int[1];
            this.numWritableTiles[0] = 0;
            this.ancestorSampleModel = sampleModel;
        } else {
            this.parent = tiledImage;
            this.tiles = tiledImage.tiles;
            this.writers = tiledImage.writers;
            this.tileObservers = tiledImage.tileObservers;
            this.numWritableTiles = tiledImage.numWritableTiles;
            this.ancestorSampleModel = tiledImage.ancestorSampleModel;
        }
    }

    public final void addTileObserver(TileObserver tileObserver) {
        this.tileObservers.addElement(tileObserver);
    }

    public static final TiledImage createBanded(int n, int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray, int[] nArray2) {
        BandedSampleModel bandedSampleModel = new BandedSampleModel(n5, n6, n7, n6, nArray, nArray2);
        return new TiledImage(n, n2, n3, n4, n, n2, bandedSampleModel, PlanarImage.createColorModel(bandedSampleModel));
    }

    public final Graphics2D createGraphics() {
        int n = this.sampleModel.getTransferType();
        if (n != 0 && n != 2 && n != 1 && n != 3) {
            throw new UnsupportedOperationException(JaiI18N.getString("TiledImage0"));
        }
        return new TiledImageGraphics(this);
    }

    public static final TiledImage createInterleaved(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int[] nArray) {
        SampleModel sampleModel = RasterFactory.createPixelInterleavedSampleModel(n6, n7, n8, n5, n5 * n7, nArray);
        return new TiledImage(n, n2, n3, n4, n, n2, sampleModel, PlanarImage.createColorModel(sampleModel));
    }

    private void createTile(int n, int n2) {
        if (this.src == null && this.parent != null) {
            this.parent.createTile(n, n2);
            return;
        }
        if (this.tiles[n - this.minTileX][n2 - this.minTileY] == null) {
            this.tiles[n - this.minTileX][n2 - this.minTileY] = RasterFactory.createWritableRaster(this.ancestorSampleModel, new Point(this.tileXToX(n), this.tileYToY(n2)));
            WritableRaster writableRaster = this.tiles[n - this.minTileX][n2 - this.minTileY];
            if (this.src != null) {
                Rectangle rectangle = this.getTileRect(n, n2);
                Rectangle rectangle2 = this.overlapBounds.intersection(rectangle);
                if (rectangle2.isEmpty()) {
                    return;
                }
                if (this.srcROI != null) {
                    Shape shape = this.srcROI.getAsShape();
                    if (shape != null) {
                        Area area = new Area(rectangle2);
                        area.intersect(new Area(shape));
                        if (!area.isEmpty()) {
                            this.overlayPixels(writableRaster, (RenderedImage)this.src, area);
                        }
                    } else {
                        int[][] nArray = this.srcROI.getAsBitmask(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, null);
                        this.overlayPixels(writableRaster, this.src, rectangle2, nArray);
                    }
                } else if (!rectangle2.isEmpty()) {
                    if (this.bandList == null && rectangle2.equals(rectangle)) {
                        this.src.copyData(writableRaster);
                    } else {
                        this.overlayPixels(writableRaster, (RenderedImage)this.src, rectangle2);
                    }
                }
            }
        }
    }

    public final Graphics getGraphics() {
        return this.createGraphics();
    }

    public final int getSample(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSample(n, n2, n3);
    }

    public final double getSampleDouble(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSampleDouble(n, n2, n3);
    }

    public final float getSampleFloat(int n, int n2, int n3) {
        int n4 = this.XToTileX(n);
        int n5 = this.YToTileY(n2);
        Raster raster = this.getTile(n4, n5);
        return raster.getSampleFloat(n, n2, n3);
    }

    public final TiledImage getSubImage(int n, int n2, int n3, int n4) {
        return this.getSubImage(n, n2, n3, n4, null);
    }

    public final TiledImage getSubImage(int n, int n2, int n3, int n4, int[] nArray) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        if (rectangle.isEmpty()) {
            return null;
        }
        Rectangle rectangle2 = rectangle.intersection(this.imageBounds);
        if (rectangle2.isEmpty()) {
            return null;
        }
        SampleModel sampleModel = nArray != null ? this.getSampleModel().createSubsetSampleModel(nArray) : this.getSampleModel();
        ColorModel colorModel = null;
        colorModel = nArray != null && nArray.length != this.getSampleModel().getNumBands() ? PlanarImage.createColorModel(sampleModel) : this.getColorModel();
        TiledImage tiledImage = new TiledImage(this, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, this.getTileGridXOffset(), this.getTileGridYOffset(), sampleModel, colorModel);
        int[] nArray2 = null;
        if (nArray != null) {
            if (this.bandList != null) {
                nArray2 = new int[nArray.length];
                int n5 = 0;
                while (n5 < nArray.length) {
                    nArray2[n5] = this.bandList[nArray[n5]];
                    ++n5;
                }
            } else {
                nArray2 = nArray;
            }
        } else {
            nArray2 = this.bandList;
        }
        tiledImage.bandList = nArray2;
        return tiledImage;
    }

    public final TiledImage getSubImage(int[] nArray) {
        return this.getSubImage(this.getMinX(), this.getMinY(), this.getWidth(), this.getHeight(), nArray);
    }

    public final Raster getTile(int n, int n2) {
        this.createTile(n, n2);
        if (this.bandList == null) {
            return this.tiles[n - this.minTileX][n2 - this.minTileY];
        }
        WritableRaster writableRaster = this.tiles[n - this.minTileX][n2 - this.minTileY];
        return writableRaster.createChild(writableRaster.getMinX(), writableRaster.getMinY(), writableRaster.getWidth(), writableRaster.getHeight(), writableRaster.getMinX(), writableRaster.getMinY(), this.bandList);
    }

    public final WritableRaster getWritableTile(int n, int n2) {
        Object object;
        if (this.isTileLocked(n, n2)) {
            return null;
        }
        this.createTile(n, n2);
        int[] nArray = this.writers[n - this.minTileX];
        int n3 = n2 - this.minTileY;
        nArray[n3] = nArray[n3] + 1;
        if (this.writers[n - this.minTileX][n2 - this.minTileY] == 1) {
            this.numWritableTiles[0] = this.numWritableTiles[0] + 1;
            object = this.tileObservers.elements();
            while (object.hasMoreElements()) {
                TileObserver tileObserver = (TileObserver)object.nextElement();
                tileObserver.tileUpdate(this, n, n2, true);
            }
        }
        if (this.bandList == null) {
            return this.tiles[n - this.minTileX][n2 - this.minTileY];
        }
        object = this.tiles[n - this.minTileX][n2 - this.minTileY];
        return ((WritableRaster)object).createWritableChild(((Raster)object).getMinX(), ((Raster)object).getMinY(), ((Raster)object).getWidth(), ((Raster)object).getHeight(), ((Raster)object).getMinX(), ((Raster)object).getMinY(), this.bandList);
    }

    public final Point[] getWritableTileIndices() {
        Vector<Point> vector = new Vector<Point>();
        int n = 0;
        int n2 = 0;
        while (n2 < this.tilesY) {
            int n3 = 0;
            while (n3 < this.tilesX) {
                if (this.writers[n3][n2] > 0) {
                    vector.addElement(new Point(n3 + this.minTileX, n2 + this.minTileY));
                    ++n;
                }
                ++n3;
            }
            ++n2;
        }
        Point[] pointArray = new Point[n];
        int n4 = 0;
        while (n4 < n) {
            pointArray[n4] = (Point)vector.elementAt(n4);
            ++n4;
        }
        return pointArray;
    }

    public final boolean hasTileWriters() {
        return this.numWritableTiles[0] > 0;
    }

    private void initTileGrid(TiledImage tiledImage) {
        if (tiledImage != null) {
            this.minTileX = tiledImage.minTileX;
            this.minTileY = tiledImage.minTileY;
        } else {
            this.minTileX = this.getMinTileX();
            this.minTileY = this.getMinTileY();
        }
        int n = this.getMaxTileX();
        int n2 = this.getMaxTileY();
        this.tilesX = n - this.minTileX + 1;
        this.tilesY = n2 - this.minTileY + 1;
    }

    protected final boolean isTileLocked(int n, int n2) {
        return this.writers[n - this.minTileX][n2 - this.minTileY] < 0;
    }

    public final boolean isTileWritable(int n, int n2) {
        return this.writers[n - this.minTileX][n2 - this.minTileY] > 0;
    }

    protected final boolean lockTile(int n, int n2) {
        if (this.isTileWritable(n, n2)) {
            return false;
        }
        this.createTile(n, n2);
        this.writers[n - this.minTileX][n2 - this.minTileY] = -1;
        return true;
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Rectangle rectangle) {
        WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.bandList);
        JDKWorkarounds.setRect(writableRaster2, renderedImage.getData(rectangle));
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Rectangle rectangle, int[][] nArray) {
        Raster raster = renderedImage.getData(rectangle);
        if (this.bandList != null) {
            writableRaster = writableRaster.createWritableChild(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, this.bandList);
        }
        Object object = raster.getDataElements(rectangle.x, rectangle.y, null);
        int n = rectangle.y;
        int n2 = 0;
        while (n2 < rectangle.height) {
            int[] nArray2 = nArray[n2];
            int n3 = rectangle.x;
            int n4 = (rectangle.width + 31) / 32;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray2[n5];
                int n7 = Integer.MIN_VALUE;
                int n8 = 0;
                while (n8 < 32) {
                    if ((n6 & n7) != 0) {
                        raster.getDataElements(n3, n, object);
                        writableRaster.setDataElements(n3, n, object);
                    }
                    n7 >>>= 1;
                    ++n8;
                    ++n3;
                }
                ++n5;
            }
            ++n2;
            ++n;
        }
    }

    private void overlayPixels(WritableRaster writableRaster, RenderedImage renderedImage, Area area) {
        ROIShape rOIShape = new ROIShape(area);
        Rectangle rectangle = rOIShape.getBounds();
        LinkedList linkedList = rOIShape.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = linkedList.size();
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle2 = (Rectangle)linkedList.get(n2);
            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle2.x, rectangle2.y, this.bandList);
            JDKWorkarounds.setRect(writableRaster2, renderedImage.getData(rectangle2));
            ++n2;
        }
    }

    public final void releaseWritableTile(int n, int n2) {
        if (this.isTileLocked(n, n2)) {
            return;
        }
        int[] nArray = this.writers[n - this.minTileX];
        int n3 = n2 - this.minTileY;
        nArray[n3] = nArray[n3] - 1;
        if (this.writers[n - this.minTileX][n2 - this.minTileY] < 0) {
            throw new RuntimeException(JaiI18N.getString("TiledImage1"));
        }
        if (this.writers[n - this.minTileX][n2 - this.minTileY] == 0) {
            this.numWritableTiles[0] = this.numWritableTiles[0] - 1;
            Enumeration enumeration = this.tileObservers.elements();
            while (enumeration.hasMoreElements()) {
                TileObserver tileObserver = (TileObserver)enumeration.nextElement();
                tileObserver.tileUpdate(this, n, n2, false);
            }
        }
    }

    public final void removeTileObserver(TileObserver tileObserver) {
        this.tileObservers.removeElement(tileObserver);
    }

    public final void set(RenderedImage renderedImage) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        if ((rectangle = rectangle.intersection(this.imageBounds)).isEmpty()) {
            return;
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                WritableRaster writableRaster = this.tiles[n6 - this.minTileX][n5 - this.minTileY];
                if (writableRaster != null && !this.isTileLocked(n6, n5)) {
                    Rectangle rectangle2 = this.getTileRect(n6, n5);
                    if (!(rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) {
                        this.overlayPixels(writableRaster, renderedImage, rectangle2);
                    }
                }
                ++n6;
            }
            ++n5;
        }
        this.src = PlanarImage.wrapRenderedImage(renderedImage);
        this.srcROI = null;
        this.overlapBounds = rectangle;
    }

    public final void set(RenderedImage renderedImage, ROI rOI) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        Rectangle rectangle2 = rectangle.intersection(rOI.getBounds());
        if (rectangle2.isEmpty() || (rectangle2 = rectangle2.intersection(this.imageBounds)).isEmpty()) {
            return;
        }
        int n = this.XToTileX(rectangle2.x);
        int n2 = this.YToTileY(rectangle2.y);
        int n3 = this.XToTileX(rectangle2.x + rectangle2.width - 1);
        int n4 = this.YToTileY(rectangle2.y + rectangle2.height - 1);
        Shape shape = rOI.getAsShape();
        Area area = null;
        if (shape != null) {
            area = new Area(shape);
        }
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                Rectangle rectangle3;
                WritableRaster writableRaster = this.tiles[n6 - this.minTileX][n5 - this.minTileY];
                if (writableRaster != null && !this.isTileLocked(n6, n5) && !(rectangle3 = this.getTileRect(n6, n5).intersection(rectangle2)).isEmpty()) {
                    Object object;
                    if (shape != null) {
                        object = new Area(rectangle3);
                        ((Area)object).intersect(area);
                        if (!((Area)object).isEmpty()) {
                            this.overlayPixels(writableRaster, renderedImage, (Area)object);
                        }
                    } else {
                        object = rOI.getAsBitmask(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, null);
                        if (object != null && ((Object)object).length > 0) {
                            this.overlayPixels(writableRaster, renderedImage, rectangle3, (int[][])object);
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
        this.src = PlanarImage.wrapRenderedImage(renderedImage);
        this.srcROI = rOI;
        this.overlapBounds = rectangle2;
    }

    public final void setData(Raster raster) {
        Rectangle rectangle = raster.getBounds();
        if ((rectangle = rectangle.intersection(this.imageBounds)).isEmpty()) {
            return;
        }
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = n2;
        while (n5 <= n4) {
            int n6 = n;
            while (n6 <= n3) {
                WritableRaster writableRaster = this.getWritableTile(n6, n5);
                if (writableRaster != null) {
                    Rectangle rectangle2 = this.getTileRect(n6, n5);
                    if (rectangle2.contains(rectangle)) {
                        JDKWorkarounds.setRect(writableRaster, raster);
                    } else {
                        Rectangle rectangle3 = rectangle.intersection(rectangle2);
                        Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                        WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                        JDKWorkarounds.setRect(writableRaster2, raster2);
                    }
                    this.releaseWritableTile(n6, n5);
                }
                ++n6;
            }
            ++n5;
        }
    }

    public final void setData(Raster raster, ROI rOI) {
        Rectangle rectangle = raster.getBounds();
        if ((rectangle = rectangle.intersection(this.imageBounds)).isEmpty() || (rectangle = rectangle.intersection(rOI.getBounds())).isEmpty()) {
            return;
        }
        LinkedList linkedList = rOI.getAsRectangleList(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = this.XToTileX(rectangle.x);
        int n2 = this.YToTileY(rectangle.y);
        int n3 = this.XToTileX(rectangle.x + rectangle.width - 1);
        int n4 = this.YToTileY(rectangle.y + rectangle.height - 1);
        int n5 = linkedList.size();
        int n6 = n2;
        while (n6 <= n4) {
            int n7 = n;
            while (n7 <= n3) {
                WritableRaster writableRaster = this.getWritableTile(n7, n6);
                if (writableRaster != null) {
                    Rectangle rectangle2 = this.getTileRect(n7, n6);
                    int n8 = 0;
                    while (n8 < n5) {
                        Rectangle rectangle3 = (Rectangle)linkedList.get(n8);
                        if (!(rectangle3 = rectangle3.intersection(rectangle2)).isEmpty()) {
                            Raster raster2 = raster.createChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            WritableRaster writableRaster2 = writableRaster.createWritableChild(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, rectangle3.x, rectangle3.y, null);
                            JDKWorkarounds.setRect(writableRaster2, raster2);
                        }
                        ++n8;
                    }
                    this.releaseWritableTile(n7, n6);
                }
                ++n7;
            }
            ++n6;
        }
    }

    public final void setSample(int n, int n2, int n3, double d2) {
        int n4;
        int n5 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n5, n4 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, d2);
        }
        this.releaseWritableTile(n5, n4);
    }

    public final void setSample(int n, int n2, int n3, float f2) {
        int n4;
        int n5 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n5, n4 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, f2);
        }
        this.releaseWritableTile(n5, n4);
    }

    public final void setSample(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = this.XToTileX(n);
        WritableRaster writableRaster = this.getWritableTile(n6, n5 = this.YToTileY(n2));
        if (writableRaster != null) {
            writableRaster.setSample(n, n2, n3, n4);
        }
        this.releaseWritableTile(n6, n5);
    }
}

