/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import common.Logger;
import jxl.WorkbookSettings;
import jxl.biff.FontRecord$Biff7;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.ScriptStyle;
import jxl.format.UnderlineStyle;
import jxl.read.biff.Record;

public class FontRecord
extends WritableRecordData
implements Font {
    private static Logger logger = Logger.getLogger(class$jxl$biff$FontRecord == null ? (class$jxl$biff$FontRecord = FontRecord.class$("jxl.biff.FontRecord")) : class$jxl$biff$FontRecord);
    private int pointHeight;
    private int colourIndex;
    private int boldWeight;
    private int scriptStyle;
    private int underlineStyle;
    private byte fontFamily;
    private byte characterSet;
    private boolean italic;
    private boolean struckout;
    private String name;
    private boolean initialized;
    private int fontIndex;
    public static final FontRecord$Biff7 biff7 = new FontRecord$Biff7(null);
    private static final int EXCEL_UNITS_PER_POINT = 20;
    static Class class$jxl$biff$FontRecord;

    protected FontRecord(String string, int n, int n2, boolean bl, int n3, int n4, int n5) {
        super(Type.FONT);
        this.boldWeight = n2;
        this.underlineStyle = n3;
        this.name = string;
        this.pointHeight = n;
        this.italic = bl;
        this.scriptStyle = n5;
        this.colourIndex = n4;
        this.initialized = false;
        this.struckout = false;
    }

    public FontRecord(Record record, WorkbookSettings workbookSettings) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(byArray[0], byArray[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.boldWeight = IntegerHelper.getInt(byArray[6], byArray[7]);
        this.scriptStyle = IntegerHelper.getInt(byArray[8], byArray[9]);
        this.underlineStyle = byArray[10];
        this.fontFamily = byArray[11];
        this.characterSet = byArray[12];
        this.initialized = false;
        if ((byArray[2] & 2) != 0) {
            this.italic = true;
        }
        if ((byArray[2] & 8) != 0) {
            this.struckout = true;
        }
        byte by = byArray[14];
        this.name = byArray[15] == 0 ? StringHelper.getString(byArray, by, 16, workbookSettings) : (byArray[15] == 1 ? StringHelper.getUnicodeString(byArray, by, 16) : StringHelper.getString(byArray, by, 15, workbookSettings));
    }

    public FontRecord(Record record, WorkbookSettings workbookSettings, FontRecord$Biff7 fontRecord$Biff7) {
        super(record);
        byte[] byArray = this.getRecord().getData();
        this.pointHeight = IntegerHelper.getInt(byArray[0], byArray[1]) / 20;
        this.colourIndex = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.boldWeight = IntegerHelper.getInt(byArray[6], byArray[7]);
        this.scriptStyle = IntegerHelper.getInt(byArray[8], byArray[9]);
        this.underlineStyle = byArray[10];
        this.fontFamily = byArray[11];
        this.initialized = false;
        if ((byArray[2] & 2) != 0) {
            this.italic = true;
        }
        if ((byArray[2] & 8) != 0) {
            this.struckout = true;
        }
        byte by = byArray[14];
        this.name = StringHelper.getString(byArray, by, 15, workbookSettings);
    }

    protected FontRecord(Font font) {
        super(Type.FONT);
        Assert.verify(font != null);
        this.pointHeight = font.getPointSize();
        this.colourIndex = font.getColour().getValue();
        this.boldWeight = font.getBoldWeight();
        this.scriptStyle = font.getScriptStyle().getValue();
        this.underlineStyle = font.getUnderlineStyle().getValue();
        this.italic = font.isItalic();
        this.name = font.getName();
        this.struckout = false;
        this.initialized = false;
    }

    public final byte[] getData() {
        byte[] byArray = new byte[16 + this.name.length() * 2];
        IntegerHelper.getTwoBytes(this.pointHeight * 20, byArray, 0);
        if (this.italic) {
            byArray[2] = (byte)(byArray[2] | 2);
        }
        if (this.struckout) {
            byArray[2] = (byte)(byArray[2] | 8);
        }
        IntegerHelper.getTwoBytes(this.colourIndex, byArray, 4);
        IntegerHelper.getTwoBytes(this.boldWeight, byArray, 6);
        IntegerHelper.getTwoBytes(this.scriptStyle, byArray, 8);
        byArray[10] = (byte)this.underlineStyle;
        byArray[11] = this.fontFamily;
        byArray[12] = this.characterSet;
        byArray[13] = 0;
        byArray[14] = (byte)this.name.length();
        byArray[15] = 1;
        StringHelper.getUnicodeBytes(this.name, byArray, 16);
        return byArray;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final void initialize(int n) {
        this.fontIndex = n;
        this.initialized = true;
    }

    public final void uninitialize() {
        this.initialized = false;
    }

    public final int getFontIndex() {
        return this.fontIndex;
    }

    protected final void setFontPointSize(int n) {
        Assert.verify(!this.initialized);
        this.pointHeight = n;
    }

    public int getPointSize() {
        return this.pointHeight;
    }

    protected final void setFontBoldStyle(int n) {
        Assert.verify(!this.initialized);
        this.boldWeight = n;
    }

    public int getBoldWeight() {
        return this.boldWeight;
    }

    protected final void setFontItalic(boolean bl) {
        Assert.verify(!this.initialized);
        this.italic = bl;
    }

    public boolean isItalic() {
        return this.italic;
    }

    protected final void setFontUnderlineStyle(int n) {
        Assert.verify(!this.initialized);
        this.underlineStyle = n;
    }

    public UnderlineStyle getUnderlineStyle() {
        return UnderlineStyle.getStyle(this.underlineStyle);
    }

    protected final void setFontColour(int n) {
        Assert.verify(!this.initialized);
        this.colourIndex = n;
    }

    public Colour getColour() {
        return Colour.getInternalColour(this.colourIndex);
    }

    protected final void setFontScriptStyle(int n) {
        Assert.verify(!this.initialized);
        this.scriptStyle = n;
    }

    public ScriptStyle getScriptStyle() {
        return ScriptStyle.getStyle(this.scriptStyle);
    }

    public String getName() {
        return this.name;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FontRecord)) {
            return false;
        }
        FontRecord fontRecord = (FontRecord)object;
        return this.pointHeight == fontRecord.pointHeight && this.colourIndex == fontRecord.colourIndex && this.boldWeight == fontRecord.boldWeight && this.scriptStyle == fontRecord.scriptStyle && this.underlineStyle == fontRecord.underlineStyle && this.italic == fontRecord.italic && this.struckout == fontRecord.struckout && this.fontFamily == fontRecord.fontFamily && this.characterSet == fontRecord.characterSet && this.name.equals(fontRecord.name);
    }

    public final boolean isStruckout() {
        return this.struckout;
    }

    protected final void setFontStruckout(boolean bl) {
        this.struckout = bl;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

