/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecord;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;

public class DrawingData
implements EscherStream {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$DrawingData == null ? (class$jxl$biff$drawing$DrawingData = DrawingData.class$("jxl.biff.drawing.DrawingData")) : class$jxl$biff$drawing$DrawingData);
    private byte[] drawingData = null;
    private int numDrawings = 0;
    private boolean initialized = false;
    private EscherRecord[] spContainers;
    static Class class$jxl$biff$drawing$DrawingData;

    private void initialize() {
        EscherRecordData escherRecordData = new EscherRecordData(this, 0);
        Assert.verify(escherRecordData.isContainer());
        EscherContainer escherContainer = new EscherContainer(escherRecordData);
        EscherRecord[] escherRecordArray = escherContainer.getChildren();
        escherRecordArray = escherContainer.getChildren();
        EscherContainer escherContainer2 = null;
        for (int i2 = 0; i2 < escherRecordArray.length && escherContainer2 == null; ++i2) {
            EscherRecord escherRecord = escherRecordArray[i2];
            if (escherRecord.getType() != EscherRecordType.SPGR_CONTAINER) continue;
            escherContainer2 = (EscherContainer)escherRecord;
        }
        Assert.verify(escherContainer2 != null);
        EscherRecord[] escherRecordArray2 = escherContainer2.getChildren();
        boolean bl = false;
        for (int i3 = 0; i3 < escherRecordArray2.length && !bl; ++i3) {
            if (escherRecordArray2[i3].getType() != EscherRecordType.SPGR_CONTAINER) continue;
            bl = true;
        }
        if (!bl) {
            this.spContainers = escherRecordArray2;
        } else {
            ArrayList arrayList = new ArrayList();
            this.getSpContainers(escherContainer2, arrayList);
            this.spContainers = new EscherRecord[arrayList.size()];
            this.spContainers = arrayList.toArray(this.spContainers);
        }
        this.initialized = true;
    }

    private void getSpContainers(EscherContainer escherContainer, ArrayList arrayList) {
        EscherRecord[] escherRecordArray = escherContainer.getChildren();
        for (int i2 = 0; i2 < escherRecordArray.length; ++i2) {
            if (escherRecordArray[i2].getType() == EscherRecordType.SP_CONTAINER) {
                arrayList.add(escherRecordArray[i2]);
                continue;
            }
            if (escherRecordArray[i2].getType() == EscherRecordType.SPGR_CONTAINER) {
                this.getSpContainers((EscherContainer)escherRecordArray[i2], arrayList);
                continue;
            }
            logger.warn("Spgr Containers contains a record other than Sp/Spgr containers");
        }
    }

    public final void addData(byte[] byArray) {
        this.addRawData(byArray);
        ++this.numDrawings;
    }

    public final void addRawData(byte[] byArray) {
        if (this.drawingData == null) {
            this.drawingData = byArray;
            return;
        }
        byte[] byArray2 = new byte[this.drawingData.length + byArray.length];
        System.arraycopy(this.drawingData, 0, byArray2, 0, this.drawingData.length);
        System.arraycopy(byArray, 0, byArray2, this.drawingData.length, byArray.length);
        this.drawingData = byArray2;
        this.initialized = false;
    }

    final int getNumDrawings() {
        return this.numDrawings;
    }

    final EscherContainer getSpContainer(int n) {
        EscherContainer escherContainer;
        if (!this.initialized) {
            this.initialize();
        }
        Assert.verify((escherContainer = (EscherContainer)this.spContainers[n + 1]) != null);
        return escherContainer;
    }

    public final byte[] getData() {
        return this.drawingData;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

