/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.biff.drawing.ObjRecord$ObjType;
import jxl.read.biff.Record;

public class ObjRecord
extends WritableRecordData {
    private static final Logger logger = Logger.getLogger(class$jxl$biff$drawing$ObjRecord == null ? (class$jxl$biff$drawing$ObjRecord = ObjRecord.class$("jxl.biff.drawing.ObjRecord")) : class$jxl$biff$drawing$ObjRecord);
    private ObjRecord$ObjType type;
    private boolean read;
    private int objectId;
    public static final ObjRecord$ObjType TBD2 = new ObjRecord$ObjType(1, "TBD2");
    public static final ObjRecord$ObjType TBD = new ObjRecord$ObjType(2, "TBD");
    public static final ObjRecord$ObjType CHART = new ObjRecord$ObjType(5, "Chart");
    public static final ObjRecord$ObjType TEXT = new ObjRecord$ObjType(6, "Text");
    public static final ObjRecord$ObjType BUTTON = new ObjRecord$ObjType(7, "Button");
    public static final ObjRecord$ObjType PICTURE = new ObjRecord$ObjType(8, "Picture");
    public static final ObjRecord$ObjType CHECKBOX = new ObjRecord$ObjType(14, "Checkbox");
    public static final ObjRecord$ObjType OPTION = new ObjRecord$ObjType(12, "Option");
    public static final ObjRecord$ObjType EDITBOX = new ObjRecord$ObjType(13, "Edit Box");
    public static final ObjRecord$ObjType LABEL = new ObjRecord$ObjType(14, "Label");
    public static final ObjRecord$ObjType DIALOGUEBOX = new ObjRecord$ObjType(15, "Dialogue Box");
    public static final ObjRecord$ObjType LISTBOX = new ObjRecord$ObjType(18, "List Box");
    public static final ObjRecord$ObjType GROUPBOX = new ObjRecord$ObjType(19, "Group Box");
    public static final ObjRecord$ObjType COMBOBOX = new ObjRecord$ObjType(20, "Combo Box");
    public static final ObjRecord$ObjType MSOFFICEDRAWING = new ObjRecord$ObjType(30, "MS Office Drawing");
    public static final ObjRecord$ObjType FORMCONTROL = new ObjRecord$ObjType(20, "Form Combo Box");
    public static final ObjRecord$ObjType EXCELNOTE = new ObjRecord$ObjType(25, "Excel Note");
    public static final ObjRecord$ObjType UNKNOWN = new ObjRecord$ObjType(255, "Unknown");
    private static final int COMMON_DATA_LENGTH = 22;
    private static final int CLIPBOARD_FORMAT_LENGTH = 6;
    private static final int PICTURE_OPTION_LENGTH = 6;
    private static final int NOTE_STRUCTURE_LENGTH = 26;
    private static final int END_LENGTH = 4;
    static Class class$jxl$biff$drawing$ObjRecord;

    public ObjRecord(Record record) {
        super(record);
        byte[] byArray = record.getData();
        int n = IntegerHelper.getInt(byArray[4], byArray[5]);
        this.read = true;
        this.type = ObjRecord$ObjType.getType(n);
        if (this.type == UNKNOWN) {
            logger.warn("unknown object type code " + n);
        }
        this.objectId = IntegerHelper.getInt(byArray[6], byArray[7]);
    }

    ObjRecord(int n, ObjRecord$ObjType objRecord$ObjType) {
        super(Type.OBJ);
        this.objectId = n;
        this.type = objRecord$ObjType;
    }

    public final byte[] getData() {
        if (this.read) {
            return this.getRecord().getData();
        }
        if (this.type == PICTURE || this.type == CHART) {
            return this.getPictureData();
        }
        if (this.type == EXCELNOTE) {
            return this.getNoteData();
        }
        Assert.verify(false);
        return null;
    }

    private byte[] getPictureData() {
        int n = 38;
        int n2 = 0;
        byte[] byArray = new byte[n];
        IntegerHelper.getTwoBytes(21, byArray, n2);
        IntegerHelper.getTwoBytes(18, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(this.type.value, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(this.objectId, byArray, n2 + 6);
        IntegerHelper.getTwoBytes(24593, byArray, n2 + 8);
        IntegerHelper.getTwoBytes(7, byArray, n2 += 22);
        IntegerHelper.getTwoBytes(2, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(65535, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(8, byArray, n2 += 6);
        IntegerHelper.getTwoBytes(2, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(1, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(0, byArray, n2 += 6);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 2);
        n2 += 4;
        return byArray;
    }

    private byte[] getNoteData() {
        int n = 52;
        int n2 = 0;
        byte[] byArray = new byte[n];
        IntegerHelper.getTwoBytes(21, byArray, n2);
        IntegerHelper.getTwoBytes(18, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(this.type.value, byArray, n2 + 4);
        IntegerHelper.getTwoBytes(this.objectId, byArray, n2 + 6);
        IntegerHelper.getTwoBytes(16401, byArray, n2 + 8);
        IntegerHelper.getTwoBytes(13, byArray, n2 += 22);
        IntegerHelper.getTwoBytes(22, byArray, n2 + 2);
        IntegerHelper.getTwoBytes(0, byArray, n2 += 26);
        IntegerHelper.getTwoBytes(0, byArray, n2 + 2);
        n2 += 4;
        return byArray;
    }

    public final Record getRecord() {
        return super.getRecord();
    }

    public final ObjRecord$ObjType getType() {
        return this.type;
    }

    final int getObjectId() {
        return this.objectId;
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

