/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import common.Logger;
import java.util.Stack;
import jxl.Cell;
import jxl.WorkbookSettings;
import jxl.biff.WorkbookMethods;
import jxl.biff.formula.Add;
import jxl.biff.formula.Area;
import jxl.biff.formula.Area3d;
import jxl.biff.formula.Attribute;
import jxl.biff.formula.BinaryOperator;
import jxl.biff.formula.BooleanValue;
import jxl.biff.formula.BuiltInFunction;
import jxl.biff.formula.CellReference;
import jxl.biff.formula.CellReference3d;
import jxl.biff.formula.Concatenate;
import jxl.biff.formula.Divide;
import jxl.biff.formula.DoubleValue;
import jxl.biff.formula.Equal;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.Function;
import jxl.biff.formula.GreaterEqual;
import jxl.biff.formula.GreaterThan;
import jxl.biff.formula.IntegerValue;
import jxl.biff.formula.LessEqual;
import jxl.biff.formula.LessThan;
import jxl.biff.formula.MemFunc;
import jxl.biff.formula.MissingArg;
import jxl.biff.formula.Multiply;
import jxl.biff.formula.Name;
import jxl.biff.formula.NameRange;
import jxl.biff.formula.NotEqual;
import jxl.biff.formula.Operator;
import jxl.biff.formula.Parenthesis;
import jxl.biff.formula.ParseItem;
import jxl.biff.formula.Parser;
import jxl.biff.formula.Percent;
import jxl.biff.formula.Power;
import jxl.biff.formula.SharedFormulaArea;
import jxl.biff.formula.SharedFormulaCellReference;
import jxl.biff.formula.StringValue;
import jxl.biff.formula.Subtract;
import jxl.biff.formula.Token;
import jxl.biff.formula.UnaryMinus;
import jxl.biff.formula.UnaryOperator;
import jxl.biff.formula.UnaryPlus;
import jxl.biff.formula.VariableArgFunction;

class TokenFormulaParser
implements Parser {
    private static Logger logger = Logger.getLogger(class$jxl$biff$formula$TokenFormulaParser == null ? (class$jxl$biff$formula$TokenFormulaParser = TokenFormulaParser.class$("jxl.biff.formula.TokenFormulaParser")) : class$jxl$biff$formula$TokenFormulaParser);
    private byte[] tokenData;
    private Cell relativeTo;
    private int pos;
    private ParseItem root;
    private Stack tokenStack;
    private ExternalSheet workbook;
    private WorkbookMethods nameTable;
    private WorkbookSettings settings;
    static Class class$jxl$biff$formula$TokenFormulaParser;

    public TokenFormulaParser(byte[] byArray, Cell cell, ExternalSheet externalSheet, WorkbookMethods workbookMethods, WorkbookSettings workbookSettings) {
        this.tokenData = byArray;
        this.pos = 0;
        this.relativeTo = cell;
        this.workbook = externalSheet;
        this.nameTable = workbookMethods;
        this.tokenStack = new Stack();
        this.settings = workbookSettings;
    }

    public final void parse() {
        this.parseSubExpression(this.tokenData.length);
        this.root = (ParseItem)this.tokenStack.pop();
        Assert.verify(this.tokenStack.empty());
    }

    private void parseSubExpression(int n) {
        byte by = 0;
        Token token = null;
        Stack<ParseItem> stack = new Stack<ParseItem>();
        int n2 = this.pos + n;
        while (this.pos < n2) {
            Object object;
            ParseItem parseItem;
            by = this.tokenData[this.pos];
            ++this.pos;
            token = Token.getToken(by);
            if (token == Token.UNKNOWN) {
                throw new FormulaException(FormulaException.unrecognizedToken, by);
            }
            Assert.verify(token != Token.UNKNOWN);
            if (token == Token.REF) {
                parseItem = new CellReference(this.relativeTo);
                this.pos += ((CellReference)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.REFV) {
                parseItem = new SharedFormulaCellReference(this.relativeTo);
                this.pos += ((SharedFormulaCellReference)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.REF3D) {
                parseItem = new CellReference3d(this.relativeTo, this.workbook);
                this.pos += ((CellReference3d)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.AREA) {
                parseItem = new Area();
                this.pos += ((Area)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.AREAV) {
                parseItem = new SharedFormulaArea(this.relativeTo);
                this.pos += ((SharedFormulaArea)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.AREA3D) {
                parseItem = new Area3d(this.workbook);
                this.pos += ((Area3d)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.NAME) {
                parseItem = new Name();
                this.pos += ((Name)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.NAMED_RANGE) {
                parseItem = new NameRange(this.nameTable);
                this.pos += ((NameRange)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.INTEGER) {
                parseItem = new IntegerValue();
                this.pos += ((IntegerValue)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.DOUBLE) {
                parseItem = new DoubleValue();
                this.pos += ((DoubleValue)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.BOOL) {
                parseItem = new BooleanValue();
                this.pos += ((BooleanValue)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.STRING) {
                parseItem = new StringValue(this.settings);
                this.pos += ((StringValue)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.MISSING_ARG) {
                parseItem = new MissingArg();
                this.pos += ((MissingArg)parseItem).read(this.tokenData, this.pos);
                this.tokenStack.push(parseItem);
                continue;
            }
            if (token == Token.UNARY_PLUS) {
                parseItem = new UnaryPlus();
                this.pos += ((UnaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.UNARY_MINUS) {
                parseItem = new UnaryMinus();
                this.pos += ((UnaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.PERCENT) {
                parseItem = new Percent();
                this.pos += ((UnaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.SUBTRACT) {
                parseItem = new Subtract();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.ADD) {
                parseItem = new Add();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.MULTIPLY) {
                parseItem = new Multiply();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.DIVIDE) {
                parseItem = new Divide();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.CONCAT) {
                parseItem = new Concatenate();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.POWER) {
                parseItem = new Power();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.LESS_THAN) {
                parseItem = new LessThan();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.LESS_EQUAL) {
                parseItem = new LessEqual();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.GREATER_THAN) {
                parseItem = new GreaterThan();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.GREATER_EQUAL) {
                parseItem = new GreaterEqual();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.NOT_EQUAL) {
                parseItem = new NotEqual();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.EQUAL) {
                parseItem = new Equal();
                this.pos += ((BinaryOperator)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.PARENTHESIS) {
                parseItem = new Parenthesis();
                this.pos += ((Parenthesis)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.ATTRIBUTE) {
                parseItem = new Attribute(this.settings);
                this.pos += ((Attribute)parseItem).read(this.tokenData, this.pos);
                if (((Attribute)parseItem).isSum()) {
                    this.addOperator((Operator)parseItem);
                    continue;
                }
                if (!((Attribute)parseItem).isIf()) continue;
                stack.push(parseItem);
                continue;
            }
            if (token == Token.FUNCTION) {
                parseItem = new BuiltInFunction(this.settings);
                this.pos += ((BuiltInFunction)parseItem).read(this.tokenData, this.pos);
                this.addOperator((Operator)parseItem);
                continue;
            }
            if (token == Token.FUNCTIONVARARG) {
                parseItem = new VariableArgFunction(this.settings);
                this.pos += ((VariableArgFunction)parseItem).read(this.tokenData, this.pos);
                if (((VariableArgFunction)parseItem).getFunction() != Function.ATTRIBUTE) {
                    this.addOperator((Operator)parseItem);
                    continue;
                }
                ((VariableArgFunction)parseItem).getOperands(this.tokenStack);
                object = null;
                object = stack.empty() ? new Attribute(this.settings) : (Attribute)stack.pop();
                ((Attribute)object).setIfConditions((VariableArgFunction)parseItem);
                this.tokenStack.push(object);
                continue;
            }
            if (token != Token.MEM_FUNC) continue;
            parseItem = new MemFunc();
            this.pos += ((MemFunc)parseItem).read(this.tokenData, this.pos);
            object = this.tokenStack;
            this.tokenStack = new Stack();
            this.parseSubExpression(((MemFunc)parseItem).getLength());
            ParseItem[] parseItemArray = new ParseItem[this.tokenStack.size()];
            int n3 = 0;
            while (!this.tokenStack.isEmpty()) {
                parseItemArray[n3] = (ParseItem)this.tokenStack.pop();
                ++n3;
            }
            ((MemFunc)parseItem).setSubExpression(parseItemArray);
            this.tokenStack = object;
            this.tokenStack.push(parseItem);
        }
    }

    private void addOperator(Operator operator) {
        operator.getOperands(this.tokenStack);
        this.tokenStack.push(operator);
    }

    public final String getFormula() {
        StringBuffer stringBuffer = new StringBuffer();
        this.root.getString(stringBuffer);
        return stringBuffer.toString();
    }

    public final void adjustRelativeCellReferences(int n, int n2) {
        this.root.adjustRelativeCellReferences(n, n2);
    }

    public final byte[] getBytes() {
        return this.root.getBytes();
    }

    public final void columnInserted(int n, int n2, boolean bl) {
        this.root.columnInserted(n, n2, bl);
    }

    public final void columnRemoved(int n, int n2, boolean bl) {
        this.root.columnRemoved(n, n2, bl);
    }

    public final void rowInserted(int n, int n2, boolean bl) {
        this.root.rowInserted(n, n2, bl);
    }

    public final void rowRemoved(int n, int n2, boolean bl) {
        this.root.rowRemoved(n, n2, bl);
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

