/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.BaseCompoundFile;
import jxl.biff.BaseCompoundFile$PropertyStorage;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;

public final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(class$jxl$read$biff$CompoundFile == null ? (class$jxl$read$biff$CompoundFile = CompoundFile.class$("jxl.read.biff.CompoundFile")) : class$jxl$read$biff$CompoundFile);
    private byte[] data;
    private int numBigBlockDepotBlocks;
    private int sbdStartBlock;
    private int rootStartBlock;
    private int extensionBlock;
    private int numExtensionBlocks;
    private byte[] rootEntry;
    private int[] bigBlockChain;
    private int[] smallBlockChain;
    private int[] bigBlockDepotBlocks;
    private ArrayList propertySets;
    private WorkbookSettings settings;
    private BaseCompoundFile$PropertyStorage rootEntryPropertyStorage;
    static Class class$jxl$read$biff$CompoundFile;

    public CompoundFile(byte[] byArray, WorkbookSettings workbookSettings) {
        int n;
        int n2;
        this.data = byArray;
        this.settings = workbookSettings;
        for (n2 = 0; n2 < IDENTIFIER.length; ++n2) {
            if (this.data[n2] == IDENTIFIER[n2]) continue;
            throw new BiffException(BiffException.unrecognizedOLEFile);
        }
        this.propertySets = new ArrayList();
        this.numBigBlockDepotBlocks = IntegerHelper.getInt(this.data[44], this.data[45], this.data[46], this.data[47]);
        this.sbdStartBlock = IntegerHelper.getInt(this.data[60], this.data[61], this.data[62], this.data[63]);
        this.rootStartBlock = IntegerHelper.getInt(this.data[48], this.data[49], this.data[50], this.data[51]);
        this.extensionBlock = IntegerHelper.getInt(this.data[68], this.data[69], this.data[70], this.data[71]);
        this.numExtensionBlocks = IntegerHelper.getInt(this.data[72], this.data[73], this.data[74], this.data[75]);
        this.bigBlockDepotBlocks = new int[this.numBigBlockDepotBlocks];
        n2 = 76;
        int n3 = this.numBigBlockDepotBlocks;
        if (this.numExtensionBlocks != 0) {
            n3 = 109;
        }
        for (n = 0; n < n3; ++n) {
            this.bigBlockDepotBlocks[n] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
            n2 += 4;
        }
        for (n = 0; n < this.numExtensionBlocks; ++n) {
            n2 = (this.extensionBlock + 1) * 512;
            int n4 = Math.min(this.numBigBlockDepotBlocks - n3, 127);
            for (int i2 = n3; i2 < n3 + n4; ++i2) {
                this.bigBlockDepotBlocks[i2] = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
                n2 += 4;
            }
            if ((n3 += n4) >= this.numBigBlockDepotBlocks) continue;
            this.extensionBlock = IntegerHelper.getInt(byArray[n2], byArray[n2 + 1], byArray[n2 + 2], byArray[n2 + 3]);
        }
        this.readBigBlockDepot();
        this.readSmallBlockDepot();
        this.rootEntry = this.readData(this.rootStartBlock);
        this.readPropertySets();
    }

    private void readBigBlockDepot() {
        int n = 0;
        int n2 = 0;
        this.bigBlockChain = new int[this.numBigBlockDepotBlocks * 512 / 4];
        for (int i2 = 0; i2 < this.numBigBlockDepotBlocks; ++i2) {
            n = (this.bigBlockDepotBlocks[i2] + 1) * 512;
            for (int i3 = 0; i3 < 128; ++i3) {
                this.bigBlockChain[n2] = IntegerHelper.getInt(this.data[n], this.data[n + 1], this.data[n + 2], this.data[n + 3]);
                n += 4;
                ++n2;
            }
        }
    }

    private void readSmallBlockDepot() {
        int n = 0;
        int n2 = 0;
        int n3 = this.sbdStartBlock;
        this.smallBlockChain = new int[0];
        while (n3 != -2) {
            int[] nArray = this.smallBlockChain;
            this.smallBlockChain = new int[this.smallBlockChain.length + 128];
            System.arraycopy(nArray, 0, this.smallBlockChain, 0, nArray.length);
            n = (n3 + 1) * 512;
            for (int i2 = 0; i2 < 128; ++i2) {
                this.smallBlockChain[n2] = IntegerHelper.getInt(this.data[n], this.data[n + 1], this.data[n + 2], this.data[n + 3]);
                n += 4;
                ++n2;
            }
            n3 = this.bigBlockChain[n3];
        }
    }

    private void readPropertySets() {
        byte[] byArray = null;
        for (int i2 = 0; i2 < this.rootEntry.length; i2 += 128) {
            byArray = new byte[128];
            System.arraycopy(this.rootEntry, i2, byArray, 0, byArray.length);
            BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, byArray);
            if (baseCompoundFile$PropertyStorage.name == null || baseCompoundFile$PropertyStorage.name.length() == 0) {
                if (baseCompoundFile$PropertyStorage.type == 5) {
                    baseCompoundFile$PropertyStorage.name = "Root Entry";
                    logger.warn("Property storage name for " + baseCompoundFile$PropertyStorage.type + " is empty - setting to " + "Root Entry");
                } else if (baseCompoundFile$PropertyStorage.size != 0) {
                    logger.warn("Property storage type " + baseCompoundFile$PropertyStorage.type + " is non-empty and has no associated name");
                }
            }
            this.propertySets.add(baseCompoundFile$PropertyStorage);
            if (!baseCompoundFile$PropertyStorage.name.equalsIgnoreCase("Root Entry")) continue;
            this.rootEntryPropertyStorage = baseCompoundFile$PropertyStorage;
        }
        if (this.rootEntryPropertyStorage == null) {
            this.rootEntryPropertyStorage = (BaseCompoundFile$PropertyStorage)this.propertySets.get(0);
        }
    }

    public final byte[] getStream(String string) {
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage = this.findPropertyStorage(string, this.rootEntryPropertyStorage);
        if (baseCompoundFile$PropertyStorage == null) {
            baseCompoundFile$PropertyStorage = this.getPropertyStorage(string);
        }
        if (baseCompoundFile$PropertyStorage.size >= 4096 || string.equalsIgnoreCase("Root Entry")) {
            return this.getBigBlockStream(baseCompoundFile$PropertyStorage);
        }
        return this.getSmallBlockStream(baseCompoundFile$PropertyStorage);
    }

    public final byte[] getStream(int n) {
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage = this.getPropertyStorage(n);
        if (baseCompoundFile$PropertyStorage.size >= 4096 || baseCompoundFile$PropertyStorage.name.equalsIgnoreCase("Root Entry")) {
            return this.getBigBlockStream(baseCompoundFile$PropertyStorage);
        }
        return this.getSmallBlockStream(baseCompoundFile$PropertyStorage);
    }

    public final BaseCompoundFile$PropertyStorage findPropertyStorage(String string) {
        return this.findPropertyStorage(string, this.rootEntryPropertyStorage);
    }

    private BaseCompoundFile$PropertyStorage findPropertyStorage(String string, BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage) {
        if (baseCompoundFile$PropertyStorage.child == -1) {
            return null;
        }
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage2 = this.getPropertyStorage(baseCompoundFile$PropertyStorage.child);
        if (baseCompoundFile$PropertyStorage2.name.equalsIgnoreCase(string)) {
            return baseCompoundFile$PropertyStorage2;
        }
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage3 = baseCompoundFile$PropertyStorage2;
        while (baseCompoundFile$PropertyStorage3.previous != -1) {
            baseCompoundFile$PropertyStorage3 = this.getPropertyStorage(baseCompoundFile$PropertyStorage3.previous);
            if (!baseCompoundFile$PropertyStorage3.name.equalsIgnoreCase(string)) continue;
            return baseCompoundFile$PropertyStorage3;
        }
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage4 = baseCompoundFile$PropertyStorage2;
        while (baseCompoundFile$PropertyStorage4.next != -1) {
            baseCompoundFile$PropertyStorage4 = this.getPropertyStorage(baseCompoundFile$PropertyStorage4.next);
            if (!baseCompoundFile$PropertyStorage4.name.equalsIgnoreCase(string)) continue;
            return baseCompoundFile$PropertyStorage4;
        }
        return this.findPropertyStorage(string, baseCompoundFile$PropertyStorage2);
    }

    private BaseCompoundFile$PropertyStorage getPropertyStorage(String string) {
        Iterator iterator = this.propertySets.iterator();
        boolean bl = false;
        boolean bl2 = false;
        BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage = null;
        while (iterator.hasNext()) {
            baseCompoundFile$PropertyStorage = (BaseCompoundFile$PropertyStorage)iterator.next();
            if (!baseCompoundFile$PropertyStorage.name.equalsIgnoreCase(string)) continue;
            bl2 = bl;
            bl = true;
        }
        if (bl2) {
            logger.warn("found multiple copies of property set " + string);
        }
        if (!bl) {
            throw new BiffException(BiffException.streamNotFound);
        }
        return baseCompoundFile$PropertyStorage;
    }

    private BaseCompoundFile$PropertyStorage getPropertyStorage(int n) {
        return (BaseCompoundFile$PropertyStorage)this.propertySets.get(n);
    }

    private byte[] getBigBlockStream(BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage) {
        int n;
        int n2 = baseCompoundFile$PropertyStorage.size / 512;
        if (baseCompoundFile$PropertyStorage.size % 512 != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2 * 512];
        int n3 = baseCompoundFile$PropertyStorage.startBlock;
        int n4 = 0;
        for (n = 0; n3 != -2 && n < n2; ++n) {
            n4 = (n3 + 1) * 512;
            System.arraycopy(this.data, n4, byArray, n * 512, 512);
            n3 = this.bigBlockChain[n3];
        }
        if (n3 != -2 && n == n2) {
            logger.warn("Property storage size inconsistent with block chain.");
        }
        return byArray;
    }

    private byte[] getSmallBlockStream(BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage) {
        byte[] byArray = this.readData(this.rootEntryPropertyStorage.startBlock);
        byte[] byArray2 = new byte[]{};
        int n = baseCompoundFile$PropertyStorage.startBlock;
        int n2 = 0;
        while (n != -2) {
            byte[] byArray3 = byArray2;
            byArray2 = new byte[byArray3.length + 64];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray3.length);
            n2 = n * 64;
            System.arraycopy(byArray, n2, byArray2, byArray3.length, 64);
            if ((n = this.smallBlockChain[n]) != -1) continue;
            logger.warn("Incorrect terminator for small block stream " + baseCompoundFile$PropertyStorage.name);
            n = -2;
        }
        return byArray2;
    }

    private byte[] readData(int n) {
        int n2 = n;
        int n3 = 0;
        byte[] byArray = new byte[]{};
        while (n2 != -2) {
            byte[] byArray2 = byArray;
            byArray = new byte[byArray2.length + 512];
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
            n3 = (n2 + 1) * 512;
            System.arraycopy(this.data, n3, byArray, byArray2.length, 512);
            if (this.bigBlockChain[n2] == n2) {
                throw new BiffException(BiffException.corruptFileFormat);
            }
            n2 = this.bigBlockChain[n2];
        }
        return byArray;
    }

    public final int getNumberOfPropertySets() {
        return this.propertySets.size();
    }

    public final BaseCompoundFile$PropertyStorage getPropertySet(int n) {
        return this.getPropertyStorage(n);
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

