/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import jxl.biff.BaseCompoundFile;
import jxl.biff.BaseCompoundFile$PropertyStorage;
import jxl.biff.IntegerHelper;
import jxl.read.biff.BiffException;
import jxl.write.biff.CompoundFile$ReadPropertyStorage;
import jxl.write.biff.CopyAdditionalPropertySetsException;

final class CompoundFile
extends BaseCompoundFile {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$CompoundFile == null ? (class$jxl$write$biff$CompoundFile = CompoundFile.class$("jxl.write.biff.CompoundFile")) : class$jxl$write$biff$CompoundFile);
    private OutputStream out;
    private byte[] excelData;
    private int size;
    private int requiredSize;
    private int numBigBlockDepotBlocks;
    private int numSmallBlockDepotChainBlocks;
    private int numSmallBlockDepotBlocks;
    private int numExtensionBlocks;
    private int extensionBlock;
    private int excelDataBlocks;
    private int rootStartBlock;
    private int excelDataStartBlock;
    private int bbdStartBlock;
    private int sbdStartBlockChain;
    private int sbdStartBlock;
    private int additionalPropertyBlocks;
    private int numSmallBlocks;
    private int numPropertySets;
    private int numRootEntryBlocks;
    private ArrayList additionalPropertySets;
    private HashMap standardPropertySets;
    private int bbdPos;
    private byte[] bigBlockDepot;
    static Class class$jxl$write$biff$CompoundFile;

    public CompoundFile(byte[] byArray, int n, OutputStream outputStream, jxl.read.biff.CompoundFile compoundFile) {
        this.size = n;
        this.excelData = byArray;
        this.readAdditionalPropertySets(compoundFile);
        this.numRootEntryBlocks = 1;
        this.numPropertySets = 4 + (this.additionalPropertySets != null ? this.additionalPropertySets.size() : 0);
        if (this.additionalPropertySets != null) {
            this.numSmallBlockDepotChainBlocks = this.getBigBlocksRequired(this.numSmallBlocks * 4);
            this.numSmallBlockDepotBlocks = this.getBigBlocksRequired(this.numSmallBlocks * 64);
            this.numRootEntryBlocks += this.getBigBlocksRequired(this.additionalPropertySets.size() * 128);
        }
        int n2 = this.getBigBlocksRequired(n);
        this.requiredSize = n < 4096 ? 4096 : n2 * 512;
        this.out = outputStream;
        this.excelDataBlocks = this.requiredSize / 512;
        this.numBigBlockDepotBlocks = 1;
        int n3 = 109;
        int n4 = this.excelDataBlocks + 8 + 8 + this.additionalPropertyBlocks + this.numSmallBlockDepotBlocks + this.numSmallBlockDepotChainBlocks + this.numRootEntryBlocks;
        int n5 = n4 + this.numBigBlockDepotBlocks;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
        n5 = n4 + this.numBigBlockDepotBlocks;
        this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
        n5 = n4 + this.numBigBlockDepotBlocks;
        if (this.numBigBlockDepotBlocks > n3 - 1) {
            this.extensionBlock = 0;
            int n6 = this.numBigBlockDepotBlocks - n3 + 1;
            this.numExtensionBlocks = (int)Math.ceil((double)n6 / 127.0);
            n5 = n4 + this.numExtensionBlocks + this.numBigBlockDepotBlocks;
            this.numBigBlockDepotBlocks = (int)Math.ceil((double)n5 / 128.0);
            n5 = n4 + this.numExtensionBlocks + this.numBigBlockDepotBlocks;
        } else {
            this.extensionBlock = -2;
            this.numExtensionBlocks = 0;
        }
        this.excelDataStartBlock = this.numExtensionBlocks;
        this.sbdStartBlock = -2;
        if (this.additionalPropertySets != null && this.numSmallBlockDepotBlocks != 0) {
            this.sbdStartBlock = this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks + 16;
        }
        this.sbdStartBlockChain = -2;
        if (this.sbdStartBlock != -2) {
            this.sbdStartBlockChain = this.sbdStartBlock + this.numSmallBlockDepotBlocks;
        }
        this.bbdStartBlock = this.sbdStartBlockChain != -2 ? this.sbdStartBlockChain + this.numSmallBlockDepotChainBlocks : this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks + 16;
        this.rootStartBlock = this.bbdStartBlock + this.numBigBlockDepotBlocks;
        if (n5 != this.rootStartBlock + this.numRootEntryBlocks) {
            logger.warn("Root start block and total blocks are inconsistent  generated file may be corrupt");
            logger.warn("RootStartBlock " + this.rootStartBlock + " totalBlocks " + n5);
        }
    }

    private void readAdditionalPropertySets(jxl.read.biff.CompoundFile compoundFile) {
        if (compoundFile == null) {
            return;
        }
        this.additionalPropertySets = new ArrayList();
        this.standardPropertySets = new HashMap();
        int n = 0;
        int n2 = compoundFile.getNumberOfPropertySets();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            BaseCompoundFile$PropertyStorage baseCompoundFile$PropertyStorage = compoundFile.getPropertySet(i2);
            boolean bl = false;
            if (baseCompoundFile$PropertyStorage.name.equalsIgnoreCase("Root Entry")) {
                bl = true;
                CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = new CompoundFile$ReadPropertyStorage(baseCompoundFile$PropertyStorage, null, i2);
                this.standardPropertySets.put("Root Entry", compoundFile$ReadPropertyStorage);
            }
            for (int i3 = 0; i3 < STANDARD_PROPERTY_SETS.length && !bl; ++i3) {
                if (!baseCompoundFile$PropertyStorage.name.equalsIgnoreCase(STANDARD_PROPERTY_SETS[i3])) continue;
                object = compoundFile.findPropertyStorage(baseCompoundFile$PropertyStorage.name);
                Assert.verify(object != null);
                if (object != baseCompoundFile$PropertyStorage) continue;
                bl = true;
                CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = new CompoundFile$ReadPropertyStorage(baseCompoundFile$PropertyStorage, null, i2);
                this.standardPropertySets.put(STANDARD_PROPERTY_SETS[i3], compoundFile$ReadPropertyStorage);
            }
            if (bl) continue;
            try {
                int n3;
                byte[] byArray = null;
                byArray = baseCompoundFile$PropertyStorage.size > 0 ? compoundFile.getStream(i2) : new byte[]{};
                object = new CompoundFile$ReadPropertyStorage(baseCompoundFile$PropertyStorage, byArray, i2);
                this.additionalPropertySets.add(object);
                if (byArray.length > 4096) {
                    n3 = this.getBigBlocksRequired(byArray.length);
                    n += n3;
                    continue;
                }
                n3 = this.getSmallBlocksRequired(byArray.length);
                this.numSmallBlocks += n3;
                continue;
            }
            catch (BiffException biffException) {
                logger.error(biffException);
                throw new CopyAdditionalPropertySetsException();
            }
        }
        this.additionalPropertyBlocks = n;
    }

    public final void write() {
        this.writeHeader();
        this.writeExcelData();
        this.writeDocumentSummaryData();
        this.writeSummaryData();
        this.writeAdditionalPropertySets();
        this.writeSmallBlockDepot();
        this.writeSmallBlockDepotChain();
        this.writeBigBlockDepot();
        this.writePropertySets();
    }

    private void writeAdditionalPropertySets() {
        if (this.additionalPropertySets == null) {
            return;
        }
        Iterator iterator = this.additionalPropertySets.iterator();
        while (iterator.hasNext()) {
            CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)iterator.next();
            byte[] byArray = compoundFile$ReadPropertyStorage.data;
            if (byArray.length <= 4096) continue;
            int n = this.getBigBlocksRequired(byArray.length);
            int n2 = n * 512;
            this.out.write(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[n2 - byArray.length];
            this.out.write(byArray2, 0, byArray2.length);
        }
    }

    private void writeExcelData() {
        this.out.write(this.excelData, 0, this.size);
        byte[] byArray = new byte[this.requiredSize - this.size];
        this.out.write(byArray);
    }

    private void writeDocumentSummaryData() {
        byte[] byArray = new byte[4096];
        this.out.write(byArray);
    }

    private void writeSummaryData() {
        byte[] byArray = new byte[4096];
        this.out.write(byArray);
    }

    private void writeHeader() {
        int n;
        byte[] byArray = new byte[512];
        byte[] byArray2 = new byte[512 * this.numExtensionBlocks];
        System.arraycopy(IDENTIFIER, 0, byArray, 0, IDENTIFIER.length);
        byArray[24] = 62;
        byArray[26] = 3;
        byArray[28] = -2;
        byArray[29] = -1;
        byArray[30] = 9;
        byArray[32] = 6;
        byArray[57] = 16;
        IntegerHelper.getFourBytes(this.numBigBlockDepotBlocks, byArray, 44);
        IntegerHelper.getFourBytes(this.sbdStartBlockChain, byArray, 60);
        IntegerHelper.getFourBytes(this.numSmallBlockDepotChainBlocks, byArray, 64);
        IntegerHelper.getFourBytes(this.extensionBlock, byArray, 68);
        IntegerHelper.getFourBytes(this.numExtensionBlocks, byArray, 72);
        IntegerHelper.getFourBytes(this.rootStartBlock, byArray, 48);
        int n2 = 76;
        int n3 = Math.min(this.numBigBlockDepotBlocks, 109);
        boolean bl = false;
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            IntegerHelper.getFourBytes(this.bbdStartBlock + n, byArray, n2);
            n2 += 4;
            ++n4;
        }
        for (n = n2; n < 512; ++n) {
            byArray[n] = -1;
        }
        this.out.write(byArray);
        n2 = 0;
        for (n = 0; n < this.numExtensionBlocks; ++n) {
            int n5;
            n3 = Math.min(this.numBigBlockDepotBlocks - n4, 127);
            for (n5 = 0; n5 < n3; ++n5) {
                IntegerHelper.getFourBytes(this.bbdStartBlock + n4 + n5, byArray2, n2);
                n2 += 4;
            }
            n5 = (n4 += n3) == this.numBigBlockDepotBlocks ? -2 : n + 1;
            IntegerHelper.getFourBytes(n5, byArray2, n2);
            n2 += 4;
        }
        if (this.numExtensionBlocks > 0) {
            for (n = n2; n < byArray2.length; ++n) {
                byArray2[n] = -1;
            }
            this.out.write(byArray2);
        }
    }

    private void checkBbdPos() {
        if (this.bbdPos >= 512) {
            this.out.write(this.bigBlockDepot);
            this.bigBlockDepot = new byte[512];
            this.bbdPos = 0;
        }
    }

    private void writeBlockChain(int n, int n2) {
        int n3;
        int n4 = n + 1;
        for (int i2 = n2 - 1; i2 > 0; i2 -= n3) {
            n3 = Math.min(i2, (512 - this.bbdPos) / 4);
            for (int i3 = 0; i3 < n3; ++i3) {
                IntegerHelper.getFourBytes(n4, this.bigBlockDepot, this.bbdPos);
                this.bbdPos += 4;
                ++n4;
            }
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
    }

    private void writeAdditionalPropertySetBlockChains() {
        if (this.additionalPropertySets == null) {
            return;
        }
        int n = this.excelDataStartBlock + this.excelDataBlocks + 16;
        Iterator iterator = this.additionalPropertySets.iterator();
        while (iterator.hasNext()) {
            CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)iterator.next();
            if (compoundFile$ReadPropertyStorage.data.length <= 4096) continue;
            String string = compoundFile$ReadPropertyStorage.propertyStorage.name;
            int n2 = this.getBigBlocksRequired(compoundFile$ReadPropertyStorage.data.length);
            this.writeBlockChain(n, n2);
            n += n2;
        }
    }

    private void writeSmallBlockDepotChain() {
        if (this.sbdStartBlockChain == -2) {
            return;
        }
        byte[] byArray = new byte[this.numSmallBlockDepotChainBlocks * 512];
        int n = 0;
        int n2 = 1;
        Iterator iterator = this.additionalPropertySets.iterator();
        while (iterator.hasNext()) {
            CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)iterator.next();
            if (compoundFile$ReadPropertyStorage.data.length > 4096 || compoundFile$ReadPropertyStorage.data.length == 0) continue;
            int n3 = this.getSmallBlocksRequired(compoundFile$ReadPropertyStorage.data.length);
            for (int i2 = 0; i2 < n3 - 1; ++i2) {
                IntegerHelper.getFourBytes(n2, byArray, n);
                n += 4;
                ++n2;
            }
            IntegerHelper.getFourBytes(-2, byArray, n);
            n += 4;
            ++n2;
        }
        this.out.write(byArray);
    }

    private void writeSmallBlockDepot() {
        if (this.additionalPropertySets == null) {
            return;
        }
        byte[] byArray = new byte[this.numSmallBlockDepotBlocks * 512];
        int n = 0;
        Iterator iterator = this.additionalPropertySets.iterator();
        while (iterator.hasNext()) {
            CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)iterator.next();
            if (compoundFile$ReadPropertyStorage.data.length > 4096) continue;
            int n2 = this.getSmallBlocksRequired(compoundFile$ReadPropertyStorage.data.length);
            int n3 = n2 * 64;
            System.arraycopy(compoundFile$ReadPropertyStorage.data, 0, byArray, n, compoundFile$ReadPropertyStorage.data.length);
            n += n3;
        }
        this.out.write(byArray);
    }

    private void writeBigBlockDepot() {
        int n;
        int n2;
        this.bigBlockDepot = new byte[512];
        this.bbdPos = 0;
        for (n2 = 0; n2 < this.numExtensionBlocks; ++n2) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        this.writeBlockChain(this.excelDataStartBlock, this.excelDataBlocks);
        for (n = n2 = this.excelDataStartBlock + this.excelDataBlocks + this.additionalPropertyBlocks; n < n2 + 7; ++n) {
            IntegerHelper.getFourBytes(n + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        for (n = n2 + 8; n < n2 + 15; ++n) {
            IntegerHelper.getFourBytes(n + 1, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        IntegerHelper.getFourBytes(-2, this.bigBlockDepot, this.bbdPos);
        this.bbdPos += 4;
        this.checkBbdPos();
        this.writeAdditionalPropertySetBlockChains();
        if (this.sbdStartBlock != -2) {
            this.writeBlockChain(this.sbdStartBlock, this.numSmallBlockDepotBlocks);
            this.writeBlockChain(this.sbdStartBlockChain, this.numSmallBlockDepotChainBlocks);
        }
        for (n = 0; n < this.numBigBlockDepotBlocks; ++n) {
            IntegerHelper.getFourBytes(-3, this.bigBlockDepot, this.bbdPos);
            this.bbdPos += 4;
            this.checkBbdPos();
        }
        this.writeBlockChain(this.rootStartBlock, this.numRootEntryBlocks);
        if (this.bbdPos != 0) {
            for (n = this.bbdPos; n < 512; ++n) {
                this.bigBlockDepot[n] = -1;
            }
            this.out.write(this.bigBlockDepot);
        }
    }

    private int getBigBlocksRequired(int n) {
        int n2 = n / 512;
        return n % 512 > 0 ? n2 + 1 : n2;
    }

    private int getSmallBlocksRequired(int n) {
        int n2 = n / 64;
        return n % 64 > 0 ? n2 + 1 : n2;
    }

    private void writePropertySets() {
        CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage;
        Object object;
        int n;
        byte[] byArray = new byte[512 * this.numRootEntryBlocks];
        int n2 = 0;
        int[] nArray = null;
        if (this.additionalPropertySets != null) {
            Object object2;
            nArray = new int[this.numPropertySets];
            for (n = 0; n < STANDARD_PROPERTY_SETS.length; ++n) {
                object2 = (CompoundFile$ReadPropertyStorage)this.standardPropertySets.get(STANDARD_PROPERTY_SETS[n]);
                if (object2 != null) {
                    nArray[((CompoundFile$ReadPropertyStorage)object2).number] = n;
                    continue;
                }
                logger.warn("Standard property set " + STANDARD_PROPERTY_SETS[n] + " not present in source file");
            }
            n = STANDARD_PROPERTY_SETS.length;
            object2 = this.additionalPropertySets.iterator();
            while (object2.hasNext()) {
                CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage2 = (CompoundFile$ReadPropertyStorage)object2.next();
                nArray[compoundFile$ReadPropertyStorage2.number] = n++;
            }
        }
        n = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.additionalPropertySets != null) {
            n5 += this.getBigBlocksRequired(this.requiredSize) * 512;
            n5 += this.getBigBlocksRequired(4096) * 512;
            n5 += this.getBigBlocksRequired(4096) * 512;
            object = this.additionalPropertySets.iterator();
            while (object.hasNext()) {
                compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)object.next();
                if (compoundFile$ReadPropertyStorage.propertyStorage.type == 1) continue;
                if (compoundFile$ReadPropertyStorage.propertyStorage.size >= 4096) {
                    n5 += this.getBigBlocksRequired(compoundFile$ReadPropertyStorage.propertyStorage.size) * 512;
                    continue;
                }
                n5 += this.getSmallBlocksRequired(compoundFile$ReadPropertyStorage.propertyStorage.size) * 64;
            }
        }
        object = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, "Root Entry");
        ((BaseCompoundFile$PropertyStorage)object).setType(5);
        ((BaseCompoundFile$PropertyStorage)object).setStartBlock(this.sbdStartBlock);
        ((BaseCompoundFile$PropertyStorage)object).setSize(n5);
        ((BaseCompoundFile$PropertyStorage)object).setPrevious(-1);
        ((BaseCompoundFile$PropertyStorage)object).setNext(-1);
        ((BaseCompoundFile$PropertyStorage)object).setColour(0);
        n = 1;
        if (this.additionalPropertySets != null) {
            compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)this.standardPropertySets.get("Root Entry");
            n = nArray[compoundFile$ReadPropertyStorage.propertyStorage.child];
        }
        ((BaseCompoundFile$PropertyStorage)object).setChild(n);
        System.arraycopy(((BaseCompoundFile$PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, "Workbook");
        ((BaseCompoundFile$PropertyStorage)object).setType(2);
        ((BaseCompoundFile$PropertyStorage)object).setStartBlock(this.excelDataStartBlock);
        ((BaseCompoundFile$PropertyStorage)object).setSize(this.requiredSize);
        n3 = 3;
        n4 = -1;
        if (this.additionalPropertySets != null) {
            compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)this.standardPropertySets.get("Workbook");
            n3 = compoundFile$ReadPropertyStorage.propertyStorage.previous != -1 ? nArray[compoundFile$ReadPropertyStorage.propertyStorage.previous] : -1;
            n4 = compoundFile$ReadPropertyStorage.propertyStorage.next != -1 ? nArray[compoundFile$ReadPropertyStorage.propertyStorage.next] : -1;
        }
        ((BaseCompoundFile$PropertyStorage)object).setPrevious(n3);
        ((BaseCompoundFile$PropertyStorage)object).setNext(n4);
        ((BaseCompoundFile$PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile$PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, "\u0005SummaryInformation");
        ((BaseCompoundFile$PropertyStorage)object).setType(2);
        ((BaseCompoundFile$PropertyStorage)object).setStartBlock(this.excelDataStartBlock + this.excelDataBlocks);
        ((BaseCompoundFile$PropertyStorage)object).setSize(4096);
        n3 = 1;
        n4 = 3;
        if (this.additionalPropertySets != null && (compoundFile$ReadPropertyStorage = (CompoundFile$ReadPropertyStorage)this.standardPropertySets.get("\u0005SummaryInformation")) != null) {
            n3 = compoundFile$ReadPropertyStorage.propertyStorage.previous != -1 ? nArray[compoundFile$ReadPropertyStorage.propertyStorage.previous] : -1;
            n4 = compoundFile$ReadPropertyStorage.propertyStorage.next != -1 ? nArray[compoundFile$ReadPropertyStorage.propertyStorage.next] : -1;
        }
        ((BaseCompoundFile$PropertyStorage)object).setPrevious(n3);
        ((BaseCompoundFile$PropertyStorage)object).setNext(n4);
        ((BaseCompoundFile$PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile$PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        object = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, "\u0005DocumentSummaryInformation");
        ((BaseCompoundFile$PropertyStorage)object).setType(2);
        ((BaseCompoundFile$PropertyStorage)object).setStartBlock(this.excelDataStartBlock + this.excelDataBlocks + 8);
        ((BaseCompoundFile$PropertyStorage)object).setSize(4096);
        ((BaseCompoundFile$PropertyStorage)object).setPrevious(-1);
        ((BaseCompoundFile$PropertyStorage)object).setNext(-1);
        ((BaseCompoundFile$PropertyStorage)object).setChild(-1);
        System.arraycopy(((BaseCompoundFile$PropertyStorage)object).data, 0, byArray, n2, 128);
        n2 += 128;
        if (this.additionalPropertySets == null) {
            this.out.write(byArray);
            return;
        }
        int n6 = this.excelDataStartBlock + this.excelDataBlocks + 16;
        int n7 = 0;
        boolean bl = false;
        Iterator iterator = this.additionalPropertySets.iterator();
        while (iterator.hasNext()) {
            CompoundFile$ReadPropertyStorage compoundFile$ReadPropertyStorage3 = (CompoundFile$ReadPropertyStorage)iterator.next();
            int n8 = compoundFile$ReadPropertyStorage3.data.length > 4096 ? n6 : n7;
            object = new BaseCompoundFile$PropertyStorage((BaseCompoundFile)this, compoundFile$ReadPropertyStorage3.propertyStorage.name);
            ((BaseCompoundFile$PropertyStorage)object).setType(compoundFile$ReadPropertyStorage3.propertyStorage.type);
            ((BaseCompoundFile$PropertyStorage)object).setStartBlock(n8);
            ((BaseCompoundFile$PropertyStorage)object).setSize(compoundFile$ReadPropertyStorage3.propertyStorage.size);
            n3 = compoundFile$ReadPropertyStorage3.propertyStorage.previous != -1 ? nArray[compoundFile$ReadPropertyStorage3.propertyStorage.previous] : -1;
            n4 = compoundFile$ReadPropertyStorage3.propertyStorage.next != -1 ? nArray[compoundFile$ReadPropertyStorage3.propertyStorage.next] : -1;
            n = compoundFile$ReadPropertyStorage3.propertyStorage.child != -1 ? nArray[compoundFile$ReadPropertyStorage3.propertyStorage.child] : -1;
            ((BaseCompoundFile$PropertyStorage)object).setPrevious(n3);
            ((BaseCompoundFile$PropertyStorage)object).setNext(n4);
            ((BaseCompoundFile$PropertyStorage)object).setChild(n);
            System.arraycopy(((BaseCompoundFile$PropertyStorage)object).data, 0, byArray, n2, 128);
            n2 += 128;
            if (compoundFile$ReadPropertyStorage3.data.length > 4096) {
                n6 += this.getBigBlocksRequired(compoundFile$ReadPropertyStorage3.data.length);
                continue;
            }
            n7 += this.getSmallBlocksRequired(compoundFile$ReadPropertyStorage3.data.length);
        }
        this.out.write(byArray);
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

