/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.util.ArrayList;
import java.util.TreeSet;
import jxl.Cell;
import jxl.Range;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.ByteData;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.WritableRecordData;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.SheetDrawingWriter;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.Colour;
import jxl.write.Blank;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WriteException;
import jxl.write.biff.BOFRecord;
import jxl.write.biff.BottomMarginRecord;
import jxl.write.biff.ButtonPropertySetRecord;
import jxl.write.biff.CalcCountRecord;
import jxl.write.biff.CalcModeRecord;
import jxl.write.biff.CellXFRecord;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.DBCellRecord;
import jxl.write.biff.DataValidation;
import jxl.write.biff.DefaultColumnWidth;
import jxl.write.biff.DefaultRowHeightRecord;
import jxl.write.biff.DeltaRecord;
import jxl.write.biff.DimensionRecord;
import jxl.write.biff.EOFRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.GridSetRecord;
import jxl.write.biff.GuttersRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HorizontalCentreRecord;
import jxl.write.biff.HorizontalPageBreaksRecord;
import jxl.write.biff.IndexRecord;
import jxl.write.biff.IterationRecord;
import jxl.write.biff.LeftMarginRecord;
import jxl.write.biff.MergedCells;
import jxl.write.biff.ObjectProtectRecord;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.PaneRecord;
import jxl.write.biff.PasswordRecord;
import jxl.write.biff.PrintGridLinesRecord;
import jxl.write.biff.PrintHeadersRecord;
import jxl.write.biff.ProtectRecord;
import jxl.write.biff.RefModeRecord;
import jxl.write.biff.RightMarginRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.SCLRecord;
import jxl.write.biff.SaveRecalcRecord;
import jxl.write.biff.ScenarioProtectRecord;
import jxl.write.biff.SelectionRecord;
import jxl.write.biff.SetupRecord;
import jxl.write.biff.TopMarginRecord;
import jxl.write.biff.VerticalCentreRecord;
import jxl.write.biff.Weird1Record;
import jxl.write.biff.Window2Record;
import jxl.write.biff.WritableSheetImpl;

final class SheetWriter {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$SheetWriter == null ? (class$jxl$write$biff$SheetWriter = SheetWriter.class$("jxl.write.biff.SheetWriter")) : class$jxl$write$biff$SheetWriter);
    private File outputFile;
    private RowRecord[] rows;
    private int numRows;
    private int numCols;
    private HeaderRecord header;
    private FooterRecord footer;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private ArrayList rowBreaks;
    private ArrayList hyperlinks;
    private DataValidation dataValidation;
    private MergedCells mergedCells;
    private PLSRecord plsRecord;
    private ButtonPropertySetRecord buttonPropertySet;
    private WorkspaceInformationRecord workspaceOptions;
    private TreeSet columnFormats;
    private SheetDrawingWriter drawingWriter;
    private boolean chartOnly;
    private WritableSheetImpl sheet;
    static Class class$jxl$write$biff$SheetWriter;

    public SheetWriter(File file, WritableSheetImpl writableSheetImpl, WorkbookSettings workbookSettings) {
        this.outputFile = file;
        this.sheet = writableSheetImpl;
        this.workspaceOptions = new WorkspaceInformationRecord();
        this.workbookSettings = workbookSettings;
        this.chartOnly = false;
        this.drawingWriter = new SheetDrawingWriter(workbookSettings);
    }

    public final void write() {
        int n;
        Object object;
        WritableRecordData writableRecordData;
        WritableRecordData writableRecordData2;
        WritableRecordData writableRecordData3;
        WritableRecordData writableRecordData4;
        WritableRecordData writableRecordData5;
        WritableRecordData writableRecordData6;
        Object object2;
        Assert.verify(this.rows != null);
        if (this.chartOnly) {
            this.drawingWriter.write(this.outputFile);
            return;
        }
        int n2 = this.outputFile.getPos();
        BOFRecord bOFRecord = new BOFRecord(BOFRecord.sheet);
        this.outputFile.write(bOFRecord);
        int n3 = this.numRows / 32;
        if (this.numRows - n3 * 32 != 0) {
            ++n3;
        }
        int n4 = this.outputFile.getPos();
        IndexRecord indexRecord = new IndexRecord(0, this.numRows, n3);
        this.outputFile.write(indexRecord);
        CalcModeRecord calcModeRecord = new CalcModeRecord(CalcModeRecord.automatic);
        this.outputFile.write(calcModeRecord);
        CalcCountRecord calcCountRecord = new CalcCountRecord(100);
        this.outputFile.write(calcCountRecord);
        RefModeRecord refModeRecord = new RefModeRecord();
        this.outputFile.write(refModeRecord);
        IterationRecord iterationRecord = new IterationRecord(false);
        this.outputFile.write(iterationRecord);
        DeltaRecord deltaRecord = new DeltaRecord(0.001);
        this.outputFile.write(deltaRecord);
        SaveRecalcRecord saveRecalcRecord = new SaveRecalcRecord(true);
        this.outputFile.write(saveRecalcRecord);
        PrintHeadersRecord printHeadersRecord = new PrintHeadersRecord(this.settings.getPrintHeaders());
        this.outputFile.write(printHeadersRecord);
        PrintGridLinesRecord printGridLinesRecord = new PrintGridLinesRecord(this.settings.getPrintGridLines());
        this.outputFile.write(printGridLinesRecord);
        GridSetRecord gridSetRecord = new GridSetRecord(true);
        this.outputFile.write(gridSetRecord);
        GuttersRecord guttersRecord = new GuttersRecord();
        this.outputFile.write(guttersRecord);
        DefaultRowHeightRecord defaultRowHeightRecord = new DefaultRowHeightRecord(this.settings.getDefaultRowHeight(), this.settings.getDefaultRowHeight() != 255);
        this.outputFile.write(defaultRowHeightRecord);
        this.workspaceOptions.setFitToPages(this.settings.getFitToPages());
        this.outputFile.write(this.workspaceOptions);
        if (this.rowBreaks.size() > 0) {
            object2 = new int[this.rowBreaks.size()];
            for (int i2 = 0; i2 < ((int[])object2).length; ++i2) {
                object2[i2] = (Integer)this.rowBreaks.get(i2);
            }
            writableRecordData6 = new HorizontalPageBreaksRecord((int[])object2);
            this.outputFile.write(writableRecordData6);
        }
        object2 = new HeaderRecord(this.settings.getHeader().toString());
        this.outputFile.write((ByteData)object2);
        writableRecordData6 = new FooterRecord(this.settings.getFooter().toString());
        this.outputFile.write(writableRecordData6);
        HorizontalCentreRecord horizontalCentreRecord = new HorizontalCentreRecord(this.settings.isHorizontalCentre());
        this.outputFile.write(horizontalCentreRecord);
        VerticalCentreRecord verticalCentreRecord = new VerticalCentreRecord(this.settings.isVerticalCentre());
        this.outputFile.write(verticalCentreRecord);
        if (this.settings.getLeftMargin() != this.settings.getDefaultWidthMargin()) {
            writableRecordData5 = new LeftMarginRecord(this.settings.getLeftMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getRightMargin() != this.settings.getDefaultWidthMargin()) {
            writableRecordData5 = new RightMarginRecord(this.settings.getRightMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getTopMargin() != this.settings.getDefaultHeightMargin()) {
            writableRecordData5 = new TopMarginRecord(this.settings.getTopMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.settings.getBottomMargin() != this.settings.getDefaultHeightMargin()) {
            writableRecordData5 = new BottomMarginRecord(this.settings.getBottomMargin());
            this.outputFile.write(writableRecordData5);
        }
        if (this.plsRecord != null) {
            this.outputFile.write(this.plsRecord);
        }
        writableRecordData5 = new SetupRecord(this.settings);
        this.outputFile.write(writableRecordData5);
        if (this.settings.isProtected()) {
            writableRecordData4 = new ProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData4);
            writableRecordData3 = new ScenarioProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData3);
            writableRecordData2 = new ObjectProtectRecord(this.settings.isProtected());
            this.outputFile.write(writableRecordData2);
            if (this.settings.getPassword() != null) {
                writableRecordData = new PasswordRecord(this.settings.getPassword());
                this.outputFile.write(writableRecordData);
            } else if (this.settings.getPasswordHash() != 0) {
                writableRecordData = new PasswordRecord(this.settings.getPasswordHash());
                this.outputFile.write(writableRecordData);
            }
        }
        indexRecord.setDataStartPosition(this.outputFile.getPos());
        writableRecordData4 = new DefaultColumnWidth(this.settings.getDefaultColumnWidth());
        this.outputFile.write(writableRecordData4);
        writableRecordData3 = this.sheet.getWorkbook().getStyles().getNormalStyle();
        writableRecordData2 = this.sheet.getWorkbook().getStyles().getDefaultDateFormat();
        writableRecordData = null;
        boolean bl = false;
        Object object3 = this.columnFormats.iterator();
        while (object3.hasNext()) {
            XFRecord xFRecord;
            writableRecordData = (ColumnInfoRecord)object3.next();
            if (((ColumnInfoRecord)writableRecordData).getColumn() < 256) {
                this.outputFile.write(writableRecordData);
            }
            if ((xFRecord = ((ColumnInfoRecord)writableRecordData).getCellFormat()) == writableRecordData3 || ((ColumnInfoRecord)writableRecordData).getColumn() >= 256) continue;
            object = this.getColumn(((ColumnInfoRecord)writableRecordData).getColumn());
            for (n = 0; n < ((Cell[])object).length; ++n) {
                if (object[n] == null || object[n].getCellFormat() != writableRecordData3 && object[n].getCellFormat() != writableRecordData2) continue;
                ((WritableCell)object[n]).setCellFormat(xFRecord);
            }
        }
        object3 = new DimensionRecord(this.numRows, this.numCols);
        this.outputFile.write((ByteData)object3);
        for (int i3 = 0; i3 < n3; ++i3) {
            int n5;
            object = new DBCellRecord(this.outputFile.getPos());
            n = Math.min(32, this.numRows - i3 * 32);
            boolean bl2 = true;
            for (n5 = i3 * 32; n5 < i3 * 32 + n; ++n5) {
                if (this.rows[n5] == null) continue;
                this.rows[n5].write(this.outputFile);
                if (!bl2) continue;
                ((DBCellRecord)object).setCellOffset(this.outputFile.getPos());
                bl2 = false;
            }
            for (n5 = i3 * 32; n5 < i3 * 32 + n; ++n5) {
                if (this.rows[n5] == null) continue;
                ((DBCellRecord)object).addCellRowPosition(this.outputFile.getPos());
                this.rows[n5].writeCells(this.outputFile);
            }
            indexRecord.addBlockPosition(this.outputFile.getPos());
            ((DBCellRecord)object).setPosition(this.outputFile.getPos());
            this.outputFile.write((ByteData)object);
        }
        if (this.dataValidation != null) {
            this.dataValidation.write(this.outputFile);
        }
        if (!this.workbookSettings.getDrawingsDisabled()) {
            this.drawingWriter.write(this.outputFile);
        }
        Window2Record window2Record = new Window2Record(this.settings);
        this.outputFile.write(window2Record);
        if (this.settings.getHorizontalFreeze() != 0 || this.settings.getVerticalFreeze() != 0) {
            object = new PaneRecord(this.settings.getHorizontalFreeze(), this.settings.getVerticalFreeze());
            this.outputFile.write((ByteData)object);
            SelectionRecord selectionRecord = new SelectionRecord(SelectionRecord.upperLeft, 0, 0);
            this.outputFile.write(selectionRecord);
            if (this.settings.getHorizontalFreeze() != 0) {
                selectionRecord = new SelectionRecord(SelectionRecord.upperRight, this.settings.getHorizontalFreeze(), 0);
                this.outputFile.write(selectionRecord);
            }
            if (this.settings.getVerticalFreeze() != 0) {
                selectionRecord = new SelectionRecord(SelectionRecord.lowerLeft, 0, this.settings.getVerticalFreeze());
                this.outputFile.write(selectionRecord);
            }
            if (this.settings.getHorizontalFreeze() != 0 && this.settings.getVerticalFreeze() != 0) {
                selectionRecord = new SelectionRecord(SelectionRecord.lowerRight, this.settings.getHorizontalFreeze(), this.settings.getVerticalFreeze());
                this.outputFile.write(selectionRecord);
            }
            Weird1Record weird1Record = new Weird1Record();
            this.outputFile.write(weird1Record);
        } else {
            object = new SelectionRecord(SelectionRecord.upperLeft, 0, 0);
            this.outputFile.write((ByteData)object);
        }
        if (this.settings.getZoomFactor() != 100) {
            object = new SCLRecord(this.settings.getZoomFactor());
            this.outputFile.write((ByteData)object);
        }
        this.mergedCells.write(this.outputFile);
        object = this.hyperlinks.iterator();
        WritableHyperlink writableHyperlink = null;
        while (object.hasNext()) {
            writableHyperlink = (WritableHyperlink)object.next();
            this.outputFile.write(writableHyperlink);
        }
        if (this.buttonPropertySet != null) {
            this.outputFile.write(this.buttonPropertySet);
        }
        EOFRecord eOFRecord = new EOFRecord();
        this.outputFile.write(eOFRecord);
        this.outputFile.setData(indexRecord.getData(), n4 + 4);
    }

    final HeaderRecord getHeader() {
        return this.header;
    }

    final FooterRecord getFooter() {
        return this.footer;
    }

    final void setWriteData(RowRecord[] rowRecordArray, ArrayList arrayList, ArrayList arrayList2, MergedCells mergedCells, TreeSet treeSet) {
        this.rows = rowRecordArray;
        this.rowBreaks = arrayList;
        this.hyperlinks = arrayList2;
        this.mergedCells = mergedCells;
        this.columnFormats = treeSet;
    }

    final void setDimensions(int n, int n2) {
        this.numRows = n;
        this.numCols = n2;
    }

    final void setSettings(SheetSettings sheetSettings) {
        this.settings = sheetSettings;
    }

    final WorkspaceInformationRecord getWorkspaceOptions() {
        return this.workspaceOptions;
    }

    final void setWorkspaceOptions(WorkspaceInformationRecord workspaceInformationRecord) {
        if (workspaceInformationRecord != null) {
            this.workspaceOptions = workspaceInformationRecord;
        }
    }

    final void setCharts(Chart[] chartArray) {
        this.drawingWriter.setCharts(chartArray);
    }

    final void setDrawings(ArrayList arrayList, boolean bl) {
        this.drawingWriter.setDrawings(arrayList, bl);
    }

    final Chart[] getCharts() {
        return this.drawingWriter.getCharts();
    }

    final void checkMergedBorders() {
        Range[] rangeArray = this.mergedCells.getMergedCells();
        ArrayList<CellXFRecord> arrayList = new ArrayList<CellXFRecord>();
        for (int i2 = 0; i2 < rangeArray.length; ++i2) {
            Range range = rangeArray[i2];
            Cell cell = range.getTopLeft();
            XFRecord xFRecord = (XFRecord)cell.getCellFormat();
            if (xFRecord == null || !xFRecord.hasBorders() || xFRecord.isRead()) continue;
            try {
                CellXFRecord cellXFRecord;
                int n;
                CellXFRecord cellXFRecord2 = new CellXFRecord(xFRecord);
                Cell cell2 = range.getBottomRight();
                cellXFRecord2.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                cellXFRecord2.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                cellXFRecord2.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                if (cell.getRow() == cell2.getRow()) {
                    cellXFRecord2.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                }
                if (cell.getColumn() == cell2.getColumn()) {
                    cellXFRecord2.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                }
                if ((n = arrayList.indexOf(cellXFRecord2)) != -1) {
                    cellXFRecord2 = (CellXFRecord)arrayList.get(n);
                } else {
                    arrayList.add(cellXFRecord2);
                }
                ((WritableCell)cell).setCellFormat(cellXFRecord2);
                if (cell2.getRow() > cell.getRow()) {
                    if (cell2.getColumn() != cell.getColumn()) {
                        CellXFRecord cellXFRecord3 = new CellXFRecord(xFRecord);
                        cellXFRecord3.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord3.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                        cellXFRecord3.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                        n = arrayList.indexOf(cellXFRecord3);
                        if (n != -1) {
                            cellXFRecord3 = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord3);
                        }
                        this.sheet.addCell(new Blank(cell.getColumn(), cell2.getRow(), cellXFRecord3));
                    }
                    for (int i3 = cell.getRow() + 1; i3 < cell2.getRow(); ++i3) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                        if (cell.getColumn() == cell2.getColumn()) {
                            cellXFRecord.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        }
                        if ((n = arrayList.indexOf(cellXFRecord)) != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(cell.getColumn(), i3, cellXFRecord));
                    }
                }
                if (cell2.getColumn() > cell.getColumn()) {
                    int n2;
                    if (cell2.getRow() != cell.getRow()) {
                        CellXFRecord cellXFRecord4 = new CellXFRecord(xFRecord);
                        cellXFRecord4.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord4.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        cellXFRecord4.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                        n = arrayList.indexOf(cellXFRecord4);
                        if (n != -1) {
                            cellXFRecord4 = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord4);
                        }
                        this.sheet.addCell(new Blank(cell2.getColumn(), cell.getRow(), cellXFRecord4));
                    }
                    for (n2 = cell.getRow() + 1; n2 < cell2.getRow(); ++n2) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                        n = arrayList.indexOf(cellXFRecord);
                        if (n != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(cell2.getColumn(), n2, cellXFRecord));
                    }
                    for (n2 = cell.getColumn() + 1; n2 < cell2.getColumn(); ++n2) {
                        cellXFRecord = new CellXFRecord(xFRecord);
                        cellXFRecord.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                        cellXFRecord.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                        if (cell.getRow() == cell2.getRow()) {
                            cellXFRecord.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                        }
                        if ((n = arrayList.indexOf(cellXFRecord)) != -1) {
                            cellXFRecord = (CellXFRecord)arrayList.get(n);
                        } else {
                            arrayList.add(cellXFRecord);
                        }
                        this.sheet.addCell(new Blank(n2, cell.getRow(), cellXFRecord));
                    }
                }
                if (cell2.getColumn() <= cell.getColumn() && cell2.getRow() <= cell.getRow()) continue;
                CellXFRecord cellXFRecord5 = new CellXFRecord(xFRecord);
                cellXFRecord5.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                cellXFRecord5.setBorder(Border.RIGHT, xFRecord.getBorderLine(Border.RIGHT), xFRecord.getBorderColour(Border.RIGHT));
                cellXFRecord5.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                if (cell2.getRow() == cell.getRow()) {
                    cellXFRecord5.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                }
                if (cell2.getColumn() == cell.getColumn()) {
                    cellXFRecord5.setBorder(Border.LEFT, xFRecord.getBorderLine(Border.LEFT), xFRecord.getBorderColour(Border.LEFT));
                }
                if ((n = arrayList.indexOf(cellXFRecord5)) != -1) {
                    cellXFRecord5 = (CellXFRecord)arrayList.get(n);
                } else {
                    arrayList.add(cellXFRecord5);
                }
                this.sheet.addCell(new Blank(cell2.getColumn(), cell2.getRow(), cellXFRecord5));
                for (int i4 = cell.getColumn() + 1; i4 < cell2.getColumn(); ++i4) {
                    CellXFRecord cellXFRecord6 = new CellXFRecord(xFRecord);
                    cellXFRecord6.setBorder(Border.ALL, BorderLineStyle.NONE, Colour.BLACK);
                    cellXFRecord6.setBorder(Border.BOTTOM, xFRecord.getBorderLine(Border.BOTTOM), xFRecord.getBorderColour(Border.BOTTOM));
                    if (cell.getRow() == cell2.getRow()) {
                        cellXFRecord6.setBorder(Border.TOP, xFRecord.getBorderLine(Border.TOP), xFRecord.getBorderColour(Border.TOP));
                    }
                    if ((n = arrayList.indexOf(cellXFRecord6)) != -1) {
                        cellXFRecord6 = (CellXFRecord)arrayList.get(n);
                    } else {
                        arrayList.add(cellXFRecord6);
                    }
                    this.sheet.addCell(new Blank(i4, cell2.getRow(), cellXFRecord6));
                }
                continue;
            }
            catch (WriteException writeException) {
                logger.warn(writeException.toString());
            }
        }
    }

    private Cell[] getColumn(int n) {
        boolean bl = false;
        int n2 = this.numRows - 1;
        while (n2 >= 0 && !bl) {
            if (this.rows[n2] != null && this.rows[n2].getCell(n) != null) {
                bl = true;
                continue;
            }
            --n2;
        }
        Cell[] cellArray = new Cell[n2 + 1];
        for (int i2 = 0; i2 <= n2; ++i2) {
            cellArray[i2] = this.rows[i2] != null ? this.rows[i2].getCell(n) : null;
        }
        return cellArray;
    }

    final void setChartOnly() {
        this.chartOnly = true;
    }

    final void setPLS(PLSRecord pLSRecord) {
        this.plsRecord = pLSRecord;
    }

    final void setButtonPropertySet(ButtonPropertySetRecord buttonPropertySetRecord) {
        this.buttonPropertySet = buttonPropertySetRecord;
    }

    final void setDataValidation(DataValidation dataValidation) {
        this.dataValidation = dataValidation;
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

