/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Gamma;
import org.apache.commons.math3.util.FastMath;

public class GammaDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 20120524L;
    private final double shape;
    private final double scale;
    private final double shiftedShape;
    private final double densityPrefactor1;
    private final double densityPrefactor2;
    private final double minY;
    private final double maxLogY;
    private final double solverAbsoluteAccuracy;

    public GammaDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public GammaDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public GammaDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SHAPE, d2);
        }
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.SCALE, d3);
        }
        this.shape = d2;
        this.scale = d3;
        this.solverAbsoluteAccuracy = d4;
        this.shiftedShape = d2 + 4.7421875 + 0.5;
        double d5 = Math.E / (Math.PI * 2 * this.shiftedShape);
        this.densityPrefactor2 = d2 * FastMath.sqrt(d5) / Gamma.lanczos(d2);
        this.densityPrefactor1 = this.densityPrefactor2 / d3 * FastMath.pow(this.shiftedShape, -d2) * FastMath.exp(d2 + 4.7421875);
        this.minY = d2 + 4.7421875 - FastMath.log(Double.MAX_VALUE);
        this.maxLogY = FastMath.log(Double.MAX_VALUE) / (d2 - 1.0);
    }

    public final double getAlpha() {
        return this.shape;
    }

    public final double getShape() {
        return this.shape;
    }

    public final double getBeta() {
        return this.scale;
    }

    public final double getScale() {
        return this.scale;
    }

    public final double density(double d2) {
        if (d2 < 0.0) {
            return 0.0;
        }
        double d3 = d2 / this.scale;
        if (d3 <= this.minY || FastMath.log(d3) >= this.maxLogY) {
            double d4 = (d3 - this.shiftedShape) / this.shiftedShape;
            double d5 = this.shape * (FastMath.log1p(d4) - d4);
            double d6 = -d3 * 5.2421875 / this.shiftedShape + 4.7421875 + d5;
            return this.densityPrefactor2 / d2 * FastMath.exp(d6);
        }
        return this.densityPrefactor1 * FastMath.exp(-d3) * FastMath.pow(d3, this.shape - 1.0);
    }

    public final double cumulativeProbability(double d2) {
        double d3 = d2 <= 0.0 ? 0.0 : Gamma.regularizedGammaP(this.shape, d2 / this.scale);
        return d3;
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        return this.shape * this.scale;
    }

    public final double getNumericalVariance() {
        return this.shape * this.scale * this.scale;
    }

    public final double getSupportLowerBound() {
        return 0.0;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return true;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }

    public final double sample() {
        double d2;
        if (this.shape < 1.0) {
            double d3;
            while (true) {
                double d4;
                double d5;
                double d6;
                double d7;
                if ((d7 = (d6 = 1.0 + this.shape / Math.E) * (d5 = this.random.nextDouble())) <= 1.0) {
                    d3 = FastMath.pow(d7, 1.0 / this.shape);
                    d4 = this.random.nextDouble();
                    if (d4 > FastMath.exp(-d3)) continue;
                    return this.scale * d3;
                }
                d3 = -1.0 * FastMath.log((d6 - d7) / this.shape);
                d4 = this.random.nextDouble();
                if (!(d4 > FastMath.pow(d3, this.shape - 1.0))) break;
            }
            return this.scale * d3;
        }
        double d8 = this.shape - 0.3333333333333333;
        double d9 = 1.0 / (3.0 * FastMath.sqrt(d8));
        while (true) {
            double d10;
            if ((d2 = (1.0 + d9 * (d10 = this.random.nextGaussian())) * (1.0 + d9 * d10) * (1.0 + d9 * d10)) <= 0.0) {
                continue;
            }
            double d11 = d10 * d10;
            double d12 = this.random.nextDouble();
            if (d12 < 1.0 - 0.0331 * d11 * d11) {
                return this.scale * d8 * d2;
            }
            if (FastMath.log(d12) < 0.5 * d11 + d8 * (1.0 - d2 + FastMath.log(d2))) break;
        }
        return this.scale * d8 * d2;
    }
}

