/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractRealDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.special.Erf;
import org.apache.commons.math3.util.FastMath;

public class NormalDistribution
extends AbstractRealDistribution {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 8589540077390120676L;
    private static final double SQRT2PI = FastMath.sqrt(Math.PI * 2);
    private static final double SQRT2 = FastMath.sqrt(2.0);
    private final double mean;
    private final double standardDeviation;
    private final double solverAbsoluteAccuracy;

    public NormalDistribution() {
        this(0.0, 1.0);
    }

    public NormalDistribution(double d2, double d3) {
        this(d2, d3, 1.0E-9);
    }

    public NormalDistribution(double d2, double d3, double d4) {
        this(new Well19937c(), d2, d3, d4);
    }

    public NormalDistribution(RandomGenerator randomGenerator, double d2, double d3, double d4) {
        super(randomGenerator);
        if (d3 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.STANDARD_DEVIATION, d3);
        }
        this.mean = d2;
        this.standardDeviation = d3;
        this.solverAbsoluteAccuracy = d4;
    }

    public final double getMean() {
        return this.mean;
    }

    public final double getStandardDeviation() {
        return this.standardDeviation;
    }

    public final double density(double d2) {
        double d3 = d2 - this.mean;
        double d4 = d3 / this.standardDeviation;
        return FastMath.exp(-0.5 * d4 * d4) / (this.standardDeviation * SQRT2PI);
    }

    public final double cumulativeProbability(double d2) {
        double d3 = d2 - this.mean;
        if (FastMath.abs(d3) > 40.0 * this.standardDeviation) {
            return d3 < 0.0 ? 0.0 : 1.0;
        }
        return 0.5 * (1.0 + Erf.erf(d3 / (this.standardDeviation * SQRT2)));
    }

    public final double inverseCumulativeProbability(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new OutOfRangeException(d2, (Number)0, 1);
        }
        return this.mean + this.standardDeviation * SQRT2 * Erf.erfInv(2.0 * d2 - 1.0);
    }

    public final double cumulativeProbability(double d2, double d3) {
        return this.probability(d2, d3);
    }

    public final double probability(double d2, double d3) {
        if (d2 > d3) {
            throw new NumberIsTooLargeException((Localizable)LocalizedFormats.LOWER_ENDPOINT_ABOVE_UPPER_ENDPOINT, (Number)d2, d3, true);
        }
        double d4 = this.standardDeviation * SQRT2;
        double d5 = (d2 - this.mean) / d4;
        double d6 = (d3 - this.mean) / d4;
        return 0.5 * Erf.erf(d5, d6);
    }

    protected final double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public final double getNumericalMean() {
        return this.getMean();
    }

    public final double getNumericalVariance() {
        double d2 = this.getStandardDeviation();
        return d2 * d2;
    }

    public final double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    public final double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public final boolean isSupportLowerBoundInclusive() {
        return false;
    }

    public final boolean isSupportUpperBoundInclusive() {
        return false;
    }

    public final boolean isSupportConnected() {
        return true;
    }

    public final double sample() {
        return this.standardDeviation * this.random.nextGaussian() + this.mean;
    }
}

