/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.distribution;

import org.apache.commons.math3.distribution.AbstractIntegerDistribution;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well19937c;
import org.apache.commons.math3.util.FastMath;

public class ZipfDistribution
extends AbstractIntegerDistribution {
    private static final long serialVersionUID = -140627372283420404L;
    private final int numberOfElements;
    private final double exponent;
    private double numericalMean = Double.NaN;
    private boolean numericalMeanIsCalculated = false;
    private double numericalVariance = Double.NaN;
    private boolean numericalVarianceIsCalculated = false;

    public ZipfDistribution(int n, double d2) {
        this(new Well19937c(), n, d2);
    }

    public ZipfDistribution(RandomGenerator randomGenerator, int n, double d2) {
        super(randomGenerator);
        if (n <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.DIMENSION, n);
        }
        if (d2 <= 0.0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.EXPONENT, d2);
        }
        this.numberOfElements = n;
        this.exponent = d2;
    }

    public final int getNumberOfElements() {
        return this.numberOfElements;
    }

    public final double getExponent() {
        return this.exponent;
    }

    public final double probability(int n) {
        if (n <= 0 || n > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / FastMath.pow((double)n, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public final double cumulativeProbability(int n) {
        if (n <= 0) {
            return 0.0;
        }
        if (n >= this.numberOfElements) {
            return 1.0;
        }
        return this.generalizedHarmonic(n, this.exponent) / this.generalizedHarmonic(this.numberOfElements, this.exponent);
    }

    public final double getNumericalMean() {
        if (!this.numericalMeanIsCalculated) {
            this.numericalMean = this.calculateNumericalMean();
            this.numericalMeanIsCalculated = true;
        }
        return this.numericalMean;
    }

    protected final double calculateNumericalMean() {
        int n = this.getNumberOfElements();
        double d2 = this.getExponent();
        double d3 = this.generalizedHarmonic(n, d2 - 1.0);
        double d4 = this.generalizedHarmonic(n, d2);
        return d3 / d4;
    }

    public final double getNumericalVariance() {
        if (!this.numericalVarianceIsCalculated) {
            this.numericalVariance = this.calculateNumericalVariance();
            this.numericalVarianceIsCalculated = true;
        }
        return this.numericalVariance;
    }

    protected final double calculateNumericalVariance() {
        int n = this.getNumberOfElements();
        double d2 = this.getExponent();
        double d3 = this.generalizedHarmonic(n, d2 - 2.0);
        double d4 = this.generalizedHarmonic(n, d2 - 1.0);
        double d5 = this.generalizedHarmonic(n, d2);
        return d3 / d5 - d4 * d4 / (d5 * d5);
    }

    private double generalizedHarmonic(int n, double d2) {
        double d3 = 0.0;
        for (int i2 = n; i2 > 0; --i2) {
            d3 += 1.0 / FastMath.pow((double)i2, d2);
        }
        return d3;
    }

    public final int getSupportLowerBound() {
        return 1;
    }

    public final int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    public final boolean isSupportConnected() {
        return true;
    }
}

