/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.stat.regression;

import java.io.Serializable;
import org.apache.commons.math3.distribution.TDistribution;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.stat.regression.ModelSpecificationException;
import org.apache.commons.math3.stat.regression.RegressionResults;
import org.apache.commons.math3.stat.regression.UpdatingMultipleLinearRegression;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class SimpleRegression
implements Serializable,
UpdatingMultipleLinearRegression {
    private static final long serialVersionUID = -3004689053607543335L;
    private double sumX = 0.0;
    private double sumXX = 0.0;
    private double sumY = 0.0;
    private double sumYY = 0.0;
    private double sumXY = 0.0;
    private long n = 0L;
    private double xbar = 0.0;
    private double ybar = 0.0;
    private final boolean hasIntercept;

    public SimpleRegression() {
        this(true);
    }

    public SimpleRegression(boolean bl) {
        this.hasIntercept = bl;
    }

    public void addData(double d2, double d3) {
        if (this.n == 0L) {
            this.xbar = d2;
            this.ybar = d3;
        } else if (this.hasIntercept) {
            double d4 = 1.0 + (double)this.n;
            double d5 = (double)this.n / (1.0 + (double)this.n);
            double d6 = d2 - this.xbar;
            double d7 = d3 - this.ybar;
            this.sumXX += d6 * d6 * d5;
            this.sumYY += d7 * d7 * d5;
            this.sumXY += d6 * d7 * d5;
            this.xbar += d6 / d4;
            this.ybar += d7 / d4;
        }
        if (!this.hasIntercept) {
            this.sumXX += d2 * d2;
            this.sumYY += d3 * d3;
            this.sumXY += d2 * d3;
        }
        this.sumX += d2;
        this.sumY += d3;
        ++this.n;
    }

    public void removeData(double d2, double d3) {
        if (this.n > 0L) {
            if (this.hasIntercept) {
                double d4 = (double)this.n - 1.0;
                double d5 = (double)this.n / ((double)this.n - 1.0);
                double d6 = d2 - this.xbar;
                double d7 = d3 - this.ybar;
                this.sumXX -= d6 * d6 * d5;
                this.sumYY -= d7 * d7 * d5;
                this.sumXY -= d6 * d7 * d5;
                this.xbar -= d6 / d4;
                this.ybar -= d7 / d4;
            } else {
                double d8 = (double)this.n - 1.0;
                this.sumXX -= d2 * d2;
                this.sumYY -= d3 * d3;
                this.sumXY -= d2 * d3;
                this.xbar -= d2 / d8;
                this.ybar -= d3 / d8;
            }
            this.sumX -= d2;
            this.sumY -= d3;
            --this.n;
        }
    }

    public void addData(double[][] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray[i2].length < 2) {
                throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray[i2].length, 2);
            }
            this.addData(dArray[i2][0], dArray[i2][1]);
        }
    }

    public void addObservation(double[] dArray, double d2) {
        if (dArray == null || dArray.length == 0) {
            throw new ModelSpecificationException(LocalizedFormats.INVALID_REGRESSION_OBSERVATION, dArray != null ? dArray.length : 0, 1);
        }
        this.addData(dArray[0], d2);
    }

    public void addObservations(double[][] dArray, double[] dArray2) {
        int n;
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            throw new ModelSpecificationException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, dArray == null ? 0 : dArray.length, dArray2 == null ? 0 : dArray2.length);
        }
        boolean bl = true;
        for (n = 0; n < dArray.length; ++n) {
            if (dArray[n] != null && dArray[n].length != 0) continue;
            bl = false;
        }
        if (!bl) {
            throw new ModelSpecificationException(LocalizedFormats.NOT_ENOUGH_DATA_FOR_NUMBER_OF_PREDICTORS, 0, 1);
        }
        for (n = 0; n < dArray.length; ++n) {
            this.addData(dArray[n][0], dArray2[n]);
        }
    }

    public void removeData(double[][] dArray) {
        for (int i2 = 0; i2 < dArray.length && this.n > 0L; ++i2) {
            this.removeData(dArray[i2][0], dArray[i2][1]);
        }
    }

    public void clear() {
        this.sumX = 0.0;
        this.sumXX = 0.0;
        this.sumY = 0.0;
        this.sumYY = 0.0;
        this.sumXY = 0.0;
        this.n = 0L;
    }

    public long getN() {
        return this.n;
    }

    public double predict(double d2) {
        double d3 = this.getSlope();
        if (this.hasIntercept) {
            return this.getIntercept(d3) + d3 * d2;
        }
        return d3 * d2;
    }

    public double getIntercept() {
        return this.hasIntercept ? this.getIntercept(this.getSlope()) : 0.0;
    }

    public boolean hasIntercept() {
        return this.hasIntercept;
    }

    public double getSlope() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        if (FastMath.abs(this.sumXX) < 4.9E-323) {
            return Double.NaN;
        }
        return this.sumXY / this.sumXX;
    }

    public double getSumSquaredErrors() {
        return FastMath.max(0.0, this.sumYY - this.sumXY * this.sumXY / this.sumXX);
    }

    public double getTotalSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumYY;
    }

    public double getXSumSquares() {
        if (this.n < 2L) {
            return Double.NaN;
        }
        return this.sumXX;
    }

    public double getSumOfCrossProducts() {
        return this.sumXY;
    }

    public double getRegressionSumSquares() {
        return this.getRegressionSumSquares(this.getSlope());
    }

    public double getMeanSquareError() {
        if (this.n < 3L) {
            return Double.NaN;
        }
        return this.hasIntercept ? this.getSumSquaredErrors() / (double)(this.n - 2L) : this.getSumSquaredErrors() / (double)(this.n - 1L);
    }

    public double getR() {
        double d2 = this.getSlope();
        double d3 = FastMath.sqrt(this.getRSquare());
        if (d2 < 0.0) {
            d3 = -d3;
        }
        return d3;
    }

    public double getRSquare() {
        double d2 = this.getTotalSumSquares();
        return (d2 - this.getSumSquaredErrors()) / d2;
    }

    public double getInterceptStdErr() {
        if (!this.hasIntercept) {
            return Double.NaN;
        }
        return FastMath.sqrt(this.getMeanSquareError() * (1.0 / (double)this.n + this.xbar * this.xbar / this.sumXX));
    }

    public double getSlopeStdErr() {
        return FastMath.sqrt(this.getMeanSquareError() / this.sumXX);
    }

    public double getSlopeConfidenceInterval() {
        return this.getSlopeConfidenceInterval(0.05);
    }

    public double getSlopeConfidenceInterval(double d2) {
        if (this.n < 3L) {
            return Double.NaN;
        }
        if (d2 >= 1.0 || d2 <= 0.0) {
            throw new OutOfRangeException((Localizable)LocalizedFormats.SIGNIFICANCE_LEVEL, (Number)d2, 0, 1);
        }
        TDistribution tDistribution = new TDistribution(this.n - 2L);
        return this.getSlopeStdErr() * tDistribution.inverseCumulativeProbability(1.0 - d2 / 2.0);
    }

    public double getSignificance() {
        if (this.n < 3L) {
            return Double.NaN;
        }
        TDistribution tDistribution = new TDistribution(this.n - 2L);
        return 2.0 * (1.0 - tDistribution.cumulativeProbability(FastMath.abs(this.getSlope()) / this.getSlopeStdErr()));
    }

    private double getIntercept(double d2) {
        if (this.hasIntercept) {
            return (this.sumY - d2 * this.sumX) / (double)this.n;
        }
        return 0.0;
    }

    private double getRegressionSumSquares(double d2) {
        return d2 * d2 * this.sumXX;
    }

    public RegressionResults regress() {
        if (this.hasIntercept) {
            if (this.n < 3L) {
                throw new NoDataException(LocalizedFormats.NOT_ENOUGH_DATA_REGRESSION);
            }
            if (FastMath.abs(this.sumXX) > Precision.SAFE_MIN) {
                double[] dArray = new double[]{this.getIntercept(), this.getSlope()};
                double d2 = this.getMeanSquareError();
                double d3 = this.sumYY + this.sumY * this.sumY / (double)this.n;
                double[] dArray2 = new double[]{d2 * (this.xbar * this.xbar / this.sumXX + 1.0 / (double)this.n), -this.xbar * d2 / this.sumXX, d2 / this.sumXX};
                return new RegressionResults(dArray, new double[][]{dArray2}, true, this.n, 2, this.sumY, d3, this.getSumSquaredErrors(), true, false);
            }
            double[] dArray = new double[]{this.sumY / (double)this.n, Double.NaN};
            double[] dArray3 = new double[]{this.ybar / ((double)this.n - 1.0), Double.NaN, Double.NaN};
            return new RegressionResults(dArray, new double[][]{dArray3}, true, this.n, 1, this.sumY, this.sumYY, this.getSumSquaredErrors(), true, false);
        }
        if (this.n < 2L) {
            throw new NoDataException(LocalizedFormats.NOT_ENOUGH_DATA_REGRESSION);
        }
        if (!Double.isNaN(this.sumXX)) {
            double[] dArray = new double[]{this.getMeanSquareError() / this.sumXX};
            double[] dArray4 = new double[]{this.sumXY / this.sumXX};
            return new RegressionResults(dArray4, new double[][]{dArray}, true, this.n, 1, this.sumY, this.sumYY, this.getSumSquaredErrors(), false, false);
        }
        double[] dArray = new double[]{Double.NaN};
        double[] dArray5 = new double[]{Double.NaN};
        return new RegressionResults(dArray5, new double[][]{dArray}, true, this.n, 1, Double.NaN, Double.NaN, Double.NaN, false, false);
    }

    public RegressionResults regress(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new MathIllegalArgumentException(LocalizedFormats.ARRAY_ZERO_LENGTH_OR_NULL_NOT_ALLOWED, new Object[0]);
        }
        if (nArray.length > 2 || nArray.length > 1 && !this.hasIntercept) {
            throw new ModelSpecificationException(LocalizedFormats.ARRAY_SIZE_EXCEEDS_MAX_VARIABLES, nArray.length > 1 && !this.hasIntercept ? 1 : 2);
        }
        if (this.hasIntercept) {
            if (nArray.length == 2) {
                if (nArray[0] == 1) {
                    throw new ModelSpecificationException(LocalizedFormats.NOT_INCREASING_SEQUENCE, new Object[0]);
                }
                if (nArray[0] != 0) {
                    throw new OutOfRangeException(nArray[0], (Number)0, 1);
                }
                if (nArray[1] != 1) {
                    throw new OutOfRangeException(nArray[0], (Number)0, 1);
                }
                return this.regress();
            }
            if (nArray[0] != 1 && nArray[0] != 0) {
                throw new OutOfRangeException(nArray[0], (Number)0, 1);
            }
            double d2 = this.sumY * this.sumY / (double)this.n;
            double d3 = this.sumYY + d2;
            if (nArray[0] == 0) {
                double[] dArray = new double[]{this.sumYY / (double)((this.n - 1L) * this.n)};
                double[] dArray2 = new double[]{this.ybar};
                return new RegressionResults(dArray2, new double[][]{dArray}, true, this.n, 1, this.sumY, d3 + d2, this.sumYY, true, false);
            }
            if (nArray[0] == 1) {
                double d4 = this.sumXX + this.sumX * this.sumX / (double)this.n;
                double d5 = this.sumXY + this.sumX * this.sumY / (double)this.n;
                double d6 = FastMath.max(0.0, d3 - d5 * d5 / d4);
                double d7 = d6 / (double)(this.n - 1L);
                if (!Double.isNaN(d4)) {
                    double[] dArray = new double[]{d7 / d4};
                    double[] dArray3 = new double[]{d5 / d4};
                    return new RegressionResults(dArray3, new double[][]{dArray}, true, this.n, 1, this.sumY, d3, d6, false, false);
                }
                double[] dArray = new double[]{Double.NaN};
                double[] dArray4 = new double[]{Double.NaN};
                return new RegressionResults(dArray4, new double[][]{dArray}, true, this.n, 1, Double.NaN, Double.NaN, Double.NaN, false, false);
            }
        } else {
            if (nArray[0] != 0) {
                throw new OutOfRangeException(nArray[0], (Number)0, 0);
            }
            return this.regress();
        }
        return null;
    }
}

