/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.Incrementor$1;
import org.apache.commons.math3.util.Incrementor$MaxCountExceededCallback;

public class Incrementor {
    private int maximalCount;
    private int count = 0;
    private final Incrementor$MaxCountExceededCallback maxCountCallback;

    public Incrementor() {
        this(0);
    }

    public Incrementor(int n) {
        this(n, new Incrementor$1());
    }

    public Incrementor(int n, Incrementor$MaxCountExceededCallback incrementor$MaxCountExceededCallback) {
        if (incrementor$MaxCountExceededCallback == null) {
            throw new NullArgumentException();
        }
        this.maximalCount = n;
        this.maxCountCallback = incrementor$MaxCountExceededCallback;
    }

    public final void setMaximalCount(int n) {
        this.maximalCount = n;
    }

    public final int getMaximalCount() {
        return this.maximalCount;
    }

    public final int getCount() {
        return this.count;
    }

    public final boolean canIncrement() {
        return this.count < this.maximalCount;
    }

    public final void incrementCount(int n) {
        for (int i2 = 0; i2 < n; ++i2) {
            this.incrementCount();
        }
    }

    public final void incrementCount() {
        if (++this.count > this.maximalCount) {
            this.maxCountCallback.trigger(this.maximalCount);
        }
    }

    public final void resetCount() {
        this.count = 0;
    }
}

