/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.math3.Field;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.MathArithmeticException;
import org.apache.commons.math3.exception.MathIllegalArgumentException;
import org.apache.commons.math3.exception.MathInternalError;
import org.apache.commons.math3.exception.NonMonotonicSequenceException;
import org.apache.commons.math3.exception.NotPositiveException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.util.Localizable;
import org.apache.commons.math3.exception.util.LocalizedFormats;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.MathArrays$1;
import org.apache.commons.math3.util.MathArrays$OrderDirection;
import org.apache.commons.math3.util.MathUtils;
import org.apache.commons.math3.util.Pair;
import org.apache.commons.math3.util.Precision;

public class MathArrays {
    private static final int SPLIT_FACTOR = 0x8000001;

    private MathArrays() {
    }

    public static final double[] scale(double d2, double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            dArray2[i2] = dArray[i2] * d2;
        }
        return dArray2;
    }

    public static final void scaleInPlace(double d2, double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] * d2;
        }
    }

    public static final double[] ebeAdd(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            dArray3[n] = dArray3[n] + dArray2[i2];
        }
        return dArray3;
    }

    public static final double[] ebeSubtract(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            dArray3[n] = dArray3[n] - dArray2[i2];
        }
        return dArray3;
    }

    public static final double[] ebeMultiply(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            dArray3[n] = dArray3[n] * dArray2[i2];
        }
        return dArray3;
    }

    public static final double[] ebeDivide(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new DimensionMismatchException(dArray.length, dArray2.length);
        }
        double[] dArray3 = (double[])dArray.clone();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            int n = i2;
            dArray3[n] = dArray3[n] / dArray2[i2];
        }
        return dArray3;
    }

    public static final double distance1(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 += FastMath.abs(dArray[i2] - dArray2[i2]);
        }
        return d2;
    }

    public static final int distance1(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n += FastMath.abs(nArray[i2] - nArray2[i2]);
        }
        return n;
    }

    public static final double distance(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d3 = dArray[i2] - dArray2[i2];
            d2 += d3 * d3;
        }
        return FastMath.sqrt(d2);
    }

    public static final double distance(int[] nArray, int[] nArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            double d3 = nArray[i2] - nArray2[i2];
            d2 += d3 * d3;
        }
        return FastMath.sqrt(d2);
    }

    public static final double distanceInf(double[] dArray, double[] dArray2) {
        double d2 = 0.0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            d2 = FastMath.max(d2, FastMath.abs(dArray[i2] - dArray2[i2]));
        }
        return d2;
    }

    public static final int distanceInf(int[] nArray, int[] nArray2) {
        int n = 0;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            n = FastMath.max(n, FastMath.abs(nArray[i2] - nArray2[i2]));
        }
        return n;
    }

    public static final boolean isMonotonic(Comparable[] comparableArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl) {
        Comparable comparable = comparableArray[0];
        int n = comparableArray.length;
        for (int i2 = 1; i2 < n; ++i2) {
            switch (mathArrays$OrderDirection) {
                case INCREASING: {
                    int n2 = comparable.compareTo(comparableArray[i2]);
                    if (!(bl ? n2 >= 0 : n2 > 0)) break;
                    return false;
                }
                case DECREASING: {
                    int n2 = comparableArray[i2].compareTo(comparable);
                    if (!(bl ? n2 >= 0 : n2 > 0)) break;
                    return false;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            comparable = comparableArray[i2];
        }
        return true;
    }

    public static final boolean isMonotonic(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl) {
        return MathArrays.checkOrder(dArray, mathArrays$OrderDirection, bl, false);
    }

    public static final boolean checkOrder(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl, boolean bl2) {
        int n;
        double d2 = dArray[0];
        int n2 = dArray.length;
        block4: for (n = 1; n < n2; ++n) {
            switch (mathArrays$OrderDirection) {
                case INCREASING: {
                    if (!(bl ? dArray[n] <= d2 : dArray[n] < d2)) break;
                    break block4;
                }
                case DECREASING: {
                    if (!(bl ? dArray[n] >= d2 : dArray[n] > d2)) break;
                    break block4;
                }
                default: {
                    throw new MathInternalError();
                }
            }
            d2 = dArray[n];
        }
        if (n == n2) {
            return true;
        }
        if (bl2) {
            throw new NonMonotonicSequenceException(dArray[n], (Number)d2, n, mathArrays$OrderDirection, bl);
        }
        return false;
    }

    public static final void checkOrder(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, boolean bl) {
        MathArrays.checkOrder(dArray, mathArrays$OrderDirection, bl, true);
    }

    public static final void checkOrder(double[] dArray) {
        MathArrays.checkOrder(dArray, MathArrays$OrderDirection.INCREASING, true);
    }

    public static final void checkRectangular(long[][] lArray) {
        MathUtils.checkNotNull(lArray);
        for (int i2 = 1; i2 < lArray.length; ++i2) {
            if (lArray[i2].length == lArray[0].length) continue;
            throw new DimensionMismatchException((Localizable)LocalizedFormats.DIFFERENT_ROWS_LENGTHS, lArray[i2].length, lArray[0].length);
        }
    }

    public static final void checkPositive(double[] dArray) {
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (!(dArray[i2] <= 0.0)) continue;
            throw new NotStrictlyPositiveException(dArray[i2]);
        }
    }

    public static final void checkNonNegative(long[] lArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            if (lArray[i2] >= 0L) continue;
            throw new NotPositiveException(lArray[i2]);
        }
    }

    public static final void checkNonNegative(long[][] lArray) {
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            for (int i3 = 0; i3 < lArray[i2].length; ++i3) {
                if (lArray[i2][i3] >= 0L) continue;
                throw new NotPositiveException(lArray[i2][i3]);
            }
        }
    }

    public static final double safeNorm(double[] dArray) {
        double d2 = 3.834E-20;
        double d3 = 1.304E19;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = dArray.length;
        double d10 = d3 / d9;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            double d11 = Math.abs(dArray[i2]);
            if (d11 < d2 || d11 > d10) {
                double d12;
                if (d11 > d2) {
                    if (d11 > d7) {
                        d12 = d7 / d11;
                        d4 = 1.0 + d4 * d12 * d12;
                        d7 = d11;
                        continue;
                    }
                    d12 = d11 / d7;
                    d4 += d12 * d12;
                    continue;
                }
                if (d11 > d8) {
                    d12 = d8 / d11;
                    d6 = 1.0 + d6 * d12 * d12;
                    d8 = d11;
                    continue;
                }
                if (d11 == 0.0) continue;
                d12 = d11 / d8;
                d6 += d12 * d12;
                continue;
            }
            d5 += d11 * d11;
        }
        double d13 = d4 != 0.0 ? d7 * Math.sqrt(d4 + d5 / d7 / d7) : (d5 == 0.0 ? d8 * Math.sqrt(d6) : (d5 >= d8 ? Math.sqrt(d5 * (1.0 + d8 / d5 * (d8 * d6))) : Math.sqrt(d8 * (d5 / d8 + d8 * d6))));
        return d13;
    }

    public static final void sortInPlace(double[] dArray, double[] ... dArray2) {
        MathArrays.sortInPlace(dArray, MathArrays$OrderDirection.INCREASING, dArray2);
    }

    public static final void sortInPlace(double[] dArray, MathArrays$OrderDirection mathArrays$OrderDirection, double[] ... dArray2) {
        double[] dArray3;
        if (dArray == null) {
            throw new NullArgumentException();
        }
        int n = dArray.length;
        ArrayList<Pair> arrayList = new ArrayList<Pair>(n);
        int n2 = dArray2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            double[] dArray4 = new double[n2];
            for (int i3 = 0; i3 < n2; ++i3) {
                dArray3 = dArray2[i3];
                if (dArray3 == null) {
                    throw new NullArgumentException();
                }
                if (dArray3.length != n) {
                    throw new DimensionMismatchException(dArray3.length, n);
                }
                dArray4[i3] = dArray3[i2];
            }
            arrayList.add(new Pair(dArray[i2], dArray4));
        }
        MathArrays$1 mathArrays$1 = new MathArrays$1(mathArrays$OrderDirection);
        Collections.sort(arrayList, mathArrays$1);
        for (int i4 = 0; i4 < n; ++i4) {
            Pair pair = (Pair)arrayList.get(i4);
            dArray[i4] = (Double)pair.getKey();
            dArray3 = (double[])pair.getValue();
            for (int i5 = 0; i5 < n2; ++i5) {
                dArray2[i5][i4] = dArray3[i5];
            }
        }
    }

    public static final int[] copyOf(int[] nArray) {
        return MathArrays.copyOf(nArray, nArray.length);
    }

    public static final double[] copyOf(double[] dArray) {
        return MathArrays.copyOf(dArray, dArray.length);
    }

    public static final int[] copyOf(int[] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, FastMath.min(n, nArray.length));
        return nArray2;
    }

    public static final double[] copyOf(double[] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, FastMath.min(n, dArray.length));
        return dArray2;
    }

    public static final double linearCombination(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        if (n != dArray2.length) {
            throw new DimensionMismatchException(n, dArray2.length);
        }
        double[] dArray3 = new double[n];
        double d2 = 0.0;
        for (int i2 = 0; i2 < n; ++i2) {
            double d3 = dArray[i2];
            double d4 = 1.34217729E8 * d3;
            double d5 = d4 - (d4 - d3);
            double d6 = d3 - d5;
            double d7 = dArray2[i2];
            double d8 = 1.34217729E8 * d7;
            double d9 = d8 - (d8 - d7);
            double d10 = d7 - d9;
            dArray3[i2] = d3 * d7;
            double d11 = d6 * d10 - (dArray3[i2] - d5 * d9 - d6 * d9 - d5 * d10);
            d2 += d11;
        }
        double d12 = dArray3[0];
        double d13 = dArray3[1];
        double d14 = d12 + d13;
        double d15 = d14 - d13;
        double d16 = d13 - (d14 - d15) + (d12 - d15);
        int n2 = n - 1;
        for (int i3 = 1; i3 < n2; ++i3) {
            d13 = dArray3[i3 + 1];
            double d17 = d14 + d13;
            d15 = d17 - d13;
            d16 += d13 - (d17 - d15) + (d14 - d15);
            d14 = d17;
        }
        double d18 = d14 + (d2 + d16);
        if (Double.isNaN(d18)) {
            d18 = 0.0;
            for (int i4 = 0; i4 < n; ++i4) {
                d18 += dArray[i4] * dArray2[i4];
            }
        }
        return d18;
    }

    public static final double linearCombination(double d2, double d3, double d4, double d5) {
        double d6 = d2 * d3;
        double d7 = d4 * d5;
        double d8 = d6 + d7;
        double d9 = 1.34217729E8 * d2;
        double d10 = d9 - (d9 - d2);
        double d11 = d2 - d10;
        double d12 = 1.34217729E8 * d3;
        double d13 = d12 - (d12 - d3);
        double d14 = d3 - d13;
        double d15 = d11 * d14 - (d6 - d10 * d13 - d11 * d13 - d10 * d14);
        double d16 = 1.34217729E8 * d4;
        double d17 = d16 - (d16 - d4);
        double d18 = d4 - d17;
        double d19 = 1.34217729E8 * d5;
        double d20 = d19 - (d19 - d5);
        double d21 = d5 - d20;
        double d22 = d18 * d21 - (d7 - d17 * d20 - d18 * d20 - d17 * d21);
        double d23 = d8 - d7;
        double d24 = d7 - (d8 - d23) + (d6 - d23);
        double d25 = d8 + (d15 + d22 + d24);
        if (Double.isNaN(d25)) {
            d25 = d2 * d3 + d4 * d5;
        }
        return d25;
    }

    public static final double linearCombination(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d2 * d3;
        double d9 = d4 * d5;
        double d10 = d8 + d9;
        double d11 = d6 * d7;
        double d12 = d10 + d11;
        double d13 = 1.34217729E8 * d2;
        double d14 = d13 - (d13 - d2);
        double d15 = d2 - d14;
        double d16 = 1.34217729E8 * d3;
        double d17 = d16 - (d16 - d3);
        double d18 = d3 - d17;
        double d19 = d15 * d18 - (d8 - d14 * d17 - d15 * d17 - d14 * d18);
        double d20 = 1.34217729E8 * d4;
        double d21 = d20 - (d20 - d4);
        double d22 = d4 - d21;
        double d23 = 1.34217729E8 * d5;
        double d24 = d23 - (d23 - d5);
        double d25 = d5 - d24;
        double d26 = d22 * d25 - (d9 - d21 * d24 - d22 * d24 - d21 * d25);
        double d27 = 1.34217729E8 * d6;
        double d28 = d27 - (d27 - d6);
        double d29 = d6 - d28;
        double d30 = 1.34217729E8 * d7;
        double d31 = d30 - (d30 - d7);
        double d32 = d7 - d31;
        double d33 = d29 * d32 - (d11 - d28 * d31 - d29 * d31 - d28 * d32);
        double d34 = d10 - d9;
        double d35 = d9 - (d10 - d34) + (d8 - d34);
        double d36 = d12 - d11;
        double d37 = d11 - (d12 - d36) + (d10 - d36);
        double d38 = d12 + (d19 + d26 + d33 + d35 + d37);
        if (Double.isNaN(d38)) {
            d38 = d2 * d3 + d4 * d5 + d6 * d7;
        }
        return d38;
    }

    public static final double linearCombination(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double d10 = d2 * d3;
        double d11 = d4 * d5;
        double d12 = d10 + d11;
        double d13 = d6 * d7;
        double d14 = d12 + d13;
        double d15 = d8 * d9;
        double d16 = d14 + d15;
        double d17 = 1.34217729E8 * d2;
        double d18 = d17 - (d17 - d2);
        double d19 = d2 - d18;
        double d20 = 1.34217729E8 * d3;
        double d21 = d20 - (d20 - d3);
        double d22 = d3 - d21;
        double d23 = d19 * d22 - (d10 - d18 * d21 - d19 * d21 - d18 * d22);
        double d24 = 1.34217729E8 * d4;
        double d25 = d24 - (d24 - d4);
        double d26 = d4 - d25;
        double d27 = 1.34217729E8 * d5;
        double d28 = d27 - (d27 - d5);
        double d29 = d5 - d28;
        double d30 = d26 * d29 - (d11 - d25 * d28 - d26 * d28 - d25 * d29);
        double d31 = 1.34217729E8 * d6;
        double d32 = d31 - (d31 - d6);
        double d33 = d6 - d32;
        double d34 = 1.34217729E8 * d7;
        double d35 = d34 - (d34 - d7);
        double d36 = d7 - d35;
        double d37 = d33 * d36 - (d13 - d32 * d35 - d33 * d35 - d32 * d36);
        double d38 = 1.34217729E8 * d8;
        double d39 = d38 - (d38 - d8);
        double d40 = d8 - d39;
        double d41 = 1.34217729E8 * d9;
        double d42 = d41 - (d41 - d9);
        double d43 = d9 - d42;
        double d44 = d40 * d43 - (d15 - d39 * d42 - d40 * d42 - d39 * d43);
        double d45 = d12 - d11;
        double d46 = d11 - (d12 - d45) + (d10 - d45);
        double d47 = d14 - d13;
        double d48 = d13 - (d14 - d47) + (d12 - d47);
        double d49 = d16 - d15;
        double d50 = d15 - (d16 - d49) + (d14 - d49);
        double d51 = d16 + (d23 + d30 + d37 + d44 + d46 + d48 + d50);
        if (Double.isNaN(d51)) {
            d51 = d2 * d3 + d4 * d5 + d6 * d7 + d8 * d9;
        }
        return d51;
    }

    public static final boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Precision.equals(fArray[i2], fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static final boolean equalsIncludingNaN(float[] fArray, float[] fArray2) {
        if (fArray == null || fArray2 == null) {
            return !(fArray == null ^ fArray2 == null);
        }
        if (fArray.length != fArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < fArray.length; ++i2) {
            if (Precision.equalsIncludingNaN(fArray[i2], fArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static final boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Precision.equals(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static final boolean equalsIncludingNaN(double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return !(dArray == null ^ dArray2 == null);
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Precision.equalsIncludingNaN(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static final double[] normalizeArray(double[] dArray, double d2) {
        int n;
        if (Double.isInfinite(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_INFINITE, new Object[0]);
        }
        if (Double.isNaN(d2)) {
            throw new MathIllegalArgumentException(LocalizedFormats.NORMALIZE_NAN, new Object[0]);
        }
        double d3 = 0.0;
        int n2 = dArray.length;
        double[] dArray2 = new double[n2];
        for (n = 0; n < n2; ++n) {
            if (Double.isInfinite(dArray[n])) {
                throw new MathIllegalArgumentException(LocalizedFormats.INFINITE_ARRAY_ELEMENT, dArray[n], n);
            }
            if (Double.isNaN(dArray[n])) continue;
            d3 += dArray[n];
        }
        if (d3 == 0.0) {
            throw new MathArithmeticException(LocalizedFormats.ARRAY_SUMS_TO_ZERO, new Object[0]);
        }
        for (n = 0; n < n2; ++n) {
            dArray2[n] = Double.isNaN(dArray[n]) ? Double.NaN : dArray[n] * d2 / d3;
        }
        return dArray2;
    }

    public static final Object[] buildArray(Field field, int n) {
        Object[] objectArray = (Object[])Array.newInstance(field.getRuntimeClass(), n);
        Arrays.fill(objectArray, field.getZero());
        return objectArray;
    }

    public static final Object[][] buildArray(Field field, int n, int n2) {
        Object[][] objectArray;
        if (n2 < 0) {
            Object[] objectArray2 = MathArrays.buildArray(field, 0);
            objectArray = (Object[][])Array.newInstance(objectArray2.getClass(), n);
        } else {
            objectArray = (Object[][])Array.newInstance(field.getRuntimeClass(), n, n2);
            for (int i2 = 0; i2 < n; ++i2) {
                Arrays.fill(objectArray[i2], field.getZero());
            }
        }
        return objectArray;
    }
}

