/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.QuietWriter;
import org.apache.log4j.spi.ErrorHandler;
import org.apache.log4j.spi.LoggingEvent;

public class WriterAppender
extends AppenderSkeleton {
    protected boolean immediateFlush = true;
    protected String encoding;
    protected QuietWriter qw;

    public WriterAppender() {
    }

    public WriterAppender(Layout layout, OutputStream outputStream) {
        this(layout, new OutputStreamWriter(outputStream));
    }

    public WriterAppender(Layout layout, Writer writer) {
        this.layout = layout;
        this.setWriter(writer);
    }

    public final void setImmediateFlush(boolean bl) {
        this.immediateFlush = bl;
    }

    public final boolean getImmediateFlush() {
        return this.immediateFlush;
    }

    public void activateOptions() {
    }

    public final void append(LoggingEvent loggingEvent) {
        if (!this.checkEntryConditions()) {
            return;
        }
        this.subAppend(loggingEvent);
    }

    protected final boolean checkEntryConditions() {
        if (this.closed) {
            LogLog.warn("Not allowed to write to a closed appender.");
            return false;
        }
        if (this.qw == null) {
            this.errorHandler.error("No output stream or file set for the appender named [" + this.name + "].");
            return false;
        }
        if (this.layout == null) {
            this.errorHandler.error("No layout set for the appender named [" + this.name + "].");
            return false;
        }
        return true;
    }

    public synchronized void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.writeFooter();
        this.reset();
    }

    protected void closeWriter() {
        if (this.qw != null) {
            try {
                this.qw.close();
            }
            catch (IOException iOException) {
                LogLog.error("Could not close " + this.qw, iOException);
            }
        }
    }

    protected final OutputStreamWriter createWriter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = null;
        String string = this.getEncoding();
        if (string != null) {
            try {
                outputStreamWriter = new OutputStreamWriter(outputStream, string);
            }
            catch (IOException iOException) {
                LogLog.warn("Error initializing output writer.");
                LogLog.warn("Unsupported encoding?");
            }
        }
        if (outputStreamWriter == null) {
            outputStreamWriter = new OutputStreamWriter(outputStream);
        }
        return outputStreamWriter;
    }

    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(String string) {
        this.encoding = string;
    }

    public synchronized void setErrorHandler(ErrorHandler errorHandler) {
        if (errorHandler == null) {
            LogLog.warn("You have tried to set a null error-handler.");
        } else {
            this.errorHandler = errorHandler;
            if (this.qw != null) {
                this.qw.setErrorHandler(errorHandler);
            }
        }
    }

    public final synchronized void setWriter(Writer writer) {
        this.reset();
        this.qw = new QuietWriter(writer, this.errorHandler);
        this.writeHeader();
    }

    protected final void subAppend(LoggingEvent loggingEvent) {
        String[] stringArray;
        this.qw.write(this.layout.format(loggingEvent));
        if (this.layout.ignoresThrowable() && (stringArray = loggingEvent.getThrowableStrRep()) != null) {
            int n = stringArray.length;
            for (int i2 = 0; i2 < n; ++i2) {
                this.qw.write(stringArray[i2]);
                this.qw.write(Layout.LINE_SEP);
            }
        }
        if (this.immediateFlush) {
            this.qw.flush();
        }
    }

    public boolean requiresLayout() {
        return true;
    }

    protected final void reset() {
        this.closeWriter();
        this.qw = null;
    }

    protected final void writeFooter() {
        String string;
        if (this.layout != null && (string = this.layout.getFooter()) != null && this.qw != null) {
            this.qw.write(string);
            this.qw.flush();
        }
    }

    protected final void writeHeader() {
        String string;
        if (this.layout != null && (string = this.layout.getHeader()) != null && this.qw != null) {
            this.qw.write(string);
        }
    }
}

