/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.Writer;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.Visitor;
import org.dom4j.tree.AbstractNode;
import org.dom4j.tree.DefaultAttribute;

public abstract class AbstractAttribute
extends AbstractNode
implements Attribute {
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String asXML() {
        return String.valueOf(this.getQualifiedName()) + "=\"" + this.getValue() + "\"";
    }

    protected final Node createXPathResult(Element element) {
        return new DefaultAttribute(element, this.getQName(), this.getValue());
    }

    public Object getData() {
        return this.getValue();
    }

    public String getName() {
        return this.getQName().getName();
    }

    public Namespace getNamespace() {
        return this.getQName().getNamespace();
    }

    public String getNamespacePrefix() {
        return this.getQName().getNamespacePrefix();
    }

    public String getNamespaceURI() {
        return this.getQName().getNamespaceURI();
    }

    public short getNodeType() {
        return 2;
    }

    public String getPath(Element element) {
        Element element2 = this.getParent();
        return element2 != null && element2 != element ? String.valueOf(element2.getPath(element)) + "/@" + this.getName() : "@" + this.getName();
    }

    public abstract QName getQName();

    public String getQualifiedName() {
        return this.getQName().getQualifiedName();
    }

    public String getText() {
        return this.getValue();
    }

    public String getUniquePath(Element element) {
        Element element2 = this.getParent();
        return element2 != null && element2 != element ? String.valueOf(element2.getUniquePath(element)) + "/@" + this.getName() : "@" + this.getName();
    }

    public abstract String getValue();

    public void setData(Object object) {
        this.setValue(object == null ? null : object.toString());
    }

    public void setNamespace(Namespace namespace) {
        throw new UnsupportedOperationException("This Attribute is read only and cannot be changed");
    }

    public void setText(String string) {
        this.setValue(string);
    }

    public void setValue(String string) {
        throw new UnsupportedOperationException("This Attribute is read only and cannot be changed");
    }

    public final String toString() {
        return String.valueOf(super.toString()) + " [Attribute: name " + this.getQualifiedName() + " value \"" + this.getValue() + "\"]";
    }

    public void write(Writer writer) {
        writer.write(this.getQualifiedName());
        writer.write("=\"");
        writer.write(this.getValue());
        writer.write("\"");
    }
}

