/*
 * Decompiled with CFR 0.152.
 */
package org.dom4j.tree;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Comment;
import org.dom4j.Document;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.IllegalAddException;
import org.dom4j.Node;
import org.dom4j.ProcessingInstruction;
import org.dom4j.QName;
import org.dom4j.Text;
import org.dom4j.Visitor;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.AbstractBranch;
import org.xml.sax.EntityResolver;

public abstract class AbstractDocument
extends AbstractBranch
implements Document {
    public void accept(Visitor visitor) {
        List list;
        visitor.visit(this);
        DocumentType documentType = this.getDocType();
        if (documentType != null) {
            visitor.visit(documentType);
        }
        if ((list = this.content()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Node node;
                Object e2 = iterator.next();
                if (e2 instanceof String) {
                    node = this.getDocumentFactory().createText((String)e2);
                    visitor.visit((Text)node);
                    continue;
                }
                node = (Node)e2;
                node.accept(visitor);
            }
        }
    }

    public void add(Element element) {
        this.checkAddElementAllowed();
        super.add(element);
        this.rootElementAdded(element);
    }

    public Document addComment(String string) {
        Comment comment = this.getDocumentFactory().createComment(string);
        this.add(comment);
        return this;
    }

    public abstract Document addDocType(String var1, String var2, String var3);

    public Element addElement(String string) {
        this.checkAddElementAllowed();
        Element element = super.addElement(string);
        this.rootElementAdded(element);
        return element;
    }

    public Element addElement(String string, String string2) {
        this.checkAddElementAllowed();
        Element element = super.addElement(string, string2);
        this.rootElementAdded(element);
        return element;
    }

    public Element addElement(QName qName) {
        this.checkAddElementAllowed();
        Element element = super.addElement(qName);
        this.rootElementAdded(element);
        return element;
    }

    public Document addProcessingInstruction(String string, String string2) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, string2);
        this.add(processingInstruction);
        return this;
    }

    public Document addProcessingInstruction(String string, Map map) {
        ProcessingInstruction processingInstruction = this.getDocumentFactory().createProcessingInstruction(string, map);
        this.add(processingInstruction);
        return this;
    }

    public String asXML() {
        try {
            StringWriter stringWriter = new StringWriter();
            XMLWriter xMLWriter = new XMLWriter(stringWriter, AbstractBranch.outputFormat);
            xMLWriter.write(this);
            return stringWriter.toString();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Wierd IOException while generating textual representation: " + iOException.getMessage());
        }
    }

    public Node asXPathResult(Element element) {
        return this;
    }

    protected final void checkAddElementAllowed() {
        Element element = this.getRootElement();
        if (element != null) {
            throw new IllegalAddException(this, (Node)element, "Cannot add another element to this Document as it already has  a root element of: " + element.getQualifiedName());
        }
    }

    protected final void childAdded(Node node) {
        if (node != null) {
            node.setDocument(this);
        }
    }

    protected final void childRemoved(Node node) {
        if (node != null) {
            node.setDocument(null);
        }
    }

    public abstract DocumentType getDocType();

    public Document getDocument() {
        return this;
    }

    public abstract EntityResolver getEntityResolver();

    public short getNodeType() {
        return 9;
    }

    public String getPath(Element element) {
        return "/";
    }

    public abstract Element getRootElement();

    public String getStringValue() {
        Element element = this.getRootElement();
        return element != null ? element.getStringValue() : "";
    }

    public String getUniquePath(Element element) {
        return "/";
    }

    public void normalize() {
        Element element = this.getRootElement();
        if (element != null) {
            element.normalize();
        }
    }

    public boolean remove(Element element) {
        boolean bl = super.remove(element);
        Element element2 = this.getRootElement();
        if (element2 != null && bl) {
            this.setRootElement(null);
        }
        element.setDocument(null);
        return bl;
    }

    protected abstract void rootElementAdded(Element var1);

    public abstract void setDocType(DocumentType var1);

    public abstract void setEntityResolver(EntityResolver var1);

    public void setRootElement(Element element) {
        this.clearContent();
        if (element != null) {
            super.add(element);
            this.rootElementAdded(element);
        }
    }

    public final String toString() {
        return String.valueOf(super.toString()) + " [Document: name " + this.getName() + "]";
    }

    public void write(Writer writer) {
        XMLWriter xMLWriter = new XMLWriter(writer, AbstractBranch.outputFormat);
        xMLWriter.write(this);
    }
}

