/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.objects.RankedList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.genepattern.gsea.GeneHistogram$1;
import org.genepattern.gsea.GeneHistogram$2;
import org.genepattern.gsea.GeneHistogram$3;
import org.genepattern.gsea.HistogramDataset;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.RectangleEdge;

public class GeneHistogram
extends JPanel {
    private JFreeChart geneHistChart = ChartFactory.createHistogram("", "Gene", "Number Of Gene Sets", null, PlotOrientation.VERTICAL, false, false, false);
    private RankedList featureFrequency;
    private int selectedGeneIndex = -1;
    private ChartPanel geneHistPanel;
    private RankedList scores;

    public GeneHistogram() {
        this.geneHistChart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        GeneHistogram$1 geneHistogram$1 = new GeneHistogram$1(this);
        this.geneHistChart.getXYPlot().setRenderer(geneHistogram$1);
        this.geneHistPanel = new GeneHistogram$2(this, this.geneHistChart, false, false, false, false, false);
        ToolTipManager.sharedInstance().registerComponent(this.geneHistPanel);
        GeneHistogram$3 geneHistogram$3 = new GeneHistogram$3(this);
        this.geneHistPanel.addChartMouseListener(geneHistogram$3);
        this.geneHistPanel.setMouseZoomable(true, false);
        this.setLayout(new BorderLayout());
        this.add((Component)this.geneHistPanel, "Center");
    }

    public final ChartPanel getChartPanel() {
        return this.geneHistPanel;
    }

    public final void addChartMouseListener(ChartMouseListener chartMouseListener) {
        this.geneHistPanel.addChartMouseListener(chartMouseListener);
    }

    public final String getGeneName(int n) {
        return this.featureFrequency.getRankName(n);
    }

    public final int getXIndex(int n, int n2) {
        Point point = new Point(n, n2);
        XYPlot xYPlot = (XYPlot)this.geneHistChart.getPlot();
        Rectangle2D rectangle2D = this.geneHistPanel.getScreenDataArea();
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        ValueAxis valueAxis2 = xYPlot.getRangeAxis();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d2 = valueAxis.java2DToValue(point.getX(), rectangle2D, rectangleEdge);
        double d3 = valueAxis2.java2DToValue(point.getY(), rectangle2D, rectangleEdge2);
        int n3 = (int)Math.round(d2);
        if (n3 < 0) {
            n3 = 0;
        } else if (n3 >= this.featureFrequency.getSize()) {
            n3 = this.featureFrequency.getSize() - 1;
        }
        if (d3 <= (double)this.featureFrequency.getScore(n3)) {
            return n3;
        }
        return -1;
    }

    private final void updateGeneHist() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Histogram"));
        HistogramDataset histogramDataset = new HistogramDataset(0.0);
        histogramDataset.addSeries(xYSeries);
        for (int i2 = 0; i2 < this.featureFrequency.getSize(); ++i2) {
            double d2 = this.featureFrequency.getScore(i2);
            xYSeries.add((double)i2, d2);
        }
        SymbolAxis symbolAxis = new SymbolAxis("Gene", this.featureFrequency.getRankedNamesArray());
        symbolAxis.setVerticalTickLabels(true);
        this.geneHistChart.getXYPlot().setDomainAxis(symbolAxis);
        this.geneHistChart.getXYPlot().setDataset(histogramDataset);
    }

    public final RankedList getFeatureFrequency() {
        return this.featureFrequency;
    }

    public final void setFeatureFrequency(RankedList rankedList, RankedList rankedList2) {
        this.featureFrequency = rankedList;
        this.scores = rankedList2;
        this.updateGeneHist();
    }

    static final /* synthetic */ int access$000(GeneHistogram geneHistogram) {
        return geneHistogram.selectedGeneIndex;
    }

    static final /* synthetic */ RankedList access$100(GeneHistogram geneHistogram) {
        return geneHistogram.scores;
    }

    static final /* synthetic */ RankedList access$200(GeneHistogram geneHistogram) {
        return geneHistogram.featureFrequency;
    }

    static final /* synthetic */ int access$002(GeneHistogram geneHistogram, int n) {
        geneHistogram.selectedGeneIndex = n;
        return geneHistogram.selectedGeneIndex;
    }
}

