/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.alg.AlgUtils;
import edu.mit.broad.genome.objects.GeneSet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.text.NumberFormat;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.IExpressionDataUtil;
import org.genepattern.gsea.GeneSetSimilarityPanel$1;
import org.genepattern.gsea.GeneSetSimilarityPanel$2;
import org.genepattern.heatmap.GradientColorScheme;
import org.genepattern.heatmap.HeatMapComponent;

public class GeneSetSimilarityPanel {
    HeatMapComponent heatMap;
    JPanel legend;
    private static final int JACQUARD = 0;
    private static final int HYPER_GEOM = 1;
    private static final int SIM = 2;
    private int similarityMeasure = 0;
    private NumberFormat numberFormat = NumberFormat.getNumberInstance();
    private GeneSet[] geneSets;

    public GeneSetSimilarityPanel(Frame frame) {
        this.numberFormat.setMaximumFractionDigits(4);
        GradientColorScheme gradientColorScheme = new GradientColorScheme(0.0, 1.0, 0.5, Color.GREEN, Color.RED, Color.WHITE);
        gradientColorScheme.setUseDoubleGradient(false);
        this.legend = (JPanel)gradientColorScheme.getLegend();
        this.heatMap = new HeatMapComponent(frame, IExpressionDataUtil.createRandomData(1, 1), null, null, this.legend);
        this.heatMap.getHeatMapPanel().setUpperTriangular(true);
        this.heatMap.getHeatMapPanel().setToolTipProvider(new GeneSetSimilarityPanel$1(this));
        this.heatMap.setFeatureUIString("Gene Set");
        this.heatMap.setSampleUIString("Gene Set");
        this.heatMap.setShowFeatureAnnotator(false);
        this.heatMap.setShowSampleAnnotator(false);
        this.heatMap.setShowColorSchemeOptions(false);
        this.heatMap.setShowRowDescriptions(false);
        this.heatMap.setRowSize(12);
        this.heatMap.setColumnSize(12);
        this.heatMap.setColorConverter(gradientColorScheme);
        this.heatMap.setShowFeatureTableHeader(false);
        this.heatMap.getHeatMapPanel().addPropertyChangeListener("columnSize", new GeneSetSimilarityPanel$2(this));
    }

    public final void setGeneSets(GeneSet[] geneSetArray) {
        this.geneSets = geneSetArray;
        double[][] dArray = new double[geneSetArray.length][geneSetArray.length];
        String[] stringArray = new String[geneSetArray.length];
        for (int i2 = 0; i2 < geneSetArray.length; ++i2) {
            stringArray[i2] = geneSetArray[i2].getName(true);
            for (int i3 = i2; i3 < geneSetArray.length; ++i3) {
                double d2;
                int n = AlgUtils.intersectSize(geneSetArray[i2], geneSetArray[i3]);
                int n2 = AlgUtils.unionAllCount(new GeneSet[]{geneSetArray[i2], geneSetArray[i3]});
                int n3 = geneSetArray[i2].getNumMembers();
                int n4 = geneSetArray[i3].getNumMembers();
                if (this.similarityMeasure == 0) {
                    dArray[i2][i3] = d2 = (double)n / (double)n2;
                    continue;
                }
                if (this.similarityMeasure == 1) {
                    int n5 = n2;
                    int n6 = n3;
                    int n7 = n4;
                    int n8 = n;
                    continue;
                }
                if (this.similarityMeasure != 2) continue;
                dArray[i2][i3] = d2 = Math.sqrt(n / geneSetArray[i2].getNumMembers() * (n / geneSetArray[i3].getNumMembers()));
            }
        }
        DoubleMatrix2D doubleMatrix2D = new DoubleMatrix2D(dArray, stringArray, stringArray);
        ExpressionData expressionData = new ExpressionData(doubleMatrix2D, null, null);
        this.heatMap.setExpressionData(expressionData);
        Dimension dimension = this.legend.getPreferredSize();
        dimension.width = this.heatMap.getExpressionData().getColumnCount() * this.heatMap.getHeatMapPanel().getColumnSize();
        this.legend.setPreferredSize(dimension);
    }

    public final HeatMapComponent getHeatMapComponent() {
        return this.heatMap;
    }

    public final JMenuBar getMenuBar() {
        this.heatMap.setOptionsDialogOptions(false, false, false);
        return this.heatMap.createMenuBar(false, false, false, false);
    }

    static final /* synthetic */ NumberFormat access$000(GeneSetSimilarityPanel geneSetSimilarityPanel) {
        return geneSetSimilarityPanel.numberFormat;
    }

    static final /* synthetic */ GeneSet[] access$100(GeneSetSimilarityPanel geneSetSimilarityPanel) {
        return geneSetSimilarityPanel.geneSets;
    }
}

