/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import gnu.trove.TFloatIntHashMap;
import gnu.trove.TFloatIntIterator;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntIntIterator;
import gnu.trove.TPrimitiveIterator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.genepattern.gsea.HistogramDataset;
import org.genepattern.gsea.JacquardHistogram$1;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYSeries;

public class JacquardHistogram
extends JPanel {
    private double binWidth = 0.02;
    private JFreeChart jacquardChart;
    private TFloatIntHashMap jacquardToOccurrencesMap;
    private ChartPanel chartPanel;

    public JacquardHistogram() {
        this.setLayout(new BorderLayout());
        this.jacquardChart = ChartFactory.createHistogram("", "Jacquard", "Number of Occurences", null, PlotOrientation.VERTICAL, false, true, false);
        this.chartPanel = new ChartPanel(this.jacquardChart, false, false, false, false, false);
        this.jacquardChart.getXYPlot().getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ((NumberAxis)this.jacquardChart.getXYPlot().getDomainAxis()).setAutoRangeIncludesZero(true);
        this.chartPanel.setMouseZoomable(true, false);
        this.add(this.chartPanel);
        JLabel jLabel = new JLabel("Bin Width:");
        JTextField jTextField = new JTextField("" + this.binWidth, 4);
        JButton jButton = new JButton("Update");
        jButton.addActionListener(new JacquardHistogram$1(this, jTextField));
        JPanel jPanel = new JPanel();
        jPanel.add(jLabel);
        jPanel.add(jTextField);
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
    }

    final void updateJacquardHistogram() {
        if (this.binWidth != 0.0) {
            int n;
            TIntIntHashMap tIntIntHashMap = new TIntIntHashMap();
            XYSeries xYSeries = new XYSeries((Comparable)((Object)""));
            HistogramDataset histogramDataset = new HistogramDataset(this.binWidth);
            histogramDataset.setIntervalWidth(0.0);
            histogramDataset.addSeries(xYSeries);
            TPrimitiveIterator tPrimitiveIterator = this.jacquardToOccurrencesMap.iterator();
            while (tPrimitiveIterator.hasNext()) {
                ((TFloatIntIterator)tPrimitiveIterator).advance();
                float f2 = ((TFloatIntIterator)tPrimitiveIterator).key();
                n = ((TFloatIntIterator)tPrimitiveIterator).value();
                int n2 = (int)((double)f2 / this.binWidth);
                int n3 = tIntIntHashMap.get(n2);
                tIntIntHashMap.put(n2, n + n3);
            }
            tPrimitiveIterator = tIntIntHashMap.iterator();
            while (tPrimitiveIterator.hasNext()) {
                ((TIntIntIterator)tPrimitiveIterator).advance();
                int n4 = ((TIntIntIterator)tPrimitiveIterator).key();
                n = ((TIntIntIterator)tPrimitiveIterator).value();
                double d2 = (double)n4 * this.binWidth;
                xYSeries.add(d2, n);
            }
            this.jacquardChart.getXYPlot().setDataset(histogramDataset);
        }
    }

    public final double getBinWidth() {
        return this.binWidth;
    }

    public final void setBinWidth(double d2) {
        this.binWidth = d2;
        this.updateJacquardHistogram();
    }

    public final void setJacquardToOccurrencesMap(TFloatIntHashMap tFloatIntHashMap) {
        this.jacquardToOccurrencesMap = tFloatIntHashMap;
        this.updateJacquardHistogram();
    }

    public final TFloatIntHashMap getJacquardToOccurrencesMap() {
        return this.jacquardToOccurrencesMap;
    }

    public final ChartPanel getChartPanel() {
        return this.chartPanel;
    }

    static final /* synthetic */ ChartPanel access$000(JacquardHistogram jacquardHistogram) {
        return jacquardHistogram.chartPanel;
    }

    static final /* synthetic */ double access$102(JacquardHistogram jacquardHistogram, double d2) {
        jacquardHistogram.binWidth = d2;
        return jacquardHistogram.binWidth;
    }
}

