/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import edu.mit.broad.genome.alg.ComparatorFactory$EnrichmentResultByNESComparator;
import edu.mit.broad.genome.alg.gsea.PValueCalculatorImpls$GseaImpl;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentResult;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentScore;
import edu.mit.broad.genome.reports.EnrichmentReports;
import javax.swing.table.AbstractTableModel;

class LeadingEdgeWidget$MyTableModel
extends AbstractTableModel {
    String[] columnNames = new String[]{"Gene Set", "Size", "ES", "NES", "NOM p-val", "FDR q-val", "FWER p-val", "Rank at Max", "Leading Edge"};
    Class[] columnClasses = new Class[]{String.class, Integer.class, Float.class, Float.class, Float.class, Float.class, Float.class, Integer.class, String.class};
    EnrichmentResult[] ers;

    public LeadingEdgeWidget$MyTableModel(EnrichmentDb enrichmentDb) {
        String string = "meandiv";
        PValueCalculatorImpls$GseaImpl pValueCalculatorImpls$GseaImpl = new PValueCalculatorImpls$GseaImpl(string);
        EnrichmentResult[] enrichmentResultArray = pValueCalculatorImpls$GseaImpl.calcNPValuesAndFDR(enrichmentDb.getResults());
        EnrichmentDb enrichmentDb2 = enrichmentDb.cloneDeep(enrichmentResultArray);
        this.ers = enrichmentDb2.getResults(new ComparatorFactory$EnrichmentResultByNESComparator(Order.DESCENDING));
    }

    @Override
    public final int getRowCount() {
        return this.ers.length;
    }

    @Override
    public final int getColumnCount() {
        return this.columnNames.length;
    }

    public final Class getColumnClass(int n) {
        return this.columnClasses[n];
    }

    @Override
    public final String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public final Object getValueAt(int n, int n2) {
        GeneSet geneSet = this.ers[n].getGeneSet();
        EnrichmentScore enrichmentScore = this.ers[n].getScore();
        switch (n2) {
            case 0: {
                return geneSet.getName(true);
            }
            case 1: {
                return new Integer(geneSet.getNumMembers());
            }
            case 2: {
                return new Float(enrichmentScore.getES());
            }
            case 3: {
                return new Float(enrichmentScore.getNES());
            }
            case 4: {
                return new Float(enrichmentScore.getNP());
            }
            case 5: {
                return new Float(enrichmentScore.getFDR());
            }
            case 6: {
                return new Float(enrichmentScore.getFWER());
            }
            case 7: {
                return new Integer(this.ers[n].getSignal().getRankAtMax());
            }
            case 8: {
                return EnrichmentReports.getLeadingEdge(this.ers[n]);
            }
        }
        return null;
    }
}

