/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.gsea;

import com.jidesoft.grid.QuickFilterPane;
import com.jidesoft.grid.QuickTableFilterField;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.SortableTableModel;
import com.jidesoft.swing.JideScrollPane;
import com.jidesoft.swing.JideTitledBorder;
import com.jidesoft.swing.PartialEtchedBorder;
import edu.mit.broad.genome.swing.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import org.genepattern.gsea.ViewAndSearchComponent$1;
import org.genepattern.gsea.ViewAndSearchComponent$2;
import org.genepattern.gsea.ViewAndSearchComponent$3;
import org.genepattern.gsea.ViewAndSearchComponent$ControlPanel;
import org.genepattern.gsea.ViewAndSearchComponent$TableSelectionListener;

public class ViewAndSearchComponent
extends JPanel {
    private SortableTable sortableTable;
    private QuickFilterPane quickFilterPane = new QuickFilterPane();
    private QuickTableFilterField filterField;
    private int numberOfGeneSets;
    private JLabel filteredLabel;
    private ViewAndSearchComponent$ControlPanel controlPanel;

    public final void setTableModel(TableModel tableModel) {
        this.numberOfGeneSets = tableModel.getRowCount();
        SwingUtilities.invokeLater(new ViewAndSearchComponent$1(this, tableModel));
        this.quickFilterPane.setTableModel(new SortableTableModel(tableModel));
        this.filterField.setTableModel(this.quickFilterPane.getDisplayTableModel());
        this.sortableTable.setModel(this.filterField.getDisplayTableModel());
        this.filterField.getDisplayTableModel().addTableModelListener(new ViewAndSearchComponent$2(this));
    }

    public ViewAndSearchComponent(String string, int[] nArray, ActionListener actionListener) {
        this(string, nArray, actionListener, true);
    }

    public ViewAndSearchComponent(String string, int[] nArray, ActionListener actionListener, boolean bl) {
        this(string, nArray, actionListener, bl, null);
    }

    public ViewAndSearchComponent(String string, int[] nArray, ActionListener actionListener, boolean bl, JPanel jPanel) {
        this.quickFilterPane.setColumnIndices(nArray);
        JPanel jPanel2 = new JPanel(new FlowLayout(3));
        this.filterField = new QuickTableFilterField();
        jPanel2.add(this.filterField);
        jPanel2.setBorder(new JideTitledBorder(new PartialEtchedBorder(1, 1), "Filter Gene Sets", 4, 1));
        this.filteredLabel = new JLabel("   ");
        this.filteredLabel.setHorizontalAlignment(0);
        this.filteredLabel.setForeground(GuiHelper.COLOR_DARK_GREEN);
        this.filteredLabel.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.sortableTable = new ViewAndSearchComponent$3(this);
        this.sortableTable.setShowSortOrderNumber(false);
        this.sortableTable.getSelectionModel().setSelectionMode(2);
        this.filterField.setTable(this.sortableTable);
        JideScrollPane jideScrollPane = new JideScrollPane(this.sortableTable, 22, 30);
        jPanel2.add(this.filteredLabel);
        JPanel jPanel3 = new JPanel(new BorderLayout());
        if (jPanel != null) {
            jPanel3.add((Component)jPanel, "North");
        }
        jPanel3.add((Component)jPanel2, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)jideScrollPane, "Center");
        this.add((Component)jPanel3, "North");
        if (bl) {
            this.controlPanel = new ViewAndSearchComponent$ControlPanel(string, actionListener, this.sortableTable);
            this.add((Component)this.controlPanel, "South");
        }
    }

    public final ViewAndSearchComponent$TableSelectionListener getTableSelectionListener() {
        return ViewAndSearchComponent$ControlPanel.access$300(this.controlPanel);
    }

    public final String[] getSelectedColumnArray(int n) {
        int[] nArray = this.sortableTable.getSelectedRows();
        String[] stringArray = new String[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringArray[i2] = this.sortableTable.getModel().getValueAt(nArray[i2], n).toString();
        }
        return stringArray;
    }

    public final SortableTable getTable() {
        return this.sortableTable;
    }

    public final JPanel getButtonPanel() {
        return this.controlPanel;
    }

    static final /* synthetic */ int access$000(ViewAndSearchComponent viewAndSearchComponent) {
        return viewAndSearchComponent.numberOfGeneSets;
    }

    static final /* synthetic */ JLabel access$100(ViewAndSearchComponent viewAndSearchComponent) {
        return viewAndSearchComponent.filteredLabel;
    }
}

