/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.heatmap;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

class GradientColorScheme$Legend
extends JPanel {
    private Insets insets;
    private int height = 15;
    BufferedImage negColorImage;
    BufferedImage posColorImage;
    boolean isAntiAliasing;
    private boolean useDoubleGradient = true;
    private double minValue;
    private double midValue;
    private double maxValue;

    public GradientColorScheme$Legend(double d2, double d3, double d4, BufferedImage bufferedImage, BufferedImage bufferedImage2, boolean bl) {
        this.minValue = d2;
        this.midValue = d3;
        this.maxValue = d4;
        this.negColorImage = bufferedImage;
        this.posColorImage = bufferedImage2;
        this.setBackground(Color.white);
        this.insets = new Insets(0, 0, 0, 0);
        this.setPreferredSize(new Dimension(120, 40));
        this.useDoubleGradient = bl;
    }

    public final void setUseDoubleGradient(boolean bl) {
        this.useDoubleGradient = bl;
    }

    private void setFontSize(int n) {
        if (n > 12) {
            n = 12;
        }
        this.setFont(new Font("monospaced", 0, n));
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        if (this.useDoubleGradient) {
            graphics2D.drawImage(this.negColorImage, this.insets.left, 0, (int)((float)n / 2.0f), this.height, null);
            graphics2D.drawImage(this.posColorImage, (int)((float)n / 2.0f) + this.insets.left, 0, (int)((double)n / 2.0), this.height, null);
        } else {
            graphics2D.drawImage(this.posColorImage, this.insets.left, 0, n, this.height, null);
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        graphics2D.setColor(Color.black);
        if (this.isAntiAliasing) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        graphics2D.drawString(String.valueOf(this.minValue), this.insets.left, this.height + n2);
        int n3 = fontMetrics.stringWidth(String.valueOf(this.midValue));
        if (this.useDoubleGradient) {
            graphics2D.drawString(String.valueOf(this.midValue), (int)((float)n / 2.0f) - n3 / 2 + this.insets.left, this.height + n2);
        }
        n3 = fontMetrics.stringWidth(String.valueOf(this.maxValue));
        graphics2D.drawString(String.valueOf(this.maxValue), n - n3 + this.insets.left, this.height + n2);
    }
}

