/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io;

import com.sun.media.jai.codec.BMPEncodeParam;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.PNGEncodeParam$RGB;
import com.sun.media.jai.codec.TIFFEncodeParam;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.JAI;

public class ImageUtil {
    private ImageUtil() {
    }

    public static final void saveImage(BufferedImage bufferedImage, String string, String string2) {
        if (string2.equals("jpeg")) {
            if (!string.toLowerCase().endsWith(".jpg") && !string.toLowerCase().endsWith(".jpeg")) {
                string = string + ".jpg";
            }
        } else if (string2.equals("png")) {
            if (!string.toLowerCase().endsWith(".png")) {
                string = string + ".png";
            }
        } else if (string2.equals("tiff")) {
            if (!string.toLowerCase().endsWith(".tiff")) {
                string = string + ".tiff";
            }
        } else if (string2.equals("bmp")) {
            if (!string.toLowerCase().endsWith(".bmp")) {
                string = string + ".bmp";
            }
        } else {
            throw new IllegalArgumentException("Unknown output file format");
        }
        ImageEncodeParam imageEncodeParam = null;
        if (string2.equals("jpeg")) {
            JPEGEncodeParam jPEGEncodeParam = new JPEGEncodeParam();
            jPEGEncodeParam.setQuality(1.0f);
            imageEncodeParam = jPEGEncodeParam;
        } else if (string2.equals("png")) {
            imageEncodeParam = new PNGEncodeParam$RGB();
        } else if (string2.equals("tiff")) {
            TIFFEncodeParam tIFFEncodeParam = new TIFFEncodeParam();
            tIFFEncodeParam.setCompression(1);
            imageEncodeParam = tIFFEncodeParam;
        } else if (string2.equals("bmp")) {
            imageEncodeParam = new BMPEncodeParam();
        } else {
            throw new IllegalArgumentException("Unknown output file format");
        }
        JAI.create("filestore", (RenderedImage)bufferedImage, (Object)string, (Object)string2, (Object)imageEncodeParam);
    }
}

