/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.gct;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.io.expr.IExpressionDataWriter;

public class GctWriter
implements IExpressionDataWriter {
    static final String FORMAT_NAME = "gct";

    @Override
    public final String checkFileExtension(String string) {
        if (!string.toLowerCase().endsWith(".gct")) {
            string = string + ".gct";
        }
        return string;
    }

    @Override
    public final void write(IExpressionData iExpressionData, OutputStream outputStream) {
        int n;
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n2 = iExpressionData.getRowCount();
        int n3 = iExpressionData.getColumnCount();
        String string = "#1.2";
        printWriter.print(string);
        printWriter.print("\n");
        printWriter.print(n2 + "\t" + n3);
        printWriter.print("\n");
        printWriter.print("Name");
        printWriter.print("\t");
        printWriter.print("Description");
        for (n = 0; n < n3; ++n) {
            printWriter.print("\t");
            printWriter.print(iExpressionData.getColumnName(n));
        }
        for (n = 0; n < n2; ++n) {
            printWriter.print("\n");
            printWriter.print(iExpressionData.getRowName(n));
            printWriter.print("\t");
            String string2 = iExpressionData.getRowMetadata(n, "description");
            if (string2 == null) {
                string2 = "";
            }
            printWriter.print(string2);
            for (int i2 = 0; i2 < n3; ++i2) {
                printWriter.print("\t");
                printWriter.print(iExpressionData.getValueAsString(n, i2));
            }
        }
        printWriter.print("\n");
        printWriter.flush();
    }

    @Override
    public final String getFormatName() {
        return FORMAT_NAME;
    }
}

