/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.res;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.IExpressionDataHandler;
import org.genepattern.io.expr.IExpressionDataParser;

public class ResParser
implements IExpressionDataParser {
    IExpressionDataHandler handler;
    int rows;
    int columns;
    static final String DESCRIPTION = "Description";
    static final String ACCESSION = "Accession";
    LineNumberReader reader;
    boolean verifyCalls = true;

    @Override
    public final boolean canDecode(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        try {
            this.readHeader();
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    @Override
    public final void parse(InputStream inputStream) {
        this.reader = new LineNumberReader(new BufferedReader(new InputStreamReader(inputStream)));
        this.readHeader();
        this.readData();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readData() {
        int n = 2 * this.columns + 2;
        int n2 = 0;
        String string = this.reader.readLine();
        while (true) {
            block19: {
                int n3;
                String[] stringArray;
                block20: {
                    block17: {
                        block18: {
                            if (string == null) break block17;
                            if (n2 < this.rows) break block18;
                            if (!string.trim().equals("")) {
                                int n4 = n2 + 1;
                                throw new ParseException("More data rows than expected on line " + this.reader.getLineNumber() + ". Read " + n4 + ", expected " + this.rows + ".");
                            }
                            --n2;
                            break block19;
                        }
                        stringArray = string.split("\t");
                        if (stringArray.length != n) {
                            throw new ParseException(stringArray.length + this.getColumnString(stringArray.length) + " on line " + this.reader.getLineNumber() + ". Expected " + n + ".");
                        }
                        if (this.handler != null) {
                            this.handler.rowMetaData(n2, 0, stringArray[0]);
                        }
                        String string2 = stringArray[1];
                        if (this.handler != null) {
                            this.handler.rowName(n2, string2);
                        }
                        n3 = 2;
                        break block20;
                    }
                    if (n2 != this.rows) {
                        throw new ParseException("Missing data rows. Read " + n2 + " " + this.getRowString(n2) + ", expected " + this.rows);
                    }
                    return;
                }
                for (int i2 = 0; i2 < this.columns; ++i2, n3 += 2) {
                    String string3;
                    try {
                        double d2 = Double.parseDouble(stringArray[n3]);
                        if (this.handler != null) {
                            this.handler.data(n2, i2, d2);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Data at line number " + this.reader.getLineNumber() + " and column " + i2 + " is not a number.");
                    }
                    String string4 = string3 = stringArray[n3 + 1];
                    if ("P".equals(string3)) {
                        string4 = "P";
                    } else if ("A".equals(string3)) {
                        string4 = "A";
                    } else if ("M".equals(string3)) {
                        string4 = "M";
                    } else if (this.verifyCalls) {
                        throw new ParseException("Unknown call, " + string3 + ", on line " + this.reader.getLineNumber());
                    }
                    if (this.handler == null) continue;
                    this.handler.data(n2, i2, 0, string4);
                }
            }
            string = this.reader.readLine();
            ++n2;
        }
    }

    private void readHeader() {
        int n;
        int n2;
        int n3;
        Object object;
        Object[] objectArray;
        Object object2;
        String string = this.reader.readLine();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null && string.length() > 0) {
            object2 = string.split("\t");
            if (object2 == null || ((String[])object2).length == 0 || ((String[])object2).length == 1) {
                throw new ParseException("Unable to parse line 1");
            }
            objectArray = object2[0];
            if (!DESCRIPTION.equalsIgnoreCase((String)objectArray)) {
                // empty if block
            }
            if (!ACCESSION.equalsIgnoreCase((String)(object = object2[1]))) {
                // empty if block
            }
            n3 = 2;
            n2 = 1;
            n = ((String[])object2).length;
            while (n3 < n) {
                String string2 = object2[n3].trim();
                arrayList.add(string2);
                n3 += 2;
                ++n2;
            }
            if (n3 - 1 != ((String[])object2).length) {
                for (n2 = n3 - 2; n2 < ((String[])object2).length; ++n2) {
                    arrayList.add(object2[n2]);
                }
                throw new ParseException("Line 1 does not contain the correct number of tabs. Column names: " + arrayList);
            }
        } else {
            throw new ParseException("Missing column names on line " + this.reader.getLineNumber());
        }
        this.columns = arrayList.size();
        if (this.columns == 0) {
            throw new ParseException("Number of columns must be greater than 0.");
        }
        object2 = this.reader.readLine();
        objectArray = new String[this.columns];
        if (object2 != null && ((String)object2).length() > 0) {
            object = ((String)object2).split("\t");
            if (((Object)object).length != (n3 = this.columns * 2)) {
                n2 = (int)Math.ceil((double)((Object)object).length / 2.0);
            }
            n2 = 0;
            int n4 = Math.min(n3, ((Object)object).length);
            for (n = 1; n < n4; n += 2) {
                objectArray[n2++] = ((String)object[n]).trim();
            }
            if (n2 < this.columns) {
                for (n = n2; n < this.columns; ++n) {
                    objectArray[n] = "";
                }
            }
        } else {
            Arrays.fill(objectArray, "");
        }
        object = this.reader.readLine();
        if (object != null && ((String)object).trim().length() > 0) {
            try {
                this.rows = Integer.parseInt(((String)object).trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("Number of rows missing.");
            }
        } else {
            throw new ParseException("Number of rows missing.");
        }
        if (this.rows <= 0) {
            throw new ParseException("Number of rows must be greater than 0.");
        }
        if (this.handler != null) {
            this.handler.init(this.rows, this.columns, new String[]{"description"}, new String[]{"description"}, new String[]{"calls"});
        }
        if (this.handler != null) {
            for (n3 = 0; n3 < this.columns; ++n3) {
                this.handler.columnName(n3, (String)arrayList.get(n3));
            }
        }
        if (this.handler != null) {
            for (n3 = 0; n3 < this.columns; ++n3) {
                this.handler.columnMetaData(n3, 0, (String)objectArray[n3]);
            }
        }
    }

    @Override
    public final void setHandler(IExpressionDataHandler iExpressionDataHandler) {
        this.handler = iExpressionDataHandler;
    }

    private String getRowString(int n) {
        if (n == 1) {
            return "row";
        }
        return "rows";
    }

    private String getColumnString(int n) {
        if (n == 1) {
            return "column";
        }
        return "columns";
    }

    @Override
    public final String getFormatName() {
        return "res";
    }

    @Override
    public final List getFileSuffixes() {
        return Collections.unmodifiableList(Arrays.asList("res"));
    }
}

