/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.io.expr.snp;

import java.io.OutputStream;
import java.io.PrintWriter;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.io.expr.IExpressionDataWriter;

public class SnpWriter
implements IExpressionDataWriter {
    static final String FORMAT_NAME = "snp";

    @Override
    public final String checkFileExtension(String string) {
        if (!string.toLowerCase().endsWith(".snp")) {
            string = string + ".snp";
        }
        return string;
    }

    @Override
    public final void write(IExpressionData iExpressionData, OutputStream outputStream) {
        int n;
        PrintWriter printWriter = new PrintWriter(outputStream);
        int n2 = iExpressionData.getRowCount();
        int n3 = iExpressionData.getColumnCount();
        printWriter.print("SNP\tChromosome\tPhysicalPosition");
        for (n = 0; n < n3; ++n) {
            printWriter.print("\t");
            printWriter.print(iExpressionData.getColumnName(n));
            printWriter.print("\t");
            printWriter.print(iExpressionData.getColumnName(n) + " Call");
        }
        printWriter.println();
        for (n = 0; n < n2; ++n) {
            printWriter.print(iExpressionData.getRowName(n));
            printWriter.print("\t");
            String string = iExpressionData.getRowMetadata(n, "Chromosome");
            if (string == null) {
                string = "";
            }
            printWriter.print(string);
            printWriter.print("\t");
            String string2 = iExpressionData.getRowMetadata(n, "PhysicalPosition");
            if (string2 == null) {
                string2 = "";
            }
            printWriter.print(string2);
            for (int i2 = 0; i2 < n3; ++i2) {
                printWriter.print("\t");
                printWriter.print(iExpressionData.getValueAsString(n, i2));
                printWriter.print("\t");
                Object object = iExpressionData.getData(n, i2, "calls");
                printWriter.print(object != null ? object : "");
            }
            printWriter.println();
        }
        printWriter.flush();
    }

    @Override
    public final String getFormatName() {
        return FORMAT_NAME;
    }
}

