/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu;

import java.awt.Frame;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.genepattern.menu.PlotAction;

public abstract class AbstractPlotMenu
extends JMenu {
    protected JComponent plot;
    protected PlotAction[] plotActions;
    protected Frame parent;

    protected abstract PlotAction[] createPlotActions();

    public AbstractPlotMenu(String string, JComponent jComponent, Frame frame) {
        super(string);
        this.parent = frame;
        this.plotActions = this.createPlotActions();
        this.setPlot(jComponent);
        for (PlotAction plotAction : this.plotActions) {
            JMenuItem[] jMenuItemArray = plotAction.getSubMenuItems();
            if (jMenuItemArray == null) {
                this.add(plotAction);
                continue;
            }
            JMenu jMenu = new JMenu(plotAction);
            for (int i2 = 0; i2 < jMenuItemArray.length; ++i2) {
                jMenu.add(jMenuItemArray[i2]);
            }
            this.add(jMenu);
        }
    }

    public final Frame getFrame() {
        return this.parent;
    }

    public final void setPlot(JComponent jComponent) {
        this.plot = jComponent;
        int n = this.plotActions.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.plotActions[i2].setPlot(jComponent);
            this.plotActions[i2].setEnabled(jComponent != null);
        }
    }
}

