/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.menu;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import org.genepattern.menu.AbstractSaveImageAction$1;
import org.genepattern.menu.AbstractSaveImageAction$2;
import org.genepattern.menu.AbstractSaveImageAction$MyFileFilter;
import org.genepattern.menu.PlotAction;
import org.genepattern.uiutil.FileChooser;
import org.genepattern.uiutil.UIUtil;

public abstract class AbstractSaveImageAction
extends PlotAction {
    Frame parent;

    public AbstractSaveImageAction(Frame frame) {
        if (frame == null) {
            throw new NullPointerException("Null parent not allowed");
        }
        this.putValue("Name", "Save Image");
        this.parent = frame;
    }

    protected abstract BufferedImage createImage();

    @Override
    public final void actionPerformed(ActionEvent actionEvent) {
        try {
            if (!FileChooser.RUNNING_ON_MAC) {
                this.saveImage();
            }
        }
        catch (Exception exception) {
            this.showError(exception, "An error occurred while saving the plot.");
        }
    }

    @Override
    public final JMenuItem[] getSubMenuItems() {
        if (!FileChooser.RUNNING_ON_MAC) {
            return null;
        }
        JMenuItem jMenuItem = new JMenuItem("bmp...");
        JMenuItem jMenuItem2 = new JMenuItem("jpeg...");
        JMenuItem jMenuItem3 = new JMenuItem("png...");
        JMenuItem jMenuItem4 = new JMenuItem("tiff...");
        AbstractSaveImageAction$1 abstractSaveImageAction$1 = new AbstractSaveImageAction$1(this, jMenuItem, jMenuItem2, jMenuItem3, jMenuItem4);
        jMenuItem.addActionListener(abstractSaveImageAction$1);
        jMenuItem2.addActionListener(abstractSaveImageAction$1);
        jMenuItem3.addActionListener(abstractSaveImageAction$1);
        jMenuItem4.addActionListener(abstractSaveImageAction$1);
        return new JMenuItem[]{jMenuItem, jMenuItem2, jMenuItem3, jMenuItem4};
    }

    private final void saveImage() {
        if (Double.parseDouble(System.getProperty("java.specification.version")) < 1.4) {
            UIUtil.showMessageDialog(this.getPlot().getTopLevelAncestor(), "Java 1.4 is required to save an image.");
            return;
        }
        File file = null;
        String string = null;
        if (!FileChooser.RUNNING_ON_MAC) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(new AbstractSaveImageAction$MyFileFilter(new String[]{"bmp"}, "BMP image", "BMP"));
            jFileChooser.addChoosableFileFilter(new AbstractSaveImageAction$MyFileFilter(new String[]{"jpeg", "jpg"}, "JPEG image", "JPEG"));
            jFileChooser.addChoosableFileFilter(new AbstractSaveImageAction$MyFileFilter(new String[]{"png"}, "PNG image", "PNG"));
            jFileChooser.addChoosableFileFilter(new AbstractSaveImageAction$MyFileFilter(new String[]{"tiff"}, "TIFF image", "TIFF"));
            if (jFileChooser.showSaveDialog(this.getPlot().getTopLevelAncestor()) == 0) {
                file = jFileChooser.getSelectedFile();
                string = ((AbstractSaveImageAction$MyFileFilter)jFileChooser.getFileFilter()).getFileFormat();
                file = this.createFileWithCorrectExtension(file, string);
                if (!FileChooser.overwriteFile(this.getPlot().getTopLevelAncestor(), file)) {
                    return;
                }
            }
        }
        if (file != null) {
            this.save(file, string);
        }
    }

    private File createFileWithCorrectExtension(File file, String string) {
        String string2 = file.getName();
        String string3 = "";
        int n = string2.lastIndexOf(".");
        if (n > 0) {
            string3 = string2.substring(n, string2.length());
            string2 = string2.substring(0, n);
        }
        if (string.equalsIgnoreCase("jpeg")) {
            if (!string3.equalsIgnoreCase(".jpg") && !string3.equalsIgnoreCase(".jpeg")) {
                string3 = string3 + ".jpeg";
            }
        } else if (string.equalsIgnoreCase("png")) {
            if (!string3.equalsIgnoreCase(".png")) {
                string3 = string3 + ".png";
            }
        } else if (string.equalsIgnoreCase("tiff")) {
            if (!string3.equalsIgnoreCase(".tiff")) {
                string3 = string3 + ".tiff";
            }
        } else if (string.equalsIgnoreCase("bmp") && !string3.equalsIgnoreCase(".bmp")) {
            string3 = string3 + ".bmp";
        }
        return new File(file.getParent(), string2 + string3);
    }

    private void save(File file, String string) {
        File file2 = file;
        new AbstractSaveImageAction$2(this, string, file2).start();
    }

    private void showError(Exception exception, String string) {
        if (exception.getMessage() != null) {
            string = string + "\nCause: " + exception.getMessage();
        }
        UIUtil.showErrorDialog(this.getPlot().getTopLevelAncestor(), string);
    }

    static final /* synthetic */ void access$000(AbstractSaveImageAction abstractSaveImageAction, File file, String string) {
        abstractSaveImageAction.save(file, string);
    }
}

