/*
 * Decompiled with CFR 0.152.
 */
package org.genepattern.module;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.genepattern.data.expr.ExpressionData;
import org.genepattern.data.expr.IExpressionData;
import org.genepattern.data.matrix.ClassVector;
import org.genepattern.data.matrix.DoubleMatrix2D;
import org.genepattern.data.matrix.IClassVector;
import org.genepattern.io.IOUtil;
import org.genepattern.io.IOdfHandler;
import org.genepattern.io.ParseException;
import org.genepattern.io.expr.ExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataCreator;
import org.genepattern.io.expr.IExpressionDataParser;
import org.genepattern.io.expr.IExpressionDataWriter;
import org.genepattern.io.expr.ReaderUtil;
import org.genepattern.io.expr.odf.OdfDatasetWriter;

public class AnalysisUtil {
    private AnalysisUtil() {
    }

    public static final void exit(String string, Throwable throwable) {
        String string2 = throwable.getMessage();
        if (string2 != null) {
            string = string + "\nCause: " + string2;
        }
        AnalysisUtil.exit(string);
    }

    public static final void exit(String string) {
        System.err.println(string);
        System.exit(1);
    }

    public static final ClassVector readClassVector(String string) {
        try {
            return IOUtil.readCls(string);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileReadError(null, string);
        }
        catch (ParseException parseException) {
            AnalysisUtil.fileReadError(parseException, string);
        }
        return null;
    }

    public static final List readFeatureList(String string) {
        try {
            return IOUtil.readFeatureList(string);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileReadError(null, string);
            return null;
        }
    }

    public static final void writeFeatureList(String[] stringArray, String string) {
        try {
            IOUtil.writeFeatureList(stringArray, string);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileReadError(iOException, string);
        }
    }

    public static final Object readExpressionData(IExpressionDataParser iExpressionDataParser, String string, IExpressionDataCreator iExpressionDataCreator) {
        try {
            return ReaderUtil.read(iExpressionDataParser, string, iExpressionDataCreator);
        }
        catch (ParseException parseException) {
            AnalysisUtil.fileReadError(parseException, string);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileReadError(null, string);
        }
        return null;
    }

    public static final ExpressionData readExpressionData(IExpressionDataParser iExpressionDataParser, String string) {
        return (ExpressionData)AnalysisUtil.readExpressionData(iExpressionDataParser, string, new ExpressionDataCreator());
    }

    public static final ExpressionData readExpressionData(String string) {
        return (ExpressionData)AnalysisUtil.readExpressionData(AnalysisUtil.getExpressionReader(string), string, new ExpressionDataCreator());
    }

    public static final void checkDimensions(DoubleMatrix2D doubleMatrix2D, IClassVector iClassVector) {
        if (iClassVector.size() != doubleMatrix2D.getColumnCount()) {
            AnalysisUtil.exit("Number of columns in dataset(" + doubleMatrix2D.getColumnCount() + ") does not match the number of class assignments(" + iClassVector.size() + ").");
        }
    }

    public static final void checkDimensions(IExpressionData iExpressionData, IClassVector iClassVector) {
        if (iClassVector.size() != iExpressionData.getColumnCount()) {
            AnalysisUtil.exit("Number of columns in dataset(" + iExpressionData.getColumnCount() + ") does not match the number of class assignments(" + iClassVector.size() + ").");
        }
    }

    public static final void readOdf(String string, IOdfHandler iOdfHandler) {
        try {
            IOUtil.readOdf(string, iOdfHandler);
        }
        catch (ParseException parseException) {
            AnalysisUtil.fileReadError(parseException, string);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileReadError(null, string);
        }
    }

    public static final String writeCls(IClassVector iClassVector, String string, boolean bl) {
        try {
            return IOUtil.writeCls(iClassVector, string, bl);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileSaveError(iOException, string);
            return null;
        }
    }

    public static final String write(IExpressionData iExpressionData, String string, String string2, boolean bl) {
        try {
            return IOUtil.write(iExpressionData, string, string2, bl);
        }
        catch (IOException iOException) {
            AnalysisUtil.fileSaveError(iOException, string2);
            return null;
        }
    }

    private static void fileReadError(Exception exception, String string) {
        String string2;
        String string3 = "An error occured while reading the file " + AnalysisUtil.getFileName(string) + ".";
        String string4 = string2 = exception != null ? exception.getMessage() : null;
        if (string2 != null) {
            string3 = string3 + "\nCause: " + string2;
        }
        AnalysisUtil.exit(string3);
    }

    private static void fileSaveError(Exception exception, String string) {
        String string2 = "An error occured while attempting to save the file " + AnalysisUtil.getFileName(string) + ".";
        String string3 = exception.getMessage();
        if (string3 != null) {
            string2 = string2 + "\nCause: " + string3;
        }
        AnalysisUtil.exit(string2);
    }

    public static final IExpressionDataParser getExpressionReader(String string) {
        return AnalysisUtil.getExpressionDataParser(string);
    }

    public static final IExpressionDataParser getExpressionDataParser(String string) {
        IExpressionDataParser iExpressionDataParser = IOUtil.getExpressionParser(string);
        if (iExpressionDataParser == null) {
            AnalysisUtil.exit("Invalid input type: " + AnalysisUtil.getFileName(string) + " is not a res, gct, or odf dataset file.");
        }
        return iExpressionDataParser;
    }

    public static final String getFileName(String string) {
        String string2 = new File(string).getName();
        return string2.replaceFirst("Axis[0-9]*axis_", "");
    }

    static {
        IExpressionDataWriter iExpressionDataWriter = IOUtil.getExpressionWriterByFormatName("odf");
        if (iExpressionDataWriter instanceof OdfDatasetWriter) {
            ((OdfDatasetWriter)iExpressionDataWriter).setPrependExecutionLog(true);
        }
    }
}

