/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jaxen.Context;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.PredicateSet;
import org.jaxen.expr.Predicated;

public class DefaultFilterExpr
extends DefaultExpr
implements FilterExpr,
Predicated {
    private Expr expr;
    private PredicateSet predicates;

    public DefaultFilterExpr() {
        this.predicates = new PredicateSet();
    }

    public DefaultFilterExpr(Expr expr) {
        this.expr = expr;
        this.predicates = new PredicateSet();
    }

    public final void addPredicate(Predicate predicate) {
        this.predicates.addPredicate(predicate);
    }

    public final boolean asBoolean(Context context) {
        Serializable serializable;
        ArrayList arrayList = null;
        if (this.expr != null) {
            arrayList = this.expr.evaluate(context);
        } else {
            serializable = new ArrayList(1);
            ((ArrayList)serializable).addAll(context.getNodeSet());
            arrayList = serializable;
        }
        if (arrayList instanceof Boolean) {
            serializable = (Boolean)((Object)arrayList);
            return (Boolean)serializable;
        }
        if (arrayList instanceof List) {
            return this.getPredicateSet().evaluateAsBoolean(arrayList, context.getContextSupport());
        }
        return false;
    }

    public final Object evaluate(Context context) {
        Object object = this.getExpr().evaluate(context);
        if (object instanceof List) {
            List list = this.getPredicateSet().evaluatePredicates((List)object, context.getContextSupport());
            object = list;
        }
        return object;
    }

    public final Expr getExpr() {
        return this.expr;
    }

    public final PredicateSet getPredicateSet() {
        return this.predicates;
    }

    public final List getPredicates() {
        return this.predicates.getPredicates();
    }

    public final String getText() {
        String string = "";
        if (this.expr != null) {
            string = this.expr.getText();
        }
        string = String.valueOf(string) + this.predicates.getText();
        return string;
    }

    public final Expr simplify() {
        this.predicates.simplify();
        if (this.expr != null) {
            this.expr = this.expr.simplify();
        }
        if (this.predicates.getPredicates().size() == 0) {
            return this.getExpr();
        }
        return this;
    }

    public final String toString() {
        return "[(DefaultFilterExpr): expr: " + this.expr + " predicates: " + this.predicates + " ]";
    }
}

