/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jfree.base.BootableProjectInfo;
import org.jfree.base.Library;
import org.jfree.base.config.HierarchicalConfiguration;
import org.jfree.base.config.PropertyFileConfiguration;
import org.jfree.base.config.SystemPropertyConfiguration;
import org.jfree.base.modules.PackageManager;
import org.jfree.base.modules.SubSystem;
import org.jfree.util.Configuration;
import org.jfree.util.ExtendedConfiguration;
import org.jfree.util.ExtendedConfigurationWrapper;
import org.jfree.util.Log;
import org.jfree.util.ObjectUtilities;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    protected AbstractBoot() {
    }

    protected final Configuration createDefaultHierarchicalConfiguration(String string, String string2, boolean bl) {
        Object object;
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
        if (string != null) {
            object = new PropertyFileConfiguration();
            ((PropertyFileConfiguration)object).load(string);
            hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
            hierarchicalConfiguration.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (string2 != null) {
            object = string2.startsWith("/") ? string2.substring(1) : string2;
            try {
                PropertyFileConfiguration propertyFileConfiguration;
                Enumeration<URL> enumeration = ObjectUtilities.getClassLoader(this.getClass()).getResources((String)object);
                ArrayList<PropertyFileConfiguration> arrayList = new ArrayList<PropertyFileConfiguration>();
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    try {
                        propertyFileConfiguration = new PropertyFileConfiguration();
                        InputStream inputStream = uRL.openStream();
                        propertyFileConfiguration.load(inputStream);
                        inputStream.close();
                        arrayList.add(propertyFileConfiguration);
                    }
                    catch (IOException iOException) {
                        Log.warn("Failed to load the user configuration at " + uRL, iOException);
                    }
                }
                int n = arrayList.size() - 1;
                while (n >= 0) {
                    propertyFileConfiguration = (PropertyFileConfiguration)arrayList.get(n);
                    hierarchicalConfiguration.insertConfiguration(propertyFileConfiguration);
                    --n;
                }
            }
            catch (IOException iOException) {
                Log.warn("Failed to lookup the user configurations.", iOException);
            }
        }
        object = new SystemPropertyConfiguration();
        hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
        return hierarchicalConfiguration;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    protected abstract BootableProjectInfo getProjectInfo();

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    protected final AbstractBoot loadBooter(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            Method method = clazz.getMethod("getInstance", null);
            return (AbstractBoot)method.invoke(null, null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + string);
            return null;
        }
    }

    protected abstract Configuration loadConfiguration();

    protected abstract void performBoot();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void start() {
        Object object = this;
        synchronized (object) {
            if (this.isBootDone()) {
                return;
            }
            while (true) {
                if (!this.isBootInProgress()) {
                    this.bootInProgress = true;
                    break;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        object = this.getProjectInfo();
        if (object != null) {
            BootableProjectInfo[] bootableProjectInfoArray = ((BootableProjectInfo)object).getDependencies();
            int n = 0;
            while (n < bootableProjectInfoArray.length) {
                AbstractBoot abstractBoot = this.loadBooter(bootableProjectInfoArray[n].getBootClass());
                if (abstractBoot != null) {
                    AbstractBoot abstractBoot2 = abstractBoot;
                    synchronized (abstractBoot2) {
                        abstractBoot.start();
                        while (!abstractBoot.isBootDone()) {
                            try {
                                abstractBoot.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                }
                ++n;
            }
        }
        this.performBoot();
        if (object != null) {
            Log.info(String.valueOf(((Library)object).getName()) + " " + ((Library)object).getVersion() + " started.");
        } else {
            Log.info(String.valueOf(String.valueOf(this.getClass())) + " started.");
        }
        AbstractBoot abstractBoot = this;
        synchronized (abstractBoot) {
            this.bootInProgress = false;
            this.bootDone = true;
            this.notifyAll();
            return;
        }
    }
}

