/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.text.NumberFormat;
import org.jfree.chart.axis.TickUnit;

public class NumberTickUnit
extends TickUnit
implements Serializable {
    private static final long serialVersionUID = 3849459506627654442L;
    private NumberFormat formatter;

    public NumberTickUnit(double d2) {
        this(d2, NumberFormat.getNumberInstance());
    }

    public NumberTickUnit(double d2, NumberFormat numberFormat) {
        super(d2);
        if (numberFormat == null) {
            throw new IllegalArgumentException("Null 'formatter' argument.");
        }
        this.formatter = numberFormat;
    }

    public String valueToString(double d2) {
        return this.formatter.format(d2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NumberTickUnit)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        NumberTickUnit numberTickUnit = (NumberTickUnit)object;
        return this.formatter.equals(numberTickUnit.formatter);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.formatter != null ? this.formatter.hashCode() : 0);
        return n;
    }
}

