/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.io.Serializable;
import java.util.Date;
import org.jfree.chart.axis.SegmentedTimeline;

public class SegmentedTimeline$Segment
implements Comparable,
Cloneable,
Serializable {
    protected long segmentNumber;
    protected long segmentStart;
    protected long segmentEnd;
    protected long millisecond;
    private final SegmentedTimeline this$0;

    protected SegmentedTimeline$Segment(SegmentedTimeline segmentedTimeline) {
        this.this$0 = segmentedTimeline;
    }

    protected SegmentedTimeline$Segment(SegmentedTimeline segmentedTimeline, long l2) {
        this.this$0 = segmentedTimeline;
        this.segmentNumber = this.calculateSegmentNumber(l2);
        this.segmentStart = SegmentedTimeline.access$000(segmentedTimeline) + this.segmentNumber * SegmentedTimeline.access$100(segmentedTimeline);
        this.segmentEnd = this.segmentStart + SegmentedTimeline.access$100(segmentedTimeline) - 1L;
        this.millisecond = l2;
    }

    public long calculateSegmentNumber(long l2) {
        if (l2 >= SegmentedTimeline.access$000(this.this$0)) {
            return (l2 - SegmentedTimeline.access$000(this.this$0)) / SegmentedTimeline.access$100(this.this$0);
        }
        return (l2 - SegmentedTimeline.access$000(this.this$0)) / SegmentedTimeline.access$100(this.this$0) - 1L;
    }

    public long getSegmentNumber() {
        return this.segmentNumber;
    }

    public long getSegmentCount() {
        return 1L;
    }

    public long getSegmentStart() {
        return this.segmentStart;
    }

    public long getSegmentEnd() {
        return this.segmentEnd;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public Date getDate() {
        return this.this$0.getDate(this.millisecond);
    }

    public boolean contains(long l2) {
        return this.segmentStart <= l2 && l2 <= this.segmentEnd;
    }

    public boolean contains(long l2, long l3) {
        return this.segmentStart <= l2 && l3 <= this.segmentEnd;
    }

    public boolean contains(SegmentedTimeline$Segment segmentedTimeline$Segment) {
        return this.contains(segmentedTimeline$Segment.getSegmentStart(), segmentedTimeline$Segment.getSegmentEnd());
    }

    public boolean contained(long l2, long l3) {
        return l2 <= this.segmentStart && this.segmentEnd <= l3;
    }

    public SegmentedTimeline$Segment intersect(long l2, long l3) {
        if (l2 <= this.segmentStart && this.segmentEnd <= l3) {
            return this;
        }
        return null;
    }

    public boolean before(SegmentedTimeline$Segment segmentedTimeline$Segment) {
        return this.segmentEnd < segmentedTimeline$Segment.getSegmentStart();
    }

    public boolean after(SegmentedTimeline$Segment segmentedTimeline$Segment) {
        return this.segmentStart > segmentedTimeline$Segment.getSegmentEnd();
    }

    public boolean equals(Object object) {
        if (object instanceof SegmentedTimeline$Segment) {
            SegmentedTimeline$Segment segmentedTimeline$Segment = (SegmentedTimeline$Segment)object;
            return this.segmentNumber == segmentedTimeline$Segment.getSegmentNumber() && this.segmentStart == segmentedTimeline$Segment.getSegmentStart() && this.segmentEnd == segmentedTimeline$Segment.getSegmentEnd() && this.millisecond == segmentedTimeline$Segment.getMillisecond();
        }
        return false;
    }

    public SegmentedTimeline$Segment copy() {
        try {
            return (SegmentedTimeline$Segment)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compareTo(Object object) {
        SegmentedTimeline$Segment segmentedTimeline$Segment = (SegmentedTimeline$Segment)object;
        if (this.before(segmentedTimeline$Segment)) {
            return -1;
        }
        if (this.after(segmentedTimeline$Segment)) {
            return 1;
        }
        return 0;
    }

    public boolean inIncludeSegments() {
        if (this.getSegmentNumberRelativeToGroup() < (long)SegmentedTimeline.access$200(this.this$0)) {
            return !this.inExceptionSegments();
        }
        return false;
    }

    public boolean inExcludeSegments() {
        return this.getSegmentNumberRelativeToGroup() >= (long)SegmentedTimeline.access$200(this.this$0);
    }

    private long getSegmentNumberRelativeToGroup() {
        long l2 = this.segmentNumber % (long)SegmentedTimeline.access$300(this.this$0);
        if (l2 < 0L) {
            l2 += (long)SegmentedTimeline.access$300(this.this$0);
        }
        return l2;
    }

    public boolean inExceptionSegments() {
        return SegmentedTimeline.access$400(this.this$0, this) >= 0;
    }

    public void inc(long l2) {
        this.segmentNumber += l2;
        long l3 = l2 * SegmentedTimeline.access$100(this.this$0);
        this.segmentStart += l3;
        this.segmentEnd += l3;
        this.millisecond += l3;
    }

    public void inc() {
        this.inc(1L);
    }

    public void dec(long l2) {
        this.segmentNumber -= l2;
        long l3 = l2 * SegmentedTimeline.access$100(this.this$0);
        this.segmentStart -= l3;
        this.segmentEnd -= l3;
        this.millisecond -= l3;
    }

    public void dec() {
        this.dec(1L);
    }

    public void moveIndexToStart() {
        this.millisecond = this.segmentStart;
    }

    public void moveIndexToEnd() {
        this.millisecond = this.segmentEnd;
    }
}

