/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.editor;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jfree.chart.LegendItemSource;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.ColorBar;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.editor.DefaultAxisEditor;
import org.jfree.chart.editor.DefaultColorBarEditor;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.ContourPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.layout.LCBLayout;
import org.jfree.ui.PaintSample;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.StrokeChooserPanel;
import org.jfree.ui.StrokeSample;
import org.jfree.util.BooleanUtilities;

class DefaultPlotEditor
extends JPanel
implements ActionListener {
    private static final String[] orientationNames = new String[]{"Vertical", "Horizontal"};
    private static final int ORIENTATION_VERTICAL = 0;
    private static final int ORIENTATION_HORIZONTAL = 1;
    private PaintSample backgroundPaintSample;
    private StrokeSample outlineStrokeSample;
    private PaintSample outlinePaintSample;
    private DefaultAxisEditor domainAxisPropertyPanel;
    private DefaultAxisEditor rangeAxisPropertyPanel;
    private DefaultColorBarEditor colorBarAxisPropertyPanel;
    private StrokeSample[] availableStrokeSamples;
    private RectangleInsets plotInsets;
    private PlotOrientation plotOrientation;
    private JComboBox orientationCombo;
    private Boolean drawLines;
    private JCheckBox drawLinesCheckBox;
    private Boolean drawShapes;
    private JCheckBox drawShapesCheckBox;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.editor.LocalizationBundle");

    public DefaultPlotEditor(Plot plot) {
        Serializable serializable;
        Object object;
        this.plotInsets = plot.getInsets();
        this.backgroundPaintSample = new PaintSample(plot.getBackgroundPaint());
        this.outlineStrokeSample = new StrokeSample(plot.getOutlineStroke());
        this.outlinePaintSample = new PaintSample(plot.getOutlinePaint());
        if (plot instanceof CategoryPlot) {
            this.plotOrientation = ((CategoryPlot)plot).getOrientation();
        } else if (plot instanceof XYPlot) {
            this.plotOrientation = ((XYPlot)plot).getOrientation();
        }
        if (plot instanceof CategoryPlot) {
            object = ((CategoryPlot)plot).getRenderer();
            if (object instanceof LineAndShapeRenderer) {
                serializable = (LineAndShapeRenderer)object;
                this.drawLines = BooleanUtilities.valueOf(((LineAndShapeRenderer)serializable).getBaseLinesVisible());
                this.drawShapes = BooleanUtilities.valueOf(((LineAndShapeRenderer)serializable).getBaseShapesVisible());
            }
        } else if (plot instanceof XYPlot && (object = ((XYPlot)plot).getRenderer()) instanceof StandardXYItemRenderer) {
            serializable = (StandardXYItemRenderer)object;
            this.drawLines = BooleanUtilities.valueOf(((StandardXYItemRenderer)serializable).getPlotLines());
            this.drawShapes = BooleanUtilities.valueOf(((StandardXYItemRenderer)serializable).getBaseShapesVisible());
        }
        this.setLayout(new BorderLayout());
        this.availableStrokeSamples = new StrokeSample[3];
        this.availableStrokeSamples[0] = new StrokeSample(new BasicStroke(1.0f));
        this.availableStrokeSamples[1] = new StrokeSample(new BasicStroke(2.0f));
        this.availableStrokeSamples[2] = new StrokeSample(new BasicStroke(3.0f));
        object = new JPanel(new BorderLayout());
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), plot.getPlotType() + localizationResources.getString(":")));
        serializable = new JPanel(new BorderLayout());
        ((JComponent)serializable).setBorder(BorderFactory.createTitledBorder(localizationResources.getString("General")));
        JPanel jPanel = new JPanel(new LCBLayout(7));
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel.add(new JLabel(localizationResources.getString("Outline_stroke")));
        JButton jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("OutlineStroke");
        jButton.addActionListener(this);
        jPanel.add(this.outlineStrokeSample);
        jPanel.add(jButton);
        jPanel.add(new JLabel(localizationResources.getString("Outline_Paint")));
        jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("OutlinePaint");
        jButton.addActionListener(this);
        jPanel.add(this.outlinePaintSample);
        jPanel.add(jButton);
        jPanel.add(new JLabel(localizationResources.getString("Background_paint")));
        jButton = new JButton(localizationResources.getString("Select..."));
        jButton.setActionCommand("BackgroundPaint");
        jButton.addActionListener(this);
        jPanel.add(this.backgroundPaintSample);
        jPanel.add(jButton);
        if (this.plotOrientation != null) {
            boolean bl = this.plotOrientation.equals(PlotOrientation.VERTICAL);
            int n = bl ? 0 : 1;
            jPanel.add(new JLabel(localizationResources.getString("Orientation")));
            this.orientationCombo = new JComboBox<String>(orientationNames);
            this.orientationCombo.setSelectedIndex(n);
            this.orientationCombo.setActionCommand("Orientation");
            this.orientationCombo.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.orientationCombo);
        }
        if (this.drawLines != null) {
            jPanel.add(new JLabel(localizationResources.getString("Draw_lines")));
            this.drawLinesCheckBox = new JCheckBox();
            this.drawLinesCheckBox.setSelected(this.drawLines);
            this.drawLinesCheckBox.setActionCommand("DrawLines");
            this.drawLinesCheckBox.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.drawLinesCheckBox);
        }
        if (this.drawShapes != null) {
            jPanel.add(new JLabel(localizationResources.getString("Draw_shapes")));
            this.drawShapesCheckBox = new JCheckBox();
            this.drawShapesCheckBox.setSelected(this.drawShapes);
            this.drawShapesCheckBox.setActionCommand("DrawShapes");
            this.drawShapesCheckBox.addActionListener(this);
            jPanel.add(new JPanel());
            jPanel.add(this.drawShapesCheckBox);
        }
        ((Container)serializable).add(jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        jPanel2.add((Component)serializable, "North");
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Axis axis = null;
        if (plot instanceof CategoryPlot) {
            axis = ((CategoryPlot)plot).getDomainAxis();
        } else if (plot instanceof XYPlot) {
            axis = ((XYPlot)plot).getDomainAxis();
        }
        this.domainAxisPropertyPanel = DefaultAxisEditor.getInstance(axis);
        if (this.domainAxisPropertyPanel != null) {
            this.domainAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add(localizationResources.getString("Domain_Axis"), this.domainAxisPropertyPanel);
        }
        ValueAxis valueAxis = null;
        if (plot instanceof CategoryPlot) {
            valueAxis = ((CategoryPlot)plot).getRangeAxis();
        } else if (plot instanceof XYPlot) {
            valueAxis = ((XYPlot)plot).getRangeAxis();
        }
        this.rangeAxisPropertyPanel = DefaultAxisEditor.getInstance(valueAxis);
        if (this.rangeAxisPropertyPanel != null) {
            this.rangeAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add(localizationResources.getString("Range_Axis"), this.rangeAxisPropertyPanel);
        }
        ColorBar colorBar = null;
        if (plot instanceof ContourPlot) {
            colorBar = ((ContourPlot)plot).getColorBar();
        }
        this.colorBarAxisPropertyPanel = DefaultColorBarEditor.getInstance(colorBar);
        if (this.colorBarAxisPropertyPanel != null) {
            this.colorBarAxisPropertyPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            jTabbedPane.add(localizationResources.getString("Color_Bar"), this.colorBarAxisPropertyPanel);
        }
        jTabbedPane.add(localizationResources.getString("Appearance"), jPanel2);
        ((Container)object).add(jTabbedPane);
        this.add((Component)object);
    }

    public final RectangleInsets getPlotInsets() {
        if (this.plotInsets == null) {
            this.plotInsets = new RectangleInsets(0.0, 0.0, 0.0, 0.0);
        }
        return this.plotInsets;
    }

    public final Paint getBackgroundPaint() {
        return this.backgroundPaintSample.getPaint();
    }

    public final Stroke getOutlineStroke() {
        return this.outlineStrokeSample.getStroke();
    }

    public final Paint getOutlinePaint() {
        return this.outlinePaintSample.getPaint();
    }

    public final DefaultAxisEditor getDomainAxisPropertyEditPanel() {
        return this.domainAxisPropertyPanel;
    }

    public final DefaultAxisEditor getRangeAxisPropertyEditPanel() {
        return this.rangeAxisPropertyPanel;
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("BackgroundPaint")) {
            this.attemptBackgroundPaintSelection();
        } else if (string.equals("OutlineStroke")) {
            this.attemptOutlineStrokeSelection();
        } else if (string.equals("OutlinePaint")) {
            this.attemptOutlinePaintSelection();
        } else if (string.equals("Orientation")) {
            this.attemptOrientationSelection();
        } else if (string.equals("DrawLines")) {
            this.attemptDrawLinesSelection();
        } else if (string.equals("DrawShapes")) {
            this.attemptDrawShapesSelection();
        }
    }

    private void attemptBackgroundPaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Background_Color"), Color.blue);
        if (color != null) {
            this.backgroundPaintSample.setPaint(color);
        }
    }

    private void attemptOutlineStrokeSelection() {
        StrokeChooserPanel strokeChooserPanel = new StrokeChooserPanel(null, this.availableStrokeSamples);
        int n = JOptionPane.showConfirmDialog(this, strokeChooserPanel, localizationResources.getString("Stroke_Selection"), 2, -1);
        if (n == 0) {
            this.outlineStrokeSample.setStroke(strokeChooserPanel.getSelectedStroke());
        }
    }

    private void attemptOutlinePaintSelection() {
        Color color = JColorChooser.showDialog(this, localizationResources.getString("Outline_Color"), Color.blue);
        if (color != null) {
            this.outlinePaintSample.setPaint(color);
        }
    }

    private void attemptOrientationSelection() {
        int n = this.orientationCombo.getSelectedIndex();
        this.plotOrientation = n == 0 ? PlotOrientation.VERTICAL : PlotOrientation.HORIZONTAL;
    }

    private void attemptDrawLinesSelection() {
        this.drawLines = BooleanUtilities.valueOf(this.drawLinesCheckBox.isSelected());
    }

    private void attemptDrawShapesSelection() {
        this.drawShapes = BooleanUtilities.valueOf(this.drawShapesCheckBox.isSelected());
    }

    public final void updatePlotProperties(Plot plot) {
        LegendItemSource legendItemSource;
        Cloneable cloneable;
        plot.setOutlinePaint(this.getOutlinePaint());
        plot.setOutlineStroke(this.getOutlineStroke());
        plot.setBackgroundPaint(this.getBackgroundPaint());
        plot.setInsets(this.getPlotInsets());
        if (this.domainAxisPropertyPanel != null) {
            cloneable = null;
            if (plot instanceof CategoryPlot) {
                legendItemSource = (CategoryPlot)plot;
                cloneable = ((CategoryPlot)legendItemSource).getDomainAxis();
            } else if (plot instanceof XYPlot) {
                legendItemSource = (XYPlot)plot;
                cloneable = ((XYPlot)legendItemSource).getDomainAxis();
            }
            if (cloneable != null) {
                this.domainAxisPropertyPanel.setAxisProperties((Axis)cloneable);
            }
        }
        if (this.rangeAxisPropertyPanel != null) {
            cloneable = null;
            if (plot instanceof CategoryPlot) {
                legendItemSource = (CategoryPlot)plot;
                cloneable = ((CategoryPlot)legendItemSource).getRangeAxis();
            } else if (plot instanceof XYPlot) {
                legendItemSource = (XYPlot)plot;
                cloneable = ((XYPlot)legendItemSource).getRangeAxis();
            }
            if (cloneable != null) {
                this.rangeAxisPropertyPanel.setAxisProperties((Axis)cloneable);
            }
        }
        if (this.plotOrientation != null) {
            if (plot instanceof CategoryPlot) {
                cloneable = (CategoryPlot)plot;
                ((CategoryPlot)cloneable).setOrientation(this.plotOrientation);
            } else if (plot instanceof XYPlot) {
                cloneable = (XYPlot)plot;
                ((XYPlot)cloneable).setOrientation(this.plotOrientation);
            }
        }
        if (this.drawLines != null) {
            if (plot instanceof CategoryPlot) {
                cloneable = (CategoryPlot)plot;
                legendItemSource = ((CategoryPlot)cloneable).getRenderer();
                if (legendItemSource instanceof LineAndShapeRenderer) {
                    ((LineAndShapeRenderer)legendItemSource).setLinesVisible((boolean)this.drawLines);
                }
            } else if (plot instanceof XYPlot && (legendItemSource = ((XYPlot)(cloneable = (XYPlot)plot)).getRenderer()) instanceof StandardXYItemRenderer) {
                ((StandardXYItemRenderer)legendItemSource).setPlotLines(this.drawLines);
            }
        }
        if (this.drawShapes != null) {
            if (plot instanceof CategoryPlot) {
                cloneable = (CategoryPlot)plot;
                legendItemSource = ((CategoryPlot)cloneable).getRenderer();
                if (legendItemSource instanceof LineAndShapeRenderer) {
                    ((LineAndShapeRenderer)legendItemSource).setShapesVisible((boolean)this.drawShapes);
                }
            } else if (plot instanceof XYPlot && (legendItemSource = ((XYPlot)(cloneable = (XYPlot)plot)).getRenderer()) instanceof StandardXYItemRenderer) {
                ((StandardXYItemRenderer)legendItemSource).setBaseShapesVisible(this.drawShapes);
            }
        }
        if (this.colorBarAxisPropertyPanel != null) {
            cloneable = null;
            if (plot instanceof ContourPlot) {
                legendItemSource = (ContourPlot)plot;
                cloneable = ((ContourPlot)legendItemSource).getColorBar();
            }
            if (cloneable != null) {
                this.colorBarAxisPropertyPanel.setAxisProperties((ColorBar)cloneable);
            }
        }
    }
}

