/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.geom.Point2D;
import org.jfree.chart.plot.PlotOrientation;

public class CrosshairState {
    private boolean calculateDistanceInDataSpace = false;
    private double anchorX;
    private double anchorY;
    private Point2D anchor;
    private double crosshairX;
    private double crosshairY;
    private double distance;

    public CrosshairState() {
        this(false);
    }

    public CrosshairState(boolean bl) {
        this.calculateDistanceInDataSpace = bl;
    }

    public final void setCrosshairDistance(double d2) {
        this.distance = d2;
    }

    public final void updateCrosshairPoint(double d2, double d3, double d4, double d5, PlotOrientation plotOrientation) {
        if (this.anchor != null) {
            double d6 = 0.0;
            if (this.calculateDistanceInDataSpace) {
                d6 = (d2 - this.anchorX) * (d2 - this.anchorX) + (d3 - this.anchorY) * (d3 - this.anchorY);
            } else {
                double d7 = this.anchor.getX();
                double d8 = this.anchor.getY();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    double d9 = d8;
                    d8 = d7;
                    d7 = d9;
                }
                d6 = (d4 - d7) * (d4 - d7) + (d5 - d8) * (d5 - d8);
            }
            if (d6 < this.distance) {
                this.crosshairX = d2;
                this.crosshairY = d3;
                this.distance = d6;
            }
        }
    }

    public final void updateCrosshairX(double d2) {
        double d3 = Math.abs(d2 - this.anchorX);
        if (d3 < this.distance) {
            this.crosshairX = d2;
            this.distance = d3;
        }
    }

    public final void updateCrosshairY(double d2) {
        double d3 = Math.abs(d2 - this.anchorY);
        if (d3 < this.distance) {
            this.crosshairY = d2;
            this.distance = d3;
        }
    }

    public final void setAnchor(Point2D point2D) {
        this.anchor = point2D;
    }

    public final double getCrosshairX() {
        return this.crosshairX;
    }

    public final void setCrosshairX(double d2) {
        this.crosshairX = d2;
    }

    public final double getCrosshairY() {
        return this.crosshairY;
    }

    public final void setCrosshairY(double d2) {
        this.crosshairY = d2;
    }
}

