/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.ui.RectangleEdge;

public class GanttRenderer
extends IntervalBarRenderer
implements Serializable {
    private static final long serialVersionUID = -4010349116350119512L;
    private Paint completePaint;
    private Paint incompletePaint;
    private double startPercent;
    private double endPercent;

    public GanttRenderer() {
        this.setIncludeBaseInRange(false);
        this.completePaint = Color.green;
        this.incompletePaint = Color.red;
        this.startPercent = 0.35;
        this.endPercent = 0.65;
    }

    public Paint getCompletePaint() {
        return this.completePaint;
    }

    public void setCompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.completePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Paint getIncompletePaint() {
        return this.incompletePaint;
    }

    public void setIncompletePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.incompletePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getStartPercent() {
        return this.startPercent;
    }

    public void setStartPercent(double d2) {
        this.startPercent = d2;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getEndPercent() {
        return this.endPercent;
    }

    public void setEndPercent(double d2) {
        this.endPercent = d2;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (categoryDataset instanceof GanttCategoryDataset) {
            GanttCategoryDataset ganttCategoryDataset = (GanttCategoryDataset)categoryDataset;
            this.drawTasks(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        } else {
            super.drawItem(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, categoryDataset, n, n2, n3);
        }
    }

    protected void drawTasks(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        int n3 = ganttCategoryDataset.getSubIntervalCount(n, n2);
        if (n3 == 0) {
            this.drawTask(graphics2D, categoryItemRendererState, rectangle2D, categoryPlot, categoryAxis, valueAxis, ganttCategoryDataset, n, n2);
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            EntityCollection entityCollection;
            double d2;
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getStartValue(n, n2, i2);
            if (number == null) {
                return;
            }
            double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            Number number2 = ganttCategoryDataset.getEndValue(n, n2, i2);
            if (number2 == null) {
                return;
            }
            double d4 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            if (d4 < d3) {
                d2 = d4;
                d4 = d3;
                d3 = d2;
            }
            d2 = this.calculateBarW0(categoryPlot, categoryPlot.getOrientation(), rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
            double d5 = Math.abs(d4 - d3);
            double d6 = categoryItemRendererState.getBarWidth();
            Rectangle2D.Double double_ = null;
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d3, d2, d5, d6);
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d2, d3, d6, d5);
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number3 = ganttCategoryDataset.getPercentComplete(n, n2, i2);
            double d7 = this.getStartPercent();
            double d8 = this.getEndPercent();
            if (number3 != null) {
                double d9 = number3.doubleValue();
                if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d3, d2 + d7 * d6, d5 * d9, d6 * (d8 - d7));
                    double_3 = new Rectangle2D.Double(d3 + d5 * d9, d2 + d7 * d6, d5 * (1.0 - d9), d6 * (d8 - d7));
                } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d2 + d7 * d6, d3 + d5 * (1.0 - d9), d6 * (d8 - d7), d5 * d9);
                    double_3 = new Rectangle2D.Double(d2 + d7 * d6, d3, d6 * (d8 - d7), d5 * (1.0 - d9));
                }
            }
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (double_2 != null) {
                graphics2D.setPaint(this.getCompletePaint());
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.getIncompletePaint());
                graphics2D.fill(double_3);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_);
            }
            if (categoryItemRendererState.getInfo() == null || (entityCollection = categoryItemRendererState.getEntityCollection()) == null) continue;
            String string = null;
            if (this.getToolTipGenerator(n, n2) != null) {
                string = this.getToolTipGenerator(n, n2).generateToolTip(ganttCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, n, ganttCategoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }

    protected void drawTask(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
        Object object;
        Object object2;
        double d2;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        Number number = ganttCategoryDataset.getEndValue(n, n2);
        if (number == null) {
            return;
        }
        double d3 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = ganttCategoryDataset.getStartValue(n, n2);
        if (number2 == null) {
            return;
        }
        double d4 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        if (d4 < d3) {
            d2 = d4;
            d4 = d3;
            d3 = d2;
            Number number3 = number2;
            number2 = number;
            number = number3;
        }
        d2 = this.calculateBarW0(categoryPlot, plotOrientation, rectangle2D, categoryAxis, categoryItemRendererState, n, n2);
        double d5 = categoryItemRendererState.getBarWidth();
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_ = null;
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(d3, d2, d6, d5);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d2, d4, d5, d6);
        }
        Rectangle2D.Double double_2 = null;
        Rectangle2D.Double double_3 = null;
        Number number4 = ganttCategoryDataset.getPercentComplete(n, n2);
        double d7 = this.getStartPercent();
        double d8 = this.getEndPercent();
        if (number4 != null) {
            double d9 = number4.doubleValue();
            if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                double_2 = new Rectangle2D.Double(d3, d2 + d7 * d5, d6 * d9, d5 * (d8 - d7));
                double_3 = new Rectangle2D.Double(d3 + d6 * d9, d2 + d7 * d5, d6 * (1.0 - d9), d5 * (d8 - d7));
            } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                double_2 = new Rectangle2D.Double(d2 + d7 * d5, d4 + d6 * (1.0 - d9), d5 * (d8 - d7), d6 * d9);
                double_3 = new Rectangle2D.Double(d2 + d7 * d5, d4, d5 * (d8 - d7), d6 * (1.0 - d9));
            }
        }
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (double_2 != null) {
            graphics2D.setPaint(this.getCompletePaint());
            graphics2D.fill(double_2);
        }
        if (double_3 != null) {
            graphics2D.setPaint(this.getIncompletePaint());
            graphics2D.fill(double_3);
        }
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, ganttCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
        }
        if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(ganttCategoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, n, ganttCategoryDataset.getColumnKey(n2), n2);
            object.add(categoryItemEntity);
        }
    }
}

