/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.DataUtilities;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class StackedBarRenderer3D
extends BarRenderer3D
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -5832945916493247123L;
    private boolean renderAsPercentages;

    public StackedBarRenderer3D() {
        this(false);
    }

    public StackedBarRenderer3D(double d2, double d3) {
        super(d2, d3);
    }

    public StackedBarRenderer3D(boolean bl) {
        this.renderAsPercentages = bl;
    }

    public StackedBarRenderer3D(double d2, double d3, boolean bl) {
        super(d2, d3);
        this.renderAsPercentages = bl;
    }

    public boolean getRenderAsPercentages() {
        return this.renderAsPercentages;
    }

    public void setRenderAsPercentages(boolean bl) {
        this.renderAsPercentages = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Range findRangeBounds(CategoryDataset categoryDataset) {
        if (this.renderAsPercentages) {
            return new Range(0.0, 1.0);
        }
        return DatasetUtilities.findStackedRangeBounds(categoryDataset);
    }

    protected void calculateBarWidth(CategoryPlot categoryPlot, Rectangle2D rectangle2D, int n, CategoryItemRendererState categoryItemRendererState) {
        CategoryAxis categoryAxis = this.getDomainAxis(categoryPlot, n);
        CategoryDataset categoryDataset = categoryPlot.getDataset(n);
        if (categoryDataset != null) {
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            double d2 = 0.0;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d2 = rectangle2D.getHeight();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                d2 = rectangle2D.getWidth();
            }
            double d3 = d2 * this.getMaximumBarWidth();
            int n2 = categoryDataset.getColumnCount();
            double d4 = 0.0;
            if (n2 > 1) {
                d4 = categoryAxis.getCategoryMargin();
            }
            double d5 = d2 * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d4);
            if (n2 > 0) {
                categoryItemRendererState.setBarWidth(Math.min(d5 / (double)n2, d3));
            } else {
                categoryItemRendererState.setBarWidth(Math.min(d5, d3));
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        double d2;
        double d3;
        double d4;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d5 = number.doubleValue();
        double d6 = 0.0;
        if (this.renderAsPercentages) {
            d6 = DataUtilities.calculateColumnTotal(categoryDataset, n2);
            d5 /= d6;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d7 = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), double_, categoryPlot.getDomainAxisEdge()) - categoryItemRendererState.getBarWidth() / 2.0;
        double d8 = d4 = this.getBase();
        for (int i2 = 0; i2 < n; ++i2) {
            Number number2 = categoryDataset.getValue(i2, n2);
            if (number2 == null) continue;
            d3 = number2.doubleValue();
            if (this.renderAsPercentages) {
                d3 /= d6;
            }
            if (d3 > 0.0) {
                d4 += d3;
                continue;
            }
            d8 += d3;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        if (d5 > 0.0) {
            d2 = valueAxis.valueToJava2D(d4, double_, rectangleEdge);
            d3 = valueAxis.valueToJava2D(d4 + d5, double_, rectangleEdge);
        } else {
            d2 = valueAxis.valueToJava2D(d8, double_, rectangleEdge);
            d3 = valueAxis.valueToJava2D(d8 + d5, double_, rectangleEdge);
        }
        double d9 = Math.min(d2, d3);
        double d10 = Math.max(Math.abs(d3 - d2), this.getMinimumBarLength());
        Rectangle2D.Double double_2 = null;
        double_2 = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d9, d7, d10, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d7, d9, categoryItemRendererState.getBarWidth(), d10);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        if (n3 == 0) {
            EntityCollection entityCollection;
            double d11 = double_2.getMinX();
            double d12 = d11 + this.getXOffset();
            double d13 = double_2.getMaxX();
            double d14 = d13 + this.getXOffset();
            double d15 = double_2.getMinY() - this.getYOffset();
            double d16 = double_2.getMinY();
            double d17 = double_2.getMaxY() - this.getYOffset();
            double d18 = double_2.getMaxY();
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            if (d5 > 0.0 || plotOrientation == PlotOrientation.VERTICAL) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d13, (float)d18);
                generalPath.lineTo((float)d13, (float)d16);
                generalPath.lineTo((float)d14, (float)d15);
                generalPath.lineTo((float)d14, (float)d17);
                generalPath.closePath();
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
            }
            if (d5 > 0.0 || plotOrientation == PlotOrientation.HORIZONTAL) {
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d11, (float)d16);
                generalPath2.lineTo((float)d12, (float)d15);
                generalPath2.lineTo((float)d14, (float)d15);
                generalPath2.lineTo((float)d13, (float)d16);
                generalPath2.closePath();
                graphics2D.fill(generalPath2);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if ((entityCollection = categoryItemRendererState.getEntityCollection()) != null) {
                this.addItemEntity(entityCollection, categoryDataset, n, n2, double_2);
            }
        } else if (n3 == 1 && (categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_2, d5 < 0.0);
        }
    }

    public int getPassCount() {
        return 2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StackedBarRenderer3D)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        StackedBarRenderer3D stackedBarRenderer3D = (StackedBarRenderer3D)object;
        return this.renderAsPercentages == stackedBarRenderer3D.renderAsPercentages;
    }
}

