/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.xy;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataItem;
import org.jfree.util.ObjectUtilities;

public class XYSeries
extends Series
implements Cloneable,
Serializable {
    static final long serialVersionUID = -5908509288197150436L;
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;

    public XYSeries(Comparable comparable) {
        this(comparable, true, true);
    }

    public XYSeries(Comparable comparable, boolean bl) {
        this(comparable, bl, true);
    }

    public XYSeries(Comparable comparable, boolean bl, boolean bl2) {
        super(comparable);
        this.data = new ArrayList();
        this.autoSort = bl;
        this.allowDuplicateXValues = bl2;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    public int getItemCount() {
        return this.data.size();
    }

    public List getItems() {
        return Collections.unmodifiableList(this.data);
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
        boolean bl = false;
        while (this.data.size() > n) {
            this.data.remove(0);
            bl = true;
        }
        if (bl) {
            this.fireSeriesChanged();
        }
    }

    public void add(XYDataItem xYDataItem) {
        this.add(xYDataItem, true);
    }

    public void add(double d2, double d3) {
        this.add(new Double(d2), (Number)new Double(d3), true);
    }

    public void add(double d2, double d3, boolean bl) {
        this.add(new Double(d2), (Number)new Double(d3), bl);
    }

    public void add(double d2, Number number) {
        this.add(new Double(d2), number);
    }

    public void add(double d2, Number number, boolean bl) {
        this.add(new Double(d2), number, bl);
    }

    public void add(Number number, Number number2) {
        this.add(number, number2, true);
    }

    public void add(Number number, Number number2, boolean bl) {
        XYDataItem xYDataItem = new XYDataItem(number, number2);
        this.add(xYDataItem, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(XYDataItem xYDataItem, boolean bl) {
        if (xYDataItem == null) {
            throw new IllegalArgumentException("Null 'item' argument.");
        }
        if (this.autoSort) {
            int n = Collections.binarySearch(this.data, xYDataItem);
            if (n < 0) {
                this.data.add(-n - 1, xYDataItem);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int n2 = this.data.size();
                while (n < n2 && xYDataItem.compareTo(this.data.get(n)) == 0) {
                    ++n;
                }
                if (n < this.data.size()) {
                    this.data.add(n, xYDataItem);
                } else {
                    this.data.add(xYDataItem);
                }
            }
        } else {
            int n;
            if (!this.allowDuplicateXValues && (n = this.indexOf(xYDataItem.getX())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(xYDataItem);
        }
        if (this.getItemCount() > this.maximumItemCount) {
            this.data.remove(0);
        }
        if (!bl) return;
        this.fireSeriesChanged();
    }

    public void delete(int n, int n2) {
        for (int i2 = n; i2 <= n2; ++i2) {
            this.data.remove(n);
        }
        this.fireSeriesChanged();
    }

    public XYDataItem remove(int n) {
        XYDataItem xYDataItem = (XYDataItem)this.data.remove(n);
        this.fireSeriesChanged();
        return xYDataItem;
    }

    public XYDataItem remove(Number number) {
        return this.remove(this.indexOf(number));
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataItem getDataItem(int n) {
        return (XYDataItem)this.data.get(n);
    }

    public Number getX(int n) {
        return this.getDataItem(n).getX();
    }

    public Number getY(int n) {
        return this.getDataItem(n).getY();
    }

    public void update(int n, Number number) {
        XYDataItem xYDataItem = this.getDataItem(n);
        xYDataItem.setY(number);
        this.fireSeriesChanged();
    }

    public void updateByIndex(int n, Number number) {
        this.update(n, number);
    }

    public void update(Number number, Number number2) {
        int n = this.indexOf(number);
        if (n < 0) {
            throw new SeriesException("No observation for x = " + number);
        }
        XYDataItem xYDataItem = this.getDataItem(n);
        xYDataItem.setY(number2);
        this.fireSeriesChanged();
    }

    public XYDataItem addOrUpdate(Number number, Number number2) {
        if (number == null) {
            throw new IllegalArgumentException("Null 'x' argument.");
        }
        XYDataItem xYDataItem = null;
        int n = this.indexOf(number);
        if (n >= 0) {
            XYDataItem xYDataItem2 = (XYDataItem)this.data.get(n);
            try {
                xYDataItem = (XYDataItem)xYDataItem2.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new SeriesException("Couldn't clone XYDataItem!");
            }
            xYDataItem2.setY(number2);
        } else {
            if (this.autoSort) {
                this.data.add(-n - 1, new XYDataItem(number, number2));
            } else {
                this.data.add(new XYDataItem(number, number2));
            }
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
        }
        this.fireSeriesChanged();
        return xYDataItem;
    }

    public int indexOf(Number number) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new XYDataItem(number, null));
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            XYDataItem xYDataItem = (XYDataItem)this.data.get(i2);
            if (!xYDataItem.getX().equals(number)) continue;
            return i2;
        }
        return -1;
    }

    public Object clone() {
        XYSeries xYSeries = this.createCopy(0, this.getItemCount() - 1);
        return xYSeries;
    }

    public XYSeries createCopy(int n, int n2) {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            for (int i2 = n; i2 <= n2; ++i2) {
                XYDataItem xYDataItem = (XYDataItem)this.data.get(i2);
                XYDataItem xYDataItem2 = (XYDataItem)xYDataItem.clone();
                try {
                    xYSeries.add(xYDataItem2);
                    continue;
                }
                catch (SeriesException seriesException) {
                    System.err.println("Unable to add cloned data item.");
                }
            }
        }
        return xYSeries;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYSeries xYSeries = (XYSeries)object;
        if (this.maximumItemCount != xYSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != xYSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != xYSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, xYSeries.data);
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 29 * n + (this.data != null ? ((Object)this.data).hashCode() : 0);
        n = 29 * n + this.maximumItemCount;
        n = 29 * n + (this.autoSort ? 1 : 0);
        n = 29 * n + (this.allowDuplicateXValues ? 1 : 0);
        return n;
    }
}

