/*
 * Decompiled with CFR 0.152.
 */
package xtools.api;

import edu.mit.broad.genome.Conf;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.ColorMap$Rows;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.reports.api.ReportIndexState;
import edu.mit.broad.genome.reports.api.ToolReport;
import edu.mit.broad.genome.utils.ClassUtils;
import edu.mit.broad.genome.utils.CmdLineArgs;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.genome.utils.Timer;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.ecs.html.Div;
import org.apache.ecs.html.H4;
import org.apache.log4j.Logger;
import xtools.api.Tool;
import xtools.api.UnitTestTool;
import xtools.api.XToolsApplication;
import xtools.api.param.BooleanParam;
import xtools.api.param.ChipChooserMultiParam;
import xtools.api.param.ChipOptParam;
import xtools.api.param.ChipReqdParam;
import xtools.api.param.DataframeOptParam;
import xtools.api.param.DatasetOptParam;
import xtools.api.param.DatasetReqdParam;
import xtools.api.param.GeneSetOptParam;
import xtools.api.param.GenesOfInterestParam;
import xtools.api.param.GuiParam;
import xtools.api.param.Param;
import xtools.api.param.ParamSet;
import xtools.api.param.ProbesParam;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;
import xtools.api.param.SampleAnnotParam;
import xtools.api.param.TemplateMultiChooserParam;
import xtools.api.param.ToolParamSet;

public abstract class AbstractTool
extends UnitTestTool
implements Tool {
    public static final String REPORT_INDEX = "xtools.report_index";
    private PrintStream fOut;
    protected transient Logger log;
    protected static final transient Logger klog;
    protected ToolParamSet fParamSet;
    private Timer fTimer;
    private boolean fHelpMode;
    protected static final Object[] EMPTY_OBJECTS;
    private boolean fKillRequested;
    protected final BooleanParam fHelpParam = new BooleanParam("help", "Usage information on the tool", false);
    private ReportDirParam fReportDirParam;
    private GuiParam fGuiParam;
    private ReportLabelParam fRptLabelParam;
    protected ToolReport fReport;
    private static int SHARED_PARAM_CNT;

    protected AbstractTool() {
        this("dummy");
    }

    @Override
    public String getHelpURL() {
        return JarResources.getHelpURL(this.getName());
    }

    @Override
    public void setOutputStream(PrintStream printStream) {
        if (printStream == null) {
            throw new IllegalArgumentException("Param sout cannot be null");
        }
        this.fOut = printStream;
    }

    public final PrintStream getOutputStream() {
        if (this.fOut == null) {
            this.fOut = System.out;
        }
        return this.fOut;
    }

    protected AbstractTool(String string) {
        super(string);
        this.fTimer = new Timer();
        this.log = XLogger.getLogger(this.getClass());
        if (!Application.isHandlerSet()) {
            Application.registerHandler(new XToolsApplication());
        }
        this.fParamSet = new ToolParamSet();
        this.fGuiParam = new GuiParam();
        this.fRptLabelParam = new ReportLabelParam(false);
        this.fReportDirParam = new ReportDirParam(false);
        this.fParamSet.addParam(this.fGuiParam);
        this.fParamSet.addParam(this.fReportDirParam);
        this.fParamSet.addParam(this.fRptLabelParam);
    }

    protected final void init(Properties properties) {
        this.fParamSet.addParam(this.fHelpParam);
        this.declareParams();
        if (properties != null && (properties.containsKey("help") || properties.containsKey("HELP"))) {
            this.fHelpMode = true;
        }
        if (this.isHelpMode()) {
            this.fParamSet.printfUsage();
            Conf.exitSystem(false);
        } else {
            this.fParamSet.fill(properties);
            this.fParamSet.check();
            this.ensureAllDeclaredWereAdded();
            this.checkHeadlessState();
        }
    }

    protected final void init(String[] stringArray) {
        try {
            String string;
            Properties properties = CmdLineArgs.parse(stringArray);
            String string2 = CmdLineArgs.toString(stringArray);
            int n = string2.indexOf("help");
            if (n != -1) {
                properties.setProperty("help", Boolean.TRUE.toString());
            }
            if ((string = properties.getProperty("param_file")) != null && string.length() > 0) {
                this.enhanceParams(string, properties);
            }
            this.init(properties);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.fReport != null) {
                this.fReport.setErroredOut();
            } else {
                this.log.info("No report dir was made yet (analysis errored out)");
            }
            Conf.exitSystem(true);
        }
    }

    private void enhanceParams(String string, Properties properties) {
        Properties properties2 = ParseUtils.readKeyVal(string, false, true, false);
        Iterator<Object> iterator = properties2.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString();
            String string3 = properties2.getProperty(string2);
            if (properties.containsKey(string2)) {
                String string4 = properties.getProperty(string2);
                if (string3.equals(string4)) continue;
                this.log.warn("Ignoring param_file key: " + string2 + " value: " + string3 + " in favor of cmd line value: " + string4);
                continue;
            }
            properties.setProperty(string2, string3);
        }
    }

    protected final void startExec() {
        this.startExec(this.getHeader());
    }

    protected final String getHeader() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<div id=\"footer\" style=\"width: 905; height: 35\">\n").append("<h3 style=\"text-align: left\"><font color=\"#808080\">Report for: ").append(this.getName()).append("</font></h3>\n").append("</div>");
        return stringBuffer.toString();
    }

    protected final void startExec(String string) {
        this.startExec(this.makeReportIndexPage(), string);
    }

    protected final void startExec(ReportIndexState reportIndexState) {
        this.fTimer.start();
        this.fReport = new ToolReport(this, true, reportIndexState);
    }

    protected final void startExec(boolean bl, boolean bl2, boolean bl3) {
        this.startExec(new ReportIndexState(bl, bl2, bl3, this.getHeader()));
    }

    protected final void startExec(boolean bl) {
        this.startExec(bl, this.getHeader());
    }

    protected final void startExec(boolean bl, boolean bl2) {
        this.startExec(new ReportIndexState(bl, bl2, false, this.getHeader()));
    }

    protected final void startExec(boolean bl, String string) {
        this.startExec(new ReportIndexState(bl, string));
    }

    private boolean makeReportIndexPage() {
        String string = System.getProperty(REPORT_INDEX);
        if (string == null || string.length() == 0) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public final void doneExec() {
        if (!this.fReport.getToolComments().isEmpty()) {
            Div div = new Div();
            H4 h4 = new H4("Comments");
            div.addElement(h4);
            div.addElement(this.fReport.getToolComments().toHTML());
            if (this.fReport.getIndexPage() != null) {
                this.fReport.getIndexPage().addBlock(div, false);
            }
        }
        this.fReport.closeReport(true);
        if (this.fGuiParam.isTrue()) {
            this.fReport.display();
        }
        this.fTimer.stop();
        this.fTimer.printTimeTakenS();
    }

    @Override
    public Report getReport() {
        return this.fReport;
    }

    private void checkHeadlessState() {
    }

    private int countParamFields(Class clazz) {
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = 0;
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            Class<?> clazz2 = fieldArray[i2].getType();
            boolean bl = Param.class.isAssignableFrom(clazz2);
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void requestKill() {
        this.fKillRequested = true;
    }

    protected final boolean isKillRequested() {
        return this.fKillRequested;
    }

    protected final void ensureAllDeclaredWereAdded() {
        int n = SHARED_PARAM_CNT;
        n += this.countParamFields(this.getClass());
        if (!this.getClass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            n += this.countParamFields(this.getClass().getSuperclass());
        }
        if (!this.getClass().getSuperclass().getSuperclass().getName().equals("xtools.api.AbstractTool")) {
            n += this.countParamFields(this.getClass().getSuperclass().getSuperclass());
        }
        if (this.fParamSet.getNumParams() != n) {
            StringBuffer stringBuffer = new StringBuffer("Have you forgotten to update declareParams()?").append('\n');
            stringBuffer.append("In ParamSet # declared: ").append(this.fParamSet.getNumParams()).append(" is NOT equal to deduced thro reflection # : ").append(n);
            throw new IllegalStateException(stringBuffer.toString());
        }
    }

    public final boolean isHelpMode() {
        return this.fHelpMode;
    }

    @Override
    public ParamSet getParamSet() {
        this.fParamSet.sort();
        return this.fParamSet;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getTitle() {
        String string = ClassUtils.shorten(this.getName());
        String string2 = this.getDesc();
        if (string2 == null || string2.length() == 0) {
            return "<html><body><b>" + string + "</b>" + "</body></html>";
        }
        return "<html><body><b>" + string + "</b>: " + string2 + "</body></html>";
    }

    @Override
    public String getDesc() {
        return "";
    }

    @Override
    public void printfUsage() {
        this.fParamSet.printfUsage();
    }

    @Override
    public long getExecutionTime() {
        return this.fTimer.getTimeTaken();
    }

    @Override
    public long getStartTime() {
        return this.fTimer.getStartTime();
    }

    @Override
    public long getStopTime() {
        return this.fTimer.getStopTime();
    }

    protected static final void addDT(DatasetReqdParam datasetReqdParam, TemplateMultiChooserParam templateMultiChooserParam, List list, List list2) {
        if (datasetReqdParam.isSpecified() && !templateMultiChooserParam.isSpecified() || !datasetReqdParam.isSpecified() && templateMultiChooserParam.isSpecified()) {
            throw new IllegalArgumentException("Both ds and template (or neither) must be specified");
        }
        if (!datasetReqdParam.isSpecified()) {
            return;
        }
        Dataset dataset = datasetReqdParam.getDataset();
        Template[] templateArray = templateMultiChooserParam.getTemplates(dataset);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            Template template = templateArray[i2];
            list2.add(template);
            list.add(dataset);
        }
    }

    protected static final void addDT(DatasetOptParam datasetOptParam, TemplateMultiChooserParam templateMultiChooserParam, List list, List list2) {
        if (!datasetOptParam.isSpecified()) {
            return;
        }
        if (!templateMultiChooserParam.isSpecified()) {
            throw new IllegalArgumentException("No tss specified while dataset param is specified is invalid");
        }
        Dataset dataset = datasetOptParam.getDataset();
        Template[] templateArray = templateMultiChooserParam.getTemplates(dataset);
        for (int i2 = 0; i2 < templateArray.length; ++i2) {
            Template template = templateArray[i2];
            list2.add(template);
            list.add(dataset);
        }
    }

    public final Dataset getDataset(DatasetOptParam datasetOptParam, DataframeOptParam dataframeOptParam) {
        this.ensureAtLeastAndOnlyOneSpecified(new Param[]{datasetOptParam, dataframeOptParam});
        if (datasetOptParam != null && datasetOptParam.isSpecified()) {
            return datasetOptParam.getDataset();
        }
        if (dataframeOptParam != null && dataframeOptParam.isSpecified()) {
            return dataframeOptParam.getDataframe().toDataset(true);
        }
        throw new IllegalArgumentException("Either dataset or d must be specified");
    }

    protected static final void enforceDatasetEqualRowLengths(DatasetReqdParam datasetReqdParam, DatasetOptParam[] datasetOptParamArray) {
        int n = datasetReqdParam.getDataset().getNumRow();
        for (int i2 = 0; i2 < datasetOptParamArray.length; ++i2) {
            if (!datasetOptParamArray[i2].isSpecified() || n == datasetOptParamArray[i2].getDataset().getNumRow()) continue;
            throw new IllegalArgumentException("num rows in datasets must be equal a: " + n + " but found: " + datasetOptParamArray[i2].getDataset().getNumRow() + " at pos: " + i2 + " " + datasetOptParamArray[i2].getDataset().getName());
        }
    }

    public static final void ensureIfSpecifiedThenBothAreSpecified(Param param, Param param2) {
        boolean bl = false;
        if (param != null && param.isSpecified()) {
            bl = true;
        }
        boolean bl2 = false;
        if (param2 != null && param2.isSpecified()) {
            bl2 = true;
        }
        if (bl && !bl2 || !bl && bl2) {
            if (param != null && param2 != null) {
                throw new IllegalArgumentException("If specified then both of these params need to be specified: a: " + param.getName() + " b: " + param2.getName());
            }
            throw new IllegalArgumentException("If specified then both of these params need to be specified");
        }
    }

    public static final void ensureIfSpecifiedThenOnlyOneIsSpecified(Param param, Param param2) {
        boolean bl = false;
        if (param != null && param.isSpecified()) {
            bl = true;
        }
        boolean bl2 = false;
        if (param2 != null && param2.isSpecified()) {
            bl2 = true;
        }
        if (bl && bl2) {
            throw new IllegalArgumentException("If specified then only one of these params need to be specified: a: " + param.getName() + " b: " + param2.getName());
        }
    }

    protected final void ensureAtLeastAndOnlyOneSpecified(Param[] paramArray) {
        if (paramArray == null) {
            throw new IllegalArgumentException("Parameter params cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            if (!paramArray[i2].isSpecified()) continue;
            ++n;
        }
        if (n == 1) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Total Specified: " + n).append('\n');
        for (int i3 = 0; i3 < paramArray.length; ++i3) {
            stringBuffer.append(paramArray[i3].getName()).append(' ');
        }
        throw new IllegalArgumentException("At LEAST & only ONE of the following parameters must be specified: " + stringBuffer.toString());
    }

    protected final void ensureAtLeastOneSpecified(Param[] paramArray) {
        if (paramArray == null) {
            throw new IllegalArgumentException("Parameter params cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            if (!paramArray[i2].isSpecified()) continue;
            ++n;
        }
        if (n > 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("Total Specified: " + n).append('\n');
        for (int i3 = 0; i3 < paramArray.length; ++i3) {
            stringBuffer.append('>').append(paramArray[i3].getName()).append("< ").append(paramArray[i3].getDesc()).append('\n');
        }
        throw new IllegalArgumentException("At LEAST of the following parameters must be specified: " + stringBuffer.toString());
    }

    protected static final void tool_main(AbstractTool abstractTool) {
        if (abstractTool == null) {
            throw new IllegalArgumentException("Param tool cannot be null");
        }
        boolean bl = false;
        try {
            abstractTool.execute();
        }
        catch (Throwable throwable) {
            bl = true;
            throwable.printStackTrace();
        }
        if (bl && abstractTool.getReport() != null) {
            abstractTool.getReport().setErroredOut();
        }
        if (abstractTool.getParamSet().getGuiParam().isFalse()) {
            Conf.exitSystem(bl);
        }
    }

    protected static final String removeExtension(PersistentObject persistentObject) {
        return NamingConventions.removeExtension(persistentObject);
    }

    public static final GeneSet[] getGeneSets(GeneSetOptParam[] geneSetOptParamArray) {
        ArrayList<GeneSet> arrayList = new ArrayList<GeneSet>();
        for (int i2 = 0; i2 < geneSetOptParamArray.length; ++i2) {
            if (!geneSetOptParamArray[i2].isSpecified()) continue;
            arrayList.add(geneSetOptParamArray[i2].getGeneSet());
        }
        return arrayList.toArray(new GeneSet[arrayList.size()]);
    }

    protected static final SampleAnnot getSampleAnnot(SampleAnnotParam sampleAnnotParam) {
        if (sampleAnnotParam != null && sampleAnnotParam.isSpecified()) {
            return sampleAnnotParam.getAnnot();
        }
        SampleAnnot sampleAnnot = Application.getVdbManager().getDefaultSampleAnnot();
        if (sampleAnnot != null) {
            return sampleAnnot;
        }
        return null;
    }

    public static final void setSampleAnnot(Dataset dataset, SampleAnnotParam sampleAnnotParam) {
        if (sampleAnnotParam != null && sampleAnnotParam.isSpecified()) {
            dataset.getAnnot().setSampleAnnot(sampleAnnotParam.getAnnot());
        }
    }

    public static final void setSampleAnnot(Dataset dataset, SampleAnnot sampleAnnot) {
        dataset.getAnnot().setSampleAnnot(sampleAnnot);
    }

    public static final void setChip(Dataset dataset, ChipOptParam chipOptParam, GenesOfInterestParam genesOfInterestParam) {
        if (chipOptParam != null && chipOptParam.isSpecified()) {
            AbstractTool.setChip(dataset, chipOptParam.getChip(), genesOfInterestParam);
        }
    }

    public static final void setChip(Dataset dataset, ChipOptParam chipOptParam) {
        AbstractTool.setChip(dataset, chipOptParam, null);
    }

    public static final void setChip(Dataset dataset, ChipChooserMultiParam chipChooserMultiParam, GenesOfInterestParam genesOfInterestParam) {
        if (chipChooserMultiParam != null && chipChooserMultiParam.isSpecified()) {
            AbstractTool.setChip(dataset, chipChooserMultiParam.getChipCombo(), genesOfInterestParam);
        }
    }

    public static final void setChip(Dataset dataset, ChipChooserMultiParam chipChooserMultiParam) {
        if (chipChooserMultiParam != null && chipChooserMultiParam.isSpecified()) {
            AbstractTool.setChip(dataset, chipChooserMultiParam.getChipCombo(), (GenesOfInterestParam)null);
        }
    }

    public static final void setChip(Dataset dataset, ChipReqdParam chipReqdParam, GenesOfInterestParam genesOfInterestParam) {
        if (chipReqdParam != null) {
            AbstractTool.setChip(dataset, chipReqdParam.getChip(), genesOfInterestParam);
        }
    }

    public static final void setChip(Dataset dataset, Chip chip) {
        AbstractTool.setChip(dataset, chip, (GenesOfInterest)null);
    }

    public static final void setChip(Dataset dataset, Chip chip, GenesOfInterestParam genesOfInterestParam) {
        GenesOfInterest genesOfInterest = null;
        if (genesOfInterestParam != null && genesOfInterestParam.isSpecified()) {
            genesOfInterest = genesOfInterestParam.getGenesOfInterest();
        }
        AbstractTool.setChip(dataset, chip, genesOfInterest);
    }

    public static final void setChip(Dataset dataset, Chip chip, GenesOfInterest genesOfInterest) {
        if (chip != null) {
            ColorMap$Rows colorMap$Rows = null;
            if (genesOfInterest != null) {
                colorMap$Rows = genesOfInterest.getAsColorMap();
            } else if (VdbRuntimeResources.getDefaultGenesOfInterest() != null) {
                colorMap$Rows = VdbRuntimeResources.getDefaultGenesOfInterest().getAsColorMap();
            }
            dataset.getAnnot().setChip(chip, colorMap$Rows);
        }
    }

    protected static final File getFile(String string, File file) {
        File[] fileArray = file.listFiles();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].getName().endsWith(string)) continue;
            return fileArray[i2];
        }
        throw new IllegalArgumentException("No file with ext: " + string + " found in: " + file);
    }

    protected static final boolean isCreateSubDir(Object[] objectArray) {
        if (objectArray == null) {
            return false;
        }
        return objectArray.length > 1;
    }

    protected static final Template[] getTemplates(Dataset dataset, TemplateMultiChooserParam templateMultiChooserParam, ProbesParam probesParam) {
        if (templateMultiChooserParam.isSpecified()) {
            return templateMultiChooserParam.getTemplates(dataset);
        }
        if (probesParam.isSpecified()) {
            String[] stringArray = probesParam.getProbeNames();
            return TemplateFactory.createContinuousTemplates(stringArray, dataset);
        }
        return new Template[0];
    }

    static {
        if (!SystemUtils.isPropertyDefined("java.awt.headless")) {
            System.setProperty("java.awt.headless", "true");
        }
        klog = XLogger.getLogger(AbstractTool.class);
        EMPTY_OBJECTS = new Object[0];
        SHARED_PARAM_CNT = 4;
    }
}

