/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import xtools.api.param.FileParam;
import xtools.api.param.ParamHelper;

public class DirParam
extends FileParam {
    protected GDirFieldPlusChooser fChooser;

    public DirParam(String string, String string2, String string3, File file, boolean bl) {
        this(string, string2, string3, new File[]{file}, bl);
    }

    public DirParam(boolean bl) {
        this("dir", "Path to dir", "Path to data dir", new File[0], bl);
    }

    public DirParam(String string, String string2, String string3, File[] fileArray, boolean bl) {
        super(string, string2, string3, fileArray, bl);
    }

    public DirParam(String string, String string2, String string3, boolean bl) {
        super(string, string2, string3, new File[0], bl);
    }

    public DirParam(String string, String string2, boolean bl) {
        super(string, string, string2, new File[0], bl);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            super.setValue(object);
        } else if (object instanceof File) {
            this.setValue((File)object);
        } else if (object instanceof String) {
            this.setValue(new File(object.toString()));
        } else {
            throw new IllegalArgumentException("Invalid type, only File and String accepted. Specified: " + object + " class: " + object.getClass());
        }
    }

    @Override
    public final void setValue(String string) {
        this.setValue(new File(string));
    }

    @Override
    public final void setValue(File file) {
        super.setValue(file);
    }

    @Override
    public boolean isFileBased() {
        return true;
    }

    public final File getDir() {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return (File)object;
    }

    public final File[] getFiles(DataFormat[] dataFormatArray) {
        FilenameFilter filenameFilter = DataFormat.createFilenameFilter(dataFormatArray);
        return this.getDir().listFiles(filenameFilter);
    }

    public final File[] getFiles(String[] stringArray) {
        FilenameFilter filenameFilter = DataFormat.createFilenameFilter(stringArray);
        return this.getDir().listFiles(filenameFilter);
    }

    public final File[] getFiles(String string) {
        return this.getFiles(new String[]{string});
    }

    public final File[] getFiles(boolean bl) {
        File[] fileArray = this.getDir().listFiles();
        if (bl) {
            ArrayList<File> arrayList = new ArrayList<File>();
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                if (!fileArray[i2].isFile()) continue;
                arrayList.add(fileArray[i2]);
            }
            return arrayList.toArray(new File[arrayList.size()]);
        }
        return fileArray;
    }

    public final File[] getSubDirs() {
        File[] fileArray = this.getDir().listFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i2 = 0; i2 < fileArray.length; ++i2) {
            if (!fileArray[i2].isDirectory()) continue;
            arrayList.add(fileArray[i2]);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        File file = (File)this.getValue();
        if (bl) {
            return file.getAbsolutePath();
        }
        return file.getName();
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            this.fChooser = new GDirFieldPlusChooser();
            if (this.getValue() != null) {
                this.fChooser.setValue(this.getValue());
            } else {
                this.fChooser.setValue(this.getDefault());
            }
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }
}

