/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.param;

import edu.mit.broad.genome.math.Vector;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GStringsInputFieldPlusChooser;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import xtools.api.param.AbstractParam;
import xtools.api.param.ParamHelper;

public class StringMultiInputParam
extends AbstractParam {
    private GStringsInputFieldPlusChooser fChooser;
    private static final String PARSE_DELIMS = ",\t\n";

    public StringMultiInputParam(String string, String string2, String string3, boolean bl) {
        this(string, string2, new String[]{string3}, bl);
    }

    public StringMultiInputParam(String string, String string2, boolean bl) {
        this(string, string2, new String[0], bl);
    }

    public StringMultiInputParam(String string, String string2, String string3, String[] stringArray, boolean bl) {
        super(string, string2, String.class, string3, (Object[])stringArray, bl);
    }

    public StringMultiInputParam(String string, String string2, String[] stringArray, boolean bl) {
        super(string, String.class, string2, (Object[])stringArray, bl);
    }

    @Override
    public void setValue(Object object) {
        if (object == null) {
            super.setValue(object);
        } else if (object instanceof String[]) {
            super.setValue(object);
        } else if (object instanceof String) {
            super.setValue(this._parse((String)object));
        } else {
            throw new IllegalArgumentException("Invalid type, only String[] and comma-delim parsable String accepted. Specified: " + object + " class: " + object.getClass());
        }
    }

    @Override
    public boolean isSpecified() {
        boolean bl = super.isSpecified();
        if (!bl) {
            return bl;
        }
        Object object = super.getValue();
        if (object == null) {
            return false;
        }
        String[] stringArray = this.getStrings();
        return stringArray.length != 0;
    }

    private String[] _parse(String string) {
        return ParseUtils.string2strings(string, PARSE_DELIMS, false);
    }

    public final void setValue(String string) {
        super.setValue(this._parse(string));
    }

    public final void setValue(String[] stringArray) {
        super.setValue(stringArray);
    }

    public final GeneSet getAsGeneSet(String string) {
        return new FSet(string, this.getStrings());
    }

    public final GeneSet getAsGeneSet() {
        return this.getAsGeneSet(this.getName());
    }

    public final String[] getStrings() {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            if (string.length() != 0) {
                return new String[]{string};
            }
            return null;
        }
        return (String[])object;
    }

    public final float[] getFloats() {
        String[] stringArray = this.getStrings();
        float[] fArray = new float[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            fArray[i2] = Float.parseFloat(stringArray[i2]);
        }
        return fArray;
    }

    public final Vector getAsVector() {
        return new Vector(this.getFloats());
    }

    public final int[] getInts() {
        String[] stringArray = this.getStrings();
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = Integer.parseInt(stringArray[i2]);
        }
        return nArray;
    }

    public final Set getStringsS() {
        String[] stringArray = this.getStrings();
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return hashSet;
    }

    public final String[] getStringsUnique() {
        String[] stringArray = this.getStrings();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (arrayList.indexOf(stringArray[i2]) != -1) continue;
            arrayList.add(stringArray[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public final String getString(int n) {
        Object object = super.getValue();
        if (object == null) {
            throw new NullPointerException("Null param value. Always check isSpecified() before calling");
        }
        return ((String[])object)[n];
    }

    @Override
    public String getValueStringRepresentation(boolean bl) {
        Object object = this.getValue();
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        Object[] objectArray = (String[])object;
        return StringMultiInputParam.format(objectArray);
    }

    protected static final String format(Object[] objectArray) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            if (objectArray[i2] == null) continue;
            stringBuffer.append(objectArray[i2].toString().trim());
            if (i2 == objectArray.length - 1) continue;
            stringBuffer.append(',');
        }
        return stringBuffer.toString();
    }

    public final int size() {
        return ((String[])this.getValue()).length;
    }

    public final void ensureUnique() {
        HashSet<String> hashSet = new HashSet<String>(this.size());
        for (int i2 = 0; i2 < this.size(); ++i2) {
            if (hashSet.contains(this.getString(i2))) {
                throw new IllegalArgumentException("Duplicated String param: " + this.getString(i2));
            }
            hashSet.add(this.getString(i2));
        }
    }

    @Override
    public GFieldPlusChooser getSelectionComponent() {
        if (this.fChooser == null) {
            String string = this.getValueStringRepresentation(false);
            if (string == null) {
                string = StringMultiInputParam.format((String[])this.getDefault());
            }
            if (string == null) {
                string = "";
            }
            this.fChooser = new GStringsInputFieldPlusChooser(string, PARSE_DELIMS);
            ParamHelper.addDocumentListener(this.fChooser.getTextField(), this);
        }
        return this.fChooser;
    }

    @Override
    public boolean isFileBased() {
        return false;
    }
}

