/*
 * Decompiled with CFR 0.152.
 */
package xtools.api.ui;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.RendererFactory2$CommonLookListRenderer;
import edu.mit.broad.xbench.core.ObjectBindery;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.log4j.Logger;
import xtools.api.ui.ChooserPanel;
import xtools.api.ui.NamedModel;

public class GeneSetTabbedChooserPanel
extends JTabbedPane
implements ChooserPanel {
    private static final Logger klog = XLogger.getLogger(GeneSetTabbedChooserPanel.class);
    private JList jlGeneSet;
    private JTextArea taGenes;
    private NamedModel fModel = new NamedModel("GeneSets(grp)", ObjectBindery.getModel(GeneSet.class));
    private int fSelectionMode = 0;

    public GeneSetTabbedChooserPanel(int n) {
        this.jlGeneSet = new JList();
        RendererFactory2$CommonLookListRenderer rendererFactory2$CommonLookListRenderer = new RendererFactory2$CommonLookListRenderer();
        this.jlGeneSet.setCellRenderer(rendererFactory2$CommonLookListRenderer);
        this.fSelectionMode = n;
        this.jlGeneSet.setModel(this.fModel.model);
        this.jlGeneSet.setSelectionMode(n);
        this.taGenes = new JTextArea();
        this.taGenes.setText("");
        this.addTab(this.fModel.name, new JScrollPane(this.jlGeneSet));
        this.addTab("Text Entry", new JScrollPane(this.taGenes));
    }

    @Override
    public final JComponent getChooser() {
        return this;
    }

    @Override
    public final String getTitle() {
        String string = "Select a gene set";
        if (this.fSelectionMode == 2) {
            string = "Select one or more gene set(s)";
        }
        return string;
    }

    @Override
    public final Object[] getChoosenObjects() {
        String[] stringArray;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Object[] objectArray = this.jlGeneSet.getSelectedValues();
        if (objectArray != null) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                if (objectArray[i2] == null) continue;
                arrayList.add(objectArray[i2]);
            }
        }
        if ((string = this.taGenes.getText()) != null && (stringArray = ParseUtils.string2strings(string, "\t\n", false)).length != 0) {
            FSet fSet = new FSet("from_text_area_", stringArray);
            try {
                ParserFactory.save(fSet, File.createTempFile(fSet.getName(), ".grp"));
            }
            catch (Throwable throwable) {
                klog.error(throwable);
            }
            arrayList.add(fSet);
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    @Override
    public final JList[] getJListsForDoubleClick() {
        return new JList[]{this.jlGeneSet};
    }

    public final void setListSelectionMode(int n) {
        this.fSelectionMode = n;
        if (this.jlGeneSet == null) {
            return;
        }
        this.jlGeneSet.setSelectionMode(this.fSelectionMode);
    }
}

